<?php

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use ToStartWork\Mail\UserAppliedToCourse;

class UserTest extends TestCase
{
    use DatabaseMigrations;

    public function setUp()
    {
        parent::setUp(); // TODO: Change the autogenerated stub

        $this->withoutMiddleware();
    }

    public function testUserHasManyCourses()
    {
        $user = factory(\ToStartWork\User::class, 1)->create();
        $courses = factory(\ToStartWork\Course::class, 2)->create();

        foreach ($courses as $course) {
            $course->apply($user);
        }

        $this->assertCount(2, $user->courses);
    }
    
    public function testUserHasManyContacts()
    {
        $user = factory(\ToStartWork\User::class, 1)->create();
        $contacts = factory(\ToStartWork\Contact::class, 2)->create(['user_id' => $user->id]);


        $this->assertCount(2, $user->contacts);
    }

    public function testUserUpdateProfile()
    {
        $user = factory(\ToStartWork\User::class, 1)->create();
        $trades = factory(\ToStartWork\QualificationTradeType::class, 2)->create();

        $data = [
            'basic_info' => [
                'first_name' => 'first_name',
                'middle_name' => 'middle_name',
                'last_name' => 'last_name',
                'nickname' => 'nickname',
                'gender' => 'gender',
                'dob' => '2016-01-01',
                'address' => 'address',
                'contact_phone_no' => 'contact_phone_no',
                'contact_email' => 'contact_email'
            ],
            'citizen_details' => [
                'eligible_to_work' => true,
                'valid_visa' => true,
                'passport_no' => '111111',
                'visa_grant_no' => '12345',
                'visa_expiry_date' => '2018-01-01',
            ],
            'licenses' => [
                'citb_no' => '1234',
                'citb_expiry_date' => '2018-01-01',
                'drivers_license_class' => 'C',
                'drivers_license_no' => 'a123',
                'drivers_license_name' => 'drivers_license_name',
                'drivers_license_expiry_date' => '2018-01-01',
            ],
            'medical_informations' => [
                'has_tetanus_injection' => true,
                'tetanus_Injection_details' => 'tetanus_Injection_details',
                'has_epilepsy' => true,
                'epilepsy_details' => 'epilepsy_details',
                'has_diabetes' => true,
                'diabetes_details' => 'diabetes_details',
                'has_heart_condition' => true,
                'heart_condition_details' => 'heart_condition_details',
                'has_medical_condition' => true,
                'medical_condition_details' => 'medical_condition_details',
                'has_taken_medication' => true,
                'taken_medication_details' => 'taken_medication_details',
                'has_allergies' => true,
                'allergies_details' => 'allergies_details'
            ],
            'emergency_contacts' => factory(\ToStartWork\Contact::class, 3)->make()->toArray(),
            'employment_details' => factory(\ToStartWork\Employment::class, 3)->make()->toArray(),
            'trades' => $trades->pluck('id')->toArray(),

        ];
        
        $response = $this->actingAs($user)
            ->json('POST', sprintf('/api/user/profile/update'), $data)
           ->seeJsonEquals([
                'user' => array_merge($data['basic_info'], $data['citizen_details'], $data['licenses'], $data['medical_informations'], $user->toArray())
            ]);

         // dd($this->response->content());
        $json = json_decode($this->response->content());
        $this->assertCount(3, $json->user->contacts);
        $this->assertCount(3, $json->user->employment);
        $this->assertCount(2, $json->user->trades);
    }

    public function testInvalidKeyThrowsException()
    {
        config(['jwt.algo' => 'HS256d']);

        $user = factory(ToStartWork\User::class)->create();

        $credentials = ['email' => $user->email, 'password' => 'password'];

        $response = $this->post('/api/user/signin', $credentials);

        //$response = json_decode($response->response->getContent(), true);

        $this->assertResponseStatus(500);

        //$this->assertArrayHasKey('error', $response);
        //$this->assertEquals('invalid_credentials', $response['error']);
    }

    public function testInvalidKeyThrowsExceptionSocialLogin()
    {
        config(['jwt.algo' => 'HS256d']);

        $socialToken = 'ty43t368';

        $user = factory(ToStartWork\User::class)->create(['google_token' => $socialToken]);

        $credentials = [
            'email' => $user->email,
            'token' => $socialToken,
            'username' => 'google user',
            'user_image_url' => 'http://google.com.au',
            'from' => 'google'
        ];

        $response = $this->json('POST', '/api/user/social/signin', $credentials);

        $this->assertResponseStatus(500);

    }
}
