<?php

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;


class RegisterTest extends TestCase
{
    use DatabaseMigrations;

    private $user;

    /**
     * A basic test example.
     *
     * @return void
     */
    public function testUserCanRegister()
    {
        $this->user = factory(ToStartWork\User::class)->make()->makeVisible('password')->toArray();
        $this->user['password'] = base64_encode('password');

        $this->json('POST', '/api/user/signup', $this->user)->seeJson(array_except($this->user, ['password']));
    }

    public function testNewUserCanLogin()
    {
        $user = factory(ToStartWork\User::class)->create();

        $credentials = ['email' => $user->email, 'password' => 'password'];

        $response = $this->json('POST', '/api/user/signin', $credentials);

        $response->assertResponseOk();
        $this->assertArrayHasKey('token',  json_decode($this->response->getContent(), true));
        $this->assertArrayHasKey('user',  json_decode($this->response->getContent(), true));
    }

    public function testExistingLoginIsRedirected()
    {
        $user = factory(ToStartWork\User::class)->create();

        $credentials = ['email' => $user->email, 'password' => 'password'];

        $response = $this->actingAs($user)->json('POST', '/api/user/signin', $credentials);

        $response->assertResponseStatus(302);
    }

    public function testGoogleSocialSignup()
    {
        $credentials = [
            'email' => 'user123@codium.com.au',
            'token' => '43t3t',
            'username' => 'google user',
            'user_image_url' => 'http://google.com.au',
            'from' => 'google'
        ];

        $response = $this->json('POST', '/api/user/social/signin', $credentials);

        $response->assertResponseOk();
        $this->assertArrayHasKey('token',  json_decode($this->response->getContent(), true));
        $this->assertArrayHasKey('user',  json_decode($this->response->getContent(), true));
    }

    public function testGoogleSocialSignin()
    {
        $socialToken = 'ty43t368';

        $user = factory(ToStartWork\User::class)->create(['google_token' => $socialToken]);

        $credentials = [
            'email' => $user->email,
            'token' => $socialToken,
            'username' => 'google user',
            'user_image_url' => 'http://google.com.au',
            'from' => 'google'
        ];

        $response = $this->json('POST', '/api/user/social/signin', $credentials);

        $response->assertResponseOk();
        $this->assertArrayHasKey('token',  json_decode($this->response->getContent(), true));
        $this->assertArrayHasKey('user',  json_decode($this->response->getContent(), true));

        $this->assertEquals($user->email, json_decode($this->response->getContent(), true)['user']['email']);
    }

    public function testFacebookSocialSignup()
    {
        $credentials = [
            'email' => 'user123@codium.com.au',
            'token' => '43t3t',
            'username' => 'facebook user',
            'user_image_url' => 'http://facebook.com',
            'from' => 'facebook'
        ];

        $response = $this->json('POST', '/api/user/social/signin', $credentials);

        $response->assertResponseOk();
        $this->assertArrayHasKey('token',  json_decode($this->response->getContent(), true));
        $this->assertArrayHasKey('user',  json_decode($this->response->getContent(), true));
    }

    public function testFacebookSocialSignin()
    {
        $socialToken = 'ty43t368';

        $user = factory(ToStartWork\User::class)->create(['facebook_token' => $socialToken]);

        $credentials = [
            'email' => $user->email,
            'token' => $socialToken,
            'username' => 'facebook user',
            'user_image_url' => 'http://facebook.com',
            'from' => 'facebook'
        ];

        $response = $this->json('POST', '/api/user/social/signin', $credentials);

        $response->assertResponseOk();
        $this->assertArrayHasKey('token',  json_decode($this->response->getContent(), true));
        $this->assertArrayHasKey('user',  json_decode($this->response->getContent(), true));

        $this->assertEquals($user->email, json_decode($this->response->getContent(), true)['user']['email']);
    }

    /*public function testCantLoginWithNull()
    {
        $user = factory(ToStartWork\User::class)->create(['password' => null]);
        dd($user);
    }*/
}
