<?php

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use ToStartWork\Qualification;

class QualificationTest extends TestCase
{
    use DatabaseMigrations;

    public function setUp()
    {
        parent::setUp();
        $this->withoutMiddleware();
    }
    
    public function testQualificationsListUnfiltered()
    {
        factory(\ToStartWork\Qualification::class, 5)->create();

        $response = $this->json('GET', '/api/qualification/list/categories');

        $response->assertResponseOk();
        $this->assertEquals(5, count(json_decode($this->response->content())));
    }

    public function testQualificationsListTradeFiltered()
    {
        factory(\ToStartWork\Qualification::class, 5)->create();

        $response = $this->json('GET', '/api/qualification/list/categories', ['trade_type_id' => 1]);

        $response->assertResponseOk();
        $this->assertEquals(1, count(json_decode($this->response->content())));
    }

    public function testQualificationsListTradeTypeFiltered()
    {
        factory(\ToStartWork\Qualification::class, 5)->create();

        $response = $this->json('GET', '/api/qualification/list/categories', ['type_id' => 1]);

        $response->assertResponseOk();
        $this->assertEquals(1, count(json_decode($this->response->content())));
    }

    public function testQualificationsListTypeAndTradeTypeFiltered()
    {
        factory(\ToStartWork\Qualification::class, 5)->create();

        $response = $this->json('GET', '/api/qualification/list/categories', ['type_id' => 1, 'trade_type_id' => 1]);

        $response->assertResponseOk();
        $this->assertEquals(1, count(json_decode($this->response->content())));
    }

    public function testQualificationsListTypeAndTradeTypeFilteredNoResults()
    {
        factory(\ToStartWork\Qualification::class, 5)->create();

        $response = $this->json('GET', '/api/qualification/list/categories', ['type_id' => 6, 'trade_type_id' => 6]);

        $response->assertResponseOk();
        $this->assertEquals(0, count(json_decode($this->response->content())));
    }



}
