<?php

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use Illuminate\Http\UploadedFile;
use ToStartWork\Qualification;
use ToStartWork\User;

class QualificationImagesTest extends TestCase
{
    use DatabaseMigrations;

    public function setUp()
    {
        parent::setUp();
        $this->withoutMiddleware();
    }
    
    /**
     * User is adding a new qualification to there account
     *
     */
    public function testUserStoringQualificationFrontImage()
    {
        $user = factory(User::class)->create();
        $qualification = factory(Qualification::class)->create();
        $user->qualifications()->attach($qualification->id, ['ref_no' => '1234', 'issue_date' => '2017-01-01', 'expiry_date' => '2018-01-01']);


        $stub = __DIR__.'/../stubs/front.jpg';
        $name = str_random(8).'.jpg';
        $path = sys_get_temp_dir().'/'.$name;

        copy($stub, $path);

        $file = new UploadedFile($path, $name, filesize($path), 'image/jpeg', null, true);
        $response = $this
            ->actingAs($user)
            ->call('POST', sprintf('/api/qualification/%s/image/update/front', $qualification->id), [], [], ['front_image' => $file], ['Accept' => 'application/json']);

        $this->assertResponseOk();
        $content = json_decode($response->getContent());
        $this->assertObjectHasAttribute('front_image', $content);

        $uploaded = storage_path('app/'.$content->front_image);
        $this->assertFileExists($uploaded);

        @unlink($uploaded);

    }

    /**
     * User is adding a new qualification to there account
     *
     */
    public function testUserStoringQualificationBackImage()
    {
        $user = factory(User::class)->create();
        $qualification = factory(Qualification::class)->create();
        $user->qualifications()->attach($qualification->id, ['ref_no' => '1234', 'issue_date' => '2017-01-01', 'expiry_date' => '2018-01-01']);


        $stub = __DIR__.'/../stubs/back.jpg';
        $name = str_random(8).'.jpg';
        $path = sys_get_temp_dir().'/'.$name;

        copy($stub, $path);

        $file = new UploadedFile($path, $name, filesize($path), 'image/jpeg', null, true);
        $response = $this
            ->actingAs($user)
            ->call('POST', sprintf('/api/qualification/%s/image/update/back', $qualification->id), [], [], ['back_image' => $file], ['Accept' => 'application/json']);

        $this->assertResponseOk();
        $content = json_decode($response->getContent());
        $this->assertObjectHasAttribute('back_image', $content);

        $uploaded = storage_path('app/'.$content->back_image);
        $this->assertFileExists($uploaded);

        @unlink($uploaded);

    }

    public function testUserViewQualificationFrontImage()
    {
        $user = factory(User::class)->create();
        $qualification = factory(Qualification::class)->create();
        $user->qualifications()->attach($qualification->id, ['ref_no' => '1234', 'issue_date' => '2017-01-01', 'expiry_date' => '2018-01-01', 'front_image' => 'uploads/front.jpg']);

        $stub = __DIR__.'/../stubs/front.jpg';
        $path = storage_path('app/uploads/front.jpg');
        copy($stub, $path);

        $this->actingAs($user)->get(sprintf('/api/qualification/%s/image/front', $qualification->id));

        $this->assertEquals($this->response->getStatusCode(), 200);
        $this->assertContains('attachment', (string)$this->response);

        @unlink($path);
    }

    public function testUserViewQualificationBackImage()
    {
        $user = factory(User::class)->create();
        $qualification = factory(Qualification::class)->create();
        $user->qualifications()->attach($qualification->id, ['ref_no' => '1234', 'issue_date' => '2017-01-01', 'expiry_date' => '2018-01-01', 'back_image' => 'uploads/back.jpg']);

        $stub = __DIR__.'/../stubs/back.jpg';
        $path = storage_path('app/uploads/back.jpg');
        copy($stub, $path);

        $this->actingAs($user)->get(sprintf('/api/qualification/%s/image/back', $qualification->id));

        $this->assertEquals($this->response->getStatusCode(), 200);
        $this->assertContains('attachment', (string)$this->response);

        @unlink($path);
    }
}
