<?php

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class NotificationsTest extends TestCase
{
    use DatabaseMigrations;

    public function setUp()
    {
        parent::setUp();
        $this->withoutMiddleware();
    }
    
    public function testNotificationsList()
    {
        $user1 = factory(\ToStartWork\User::class, 1)->create();
        $user2 = factory(\ToStartWork\User::class, 1)->create();

        $notifications = factory(\ToStartWork\Notification::class, 5)->create();

        $user1->notifications()->attach($notifications);

        $response = $this->actingAs($user1)->json('GET', '/api/notification/list');
        $response->assertResponseOk();
        $this->assertEquals(5, count(json_decode($this->response->content())));

        $response = $this->actingAs($user2)->json('GET', '/api/notification/list');
        $response->assertResponseOk();
        $this->assertEquals(0, count(json_decode($this->response->content())));
    }

    public function testNotificationDelete()
    {
        $user1 = factory(\ToStartWork\User::class, 1)->create();
        $notifications = factory(\ToStartWork\Notification::class, 5)->create();
        $user1->notifications()->attach($notifications);

        //Check 5 exist
        $response = $this->actingAs($user1)->json('GET', '/api/notification/list');
        $response->assertResponseOk();
        $this->assertEquals(5, count(json_decode($this->response->content())));

        //Delete a notification
        $this->actingAs($user1)->post('/api/notification/delete', ['id' => $notifications[0]->id]);

        //Check only 4 now exist
        $response = $this->actingAs($user1)->json('GET', '/api/notification/list');
        $response->assertResponseOk();
        $this->assertEquals(4, count(json_decode($this->response->content())));
    }
}
