<?php $__env->startSection('javascript'); ?>


    <!-- /.switchery -->
    <script>
        /* Switchery Toggles */
        var js_switch_primary = document.querySelectorAll('.js-switch-primary');
        js_switch_primary.forEach(function (html) {
          var switchery = new Switchery(html, {
            color: '#3498db',
            size: 'small'
          });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <h2 class="font-light m-b-xs">
                    Edit User <?php echo e($user->name); ?>

                </h2>
            </div>
        </div>
    </div>

    <div class="content">

        <?php echo Former::horizontal_open()->id('edit-notification')->rules(['name' => 'required'])->method('PUT')->action(route('users.update', [$user->id])); ?>


        <div class="hpanel">
            <div class="panel-body">
                <div class="form-horizontal">
                    <div class="row">
                        <div class="col-lg-6">
                            <h4>User Details</h4>
                            <?php echo Former::text('first_name')->label('First Name')->value($user->first_name); ?>

                            <?php echo Former::text('last_name')->label('Last Name')->value($user->last_name); ?>

                            <?php echo Former::text('email')->value($user->email); ?>

                            <div class="form-group">
                                <label for="is_approved" class="control-label col-lg-4 col-sm-4">Is Active</label>
                                <div class="col-lg-8 col-sm-8">
                                    <div class="checkbox">
                                        <?php if($user->active): ?>
                                            <input class="js-switch-primary" id="active" type="checkbox"
                                                   name="active" checked>
                                        <?php else: ?>
                                            <input class="js-switch-primary" id="active" type="checkbox"
                                                   name="active">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="is_approved" class="control-label col-lg-4 col-sm-4">Is Admin</label>
                                <div class="col-lg-8 col-sm-8">
                                    <div class="checkbox">
                                        <?php if($user->is_admin): ?>
                                            <input class="js-switch-primary" id="is_admin" type="checkbox"
                                                   name="is_admin" checked>
                                        <?php else: ?>
                                            <input class="js-switch-primary" id="is_admin" type="checkbox"
                                                   name="is_admin">
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <h4>Password</h4>
                            <?php echo Former::password('password'); ?>

                            <?php echo Former::password('password_confirmation')->label('Repeat Password'); ?>

                        </div>
                    </div><!-- /.row -->
                </div><!-- /.form-horizontal -->
            </div>
        </div><!-- /.hpanel -->

        <div class="hpanel">
            <div class="panel-body">
                <a href="<?php echo e(route('users.index')); ?>" class="btn btn-default">Cancel</a>
                <button class="btn btn-success">Save Changes</button>
            </div>
        </div><!-- /.hpanel -->
        <?php echo Former::close(); ?>


    </div><!-- /.content -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>