@extends('layouts.app')

@section('javascript')


@endsection

@section('content')
    <style>
        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            /* display: none; <- Crashes Chrome on hover */
            -webkit-appearance: none;
            margin: 0; /* <-- Apparently some margin are still there even though it's hidden */
        }
    </style>
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <h2 class="font-light m-b-xs">
                    Create New Provider
                </h2>
            </div>
        </div>
    </div>

    <div class="content">

        {!! Former::horizontal_open()->id('edit-notification')->rules(['contact_name' => 'required'])->method('POST')->action(route('providers.store')) !!}
        <div class="hpanel">
            <div class="panel-body">
                <div class="form-horizontal">
                    <div class="row">
                        <div class="col-lg-12"><h4>Provider Details</h4></div>
                        <div class="col-lg-6">
                            {!! Former::text('contact_name')->label('Contact Name') !!}
                            {!! Former::text('contact_phone')->label('Contact Phone') !!}
                            {!! Former::text('contact_email')->label('Contact Email') !!}
                            {!! Former::text('company')->label('Company') !!}
                        </div>

                        <div class="col-lg-6">
                            {!! Former::text('address_line_1')->label('Address Line 1') !!}
                            {!! Former::text('address_line_2')->label('Address Line 2') !!}
                            {!! Former::text('city')->label('City') !!}
                            {!! Former::number('postcode')->label('Postcode') !!}
                            {!! Former::select('state')->label('State')->fromQuery($stateOptions) !!}
                        </div>
                    </div><!-- /.row -->
                </div><!-- /.form-horizontal -->
            </div>
        </div><!-- /.hpanel -->

        <div class="hpanel">
            <div class="panel-body">
                <a href="{{route('providers.index')}}" class="btn btn-default">Cancel</a> <button class="btn btn-success">Create Provider</button>
            </div>
        </div><!-- /.hpanel -->
        {!! Former::close() !!}

    </div><!-- /.content -->


@endsection
