@extends('layouts.app')

@section('javascript')
    <!-- Redactor -->
    <script src="/vendor/select2/select2.js"></script>
    <script src="/vendor/redactor/redactor.js"></script>
    <script>
        $(document).ready(function() {
            $('.redactor').redactor({
                plugins: ['source'],
                imagePosition: true,
                imageResizable: true
            });
        });
    </script>

    <!-- /.switchery -->
    <script>
        /* Switchery Toggles */
        var js_switch_primary = document.querySelectorAll('.js-switch-primary');
        js_switch_primary.forEach(function(html) {
            var switchery = new Switchery(html, {
                color: '#3498db',
                size: 'small'
            });
        });
    </script>

    <!-- Sweet Alert -->
    <script src="/vendor/sweetalert/lib/sweet-alert.min.js"></script>
    <script>
        $('.delete-course').click(function () {
            swal({
                title: 'Confirm',
                text: "Please confirm you want to delete this course",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'rgb(168, 67, 23)',
                confirmButtonText: 'Yes, delete it!'
            }, function () {

            });
        });


    </script>

@endsection

@section('content')

    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <h2 class="font-light m-b-xs">
                    Edit Course
                </h2>
            </div>
        </div>
    </div>

    <div class="content">

        {!! Former::vertical_open()->id('edit-notification')->rules(['name' => 'required'])->method('PUT')->action(route('courses.update', [$course->id])) !!}
        {!! Former::populate($course) !!}

        <div class="hpanel">
            <div class="panel-body">
                <div class="form-horizontal">
                    <div class="row">
                        <div class="col-lg-6">
                            <div style="padding-left: 15px; padding-right: 15px">
                                {!! Former::text('name')->label('Name') !!}
                                {!! Former::select('provider_id')->label('Provider')->addClass('select2')->fromQuery($providerOptions) !!}
                                {!! Former::select('category_id')->label('Category')->addClass('select2')->fromQuery($categoryOptions) !!}
                                {!! Former::text('location')->label('Location') !!}
                                {!! Former::date('enroll_date')->label('Enrolment Date') !!}
                                {!! Former::number('price')->label('Price')->prepend('<i class="fa fa-usd"></i>') !!}
                                {!! Former::number('citb_price')->label('CITB Price')->prepend('<i class="fa fa-usd"></i>') !!}
                                {!! Former::checkbox('active')->addClass('js-switch-primary') !!}

                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div style="padding-left: 15px; padding-right: 15px">
                                <div class="form-group{{ $errors->has('description') ? ' has-error' : '' }}">
                                    <label class="control-label">Description:</label>
                                    <textarea class="redactor" name="description">
                                        {{$course->description}}
                                    </textarea>
                                </div><!-- /.form-group -->
                            </div>
                        </div>
                    </div><!-- /.row -->
                </div><!-- /.form-horizontal -->
            </div>
        </div><!-- /.hpanel -->

        <div class="hpanel">
            <div class="panel-body">
                <a href="{{route('courses.destroy', $course->id)}}" class="btn btn-danger delete-course pull-right">Delete</a> <button class="btn btn-success">Save</button>
            </div>
        </div><!-- /.hpanel -->

        {!! Former::close() !!}

    </div><!-- /.content -->


@endsection
