<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('active')->default(1);
            $table->integer('is_admin')->default(0);
            $table->string('first_name')->nullable();
            $table->string('middle_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('username')->nullable();
            $table->string('nickname')->nullable();
            $table->string('email')->unique()->nullable();
            $table->string('password')->nullable();
            $table->text('facebook_token')->nullable();
            $table->text('google_token')->nullable();
            $table->string('ios_device_token')->nullable();
            $table->string('gender')->nullable();
            $table->date('dob')->nullable();
            $table->string('address')->nullable();
            $table->string('contact_email')->nullable();
            $table->string('contact_phone_no')->nullable();
            $table->string('user_image_url')->nullable();
            $table->string('how_hear_about_us')->nullable();
            $table->string('description_how_hear_about_us')->nullable();

            //citizen details
            $table->boolean('eligible_to_work')->default(false);
            $table->boolean('valid_visa')->default(false);
            $table->string('passport_no')->nullable();
            $table->string('visa_grant_no')->nullable();
            $table->date('visa_expiry_date')->nullable();

            //licenses
            $table->string('citb_no')->nullable();
            $table->date('citb_expiry_date')->nullable();
            $table->string('drivers_license_class')->nullable();
            $table->string('drivers_license_no')->nullable();
            $table->string('drivers_license_name')->nullable();
            $table->date('drivers_license_expiry_date')->nullable();

            //medical
            $table->boolean('has_tetanus_injection')->default(false);
            $table->string('tetanus_injection_details')->nullable();
            $table->boolean('has_epilepsy')->default(false);
            $table->string('epilepsy_details')->nullable();
            $table->boolean('has_diabetes')->default(false);
            $table->string('diabetes_details')->nullable();
            $table->boolean('has_heart_condition')->default(false);
            $table->string('heart_condition_details')->nullable();
            $table->boolean('has_medical_condition')->default(false);
            $table->string('medical_condition_details')->nullable();
            $table->boolean('has_taken_medication')->default(false);
            $table->string('taken_medication_details')->nullable();
            $table->boolean('has_allergies')->default(false);
            $table->string('allergies_details')->nullable();



            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('users');
    }
}
