<?php

/*
|--------------------------------------------------------------------------
| Model Factories
|--------------------------------------------------------------------------
|
| Here you may define all of your model factories. Model factories give
| you a convenient way to create models for testing and seeding your
| database. Just tell the factory how a default model should look.
|
*/

$factory->define(ToStartWork\User::class, function (Faker\Generator $faker) {


    return [
        'first_name' => $faker->firstName,
        'last_name' => $faker->lastName,
        'email' => $faker->unique()->safeEmail,
        'password' => bcrypt('password'),
        'gender' => 'male',
        'dob' => $faker->date('Y-m-d', 'now'),
        'address' => $faker->address,
        'contact_phone_no' => $faker->phoneNumber,
        'contact_email' => $faker->email,
        'how_hear_about_us' => $faker->text(10),
        'description_how_hear_about_us' => $faker->text(100)
    ];
});

$factory->define(ToStartWork\Contact::class, function (Faker\Generator $faker) {
    return [
        'name' => $faker->name,
        'relationship' => $faker->text(10),
        'address' => $faker->address,
        'primary_contact' => $faker->phoneNumber,
        'secondary_contact' => $faker->phoneNumber
    ];
});

$factory->define(ToStartWork\Employment::class, function (Faker\Generator $faker) {
    return [
        'company_name' => $faker->company,
        'employment_status' => $faker->text(10),
        'start_year' => $faker->year,
        'infield_years' => $faker->randomNumber(2),
    ];
});

$factory->define(ToStartWork\QualificationType::class, function (Faker\Generator $faker) {

    return [
        'name' => $faker->text(10),
    ];
});


$factory->define(ToStartWork\QualificationTradeType::class, function (Faker\Generator $faker) {

    return [
        'name' => $faker->text(10),
    ];
});

$factory->define(ToStartWork\Qualification::class, function (Faker\Generator $faker) use ($factory) {

    return [
        'name' => $faker->text(10),
        'type_id' => factory(\ToStartWork\QualificationType::class)->create()->id,
        'trade_type_id' => factory(\ToStartWork\QualificationTradeType::class)->create()->id,
    ];
});

$factory->define(ToStartWork\CourseCategory::class, function (Faker\Generator $faker) {

    return [
        'name' => $faker->text(10),
    ];
});

$factory->define(ToStartWork\CourseProvider::class, function (Faker\Generator $faker) {

    return [
        'company' => $faker->text(10),
        'contact_email' => $faker->email()
    ];
});

$factory->define(ToStartWork\Course::class, function (Faker\Generator $faker) use ($factory) {

    return [
        'name' => $faker->text(10),
        'category_id' => factory(\ToStartWork\CourseCategory::class)->create()->id,
        'provider_id' => factory(\ToStartWork\CourseProvider::class)->create()->id,
    ];
});

$factory->define(ToStartWork\Notification::class, function (Faker\Generator $faker) use ($factory) {

    return [
        'status' => 'sent',
        'title' => $faker->text(5),
        'subtitle' => $faker->text(10),
        'content' => $faker->text(40),
    ];
});