<?php

namespace ToStartWork;

use Illuminate\Database\Eloquent\Model;

class Qualification extends Model
{
    const ACTIVATED = 'activated';
    const ARCHIVED = 'archived';

    public $guarded = [];

    public $timestamps = false;

    protected $hidden = [
        'user_id'
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function type()
    {
        return $this->belongsTo(QualificationType::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function tradeType()
    {
        return $this->belongsTo(QualificationTradeType::class);
    }

    public function getTypeNameAttribute()
    {
        return $this->type ? $this->type->name : 'General';
    }

    public function getTradeTypeNameAttribute()
    {
        return $this->tradeType ? $this->tradeType->name : '';
    }

    public function setTypeIdAttribute($value)
    {
        if ($value) {
            $this->attributes['type_id'] = $value;
        }
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getCanBeApprovedAttribute()
    {
        return (boolean)$this->user_id;
    }

    public function getIsPublicAttribute()
    {
        return (boolean)$this->is_approved;
    }

    public function scopeUnapproved($query)
    {
        return $query->where('is_approved', false);
    }
}
