<?php

namespace ToStartWork\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use ToStartWork\Course;
use ToStartWork\User;

class UserAppliedToCourse extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var Course
     */
    public $course;

    /**
     * @var User
     */
    public $user;

    /**
     * Create a new message instance.
     *
     * @param Course $course
     * @param User $user
     */
    public function __construct(Course $course, User $user)
    {
        $this->course = $course;
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from('admin@tostartwork.com', 'toStartWork')->view('emails.user_applied_to_course');
    }
}
