<?php

namespace ToStartWork\Listeners;

use Illuminate\Support\Facades\Mail;
use ToStartWork\Events\UserAppliedToCourse;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use ToStartWork\Mail\UserAppliedToCourse as UserAppliedToCourseMail;

class NotifyProviderOfNewUser
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  UserAppliedToCourse  $event
     * @return void
     */
    public function handle(UserAppliedToCourse $event)
    {
        Mail::to($event->course->courseProvider->contact_email)->queue(new UserAppliedToCourseMail($event->course, $event->user));
    }
}
