<?php

namespace ToStartWork\Http\Requests\Admin\UserManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Request;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules = ['email' => 'required|email'];

        if (Request::has('password')) {
            $rules = array_merge($rules, [
                'password' => 'confirmed'
            ]);
        }

        return $rules;
    }
}
