<?php

namespace ToStartWork\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use ToStartWork\Graphs\Dashboard\GenerateAxisTicks;
use ToStartWork\Graphs\Dashboard\TotalSubscribedUsers;
use ToStartWork\Graphs\Dashboard\TotalUserSignups;
use ToStartWork\Graphs\Dashboard\TotalUserSignupsMonth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @param TotalUserSignups $totalUserSignups
     * @param GenerateAxisTicks $generateAxisTicks
     * @return \Illuminate\Http\Response
     * @internal param TotalSubscribedUsers $totalSubscribedUsers
     */
    public function index(GenerateAxisTicks $generateAxisTicks, TotalSubscribedUsers $totalSubscribedUsers, TotalUserSignupsMonth $totalUserSignups)
    {
    //dd($totalSubscribedUsers->get());
        return view('dashboard')
            ->with('generateAxisTicks', $generateAxisTicks->get())
            ->with('totalUserSignups', $totalUserSignups->get())
            ->with('totalSubscribedUsers', $totalSubscribedUsers->get());
    }
}
