<?php

namespace ToStartWork\Http\Controllers\Auth;

use ToStartWork\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;

class ResetPasswordController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Password Reset Controller
    |--------------------------------------------------------------------------
    |
    | This controller is responsible for handling password reset requests
    | and uses a simple trait to include this behavior. You're free to
    | explore this trait and override any methods you wish to tweak.
    |
    */

    use ResetsPasswords;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest', ['except' => 'getResetPasswordSuccessPage']);
    }

    public function redirectTo()
    {
        if (auth()->user()->is_admin) {
            return '/';
        }

        return '/password/success';
    }

    public function getResetPasswordSuccessPage()
    {
        return view('auth.passwords.success');
    }
}
