<?php

namespace ToStartWork\Http\Controllers\Api;

use Auth;
use File;
use Illuminate\Http\Request;
use ToStartWork\Http\Controllers\Controller;

class UserProfileImageController extends Controller
{

    /**
     * Store image for a users profile
     *
     * @param $qualificationId
     * @param UserStoreQualificationFrontImage $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store(Request $request)
    {
        $user = Auth::user();
        $directory = public_path().'/storage/profile_images/'.$user->id;
        $file = $request->file('profile_image');
        $extension = $file->getClientOriginalExtension();
        $uniqueName = uniqid().$extension;

        //delete any previous profile image
        File::deleteDirectory($directory);

        $request->file('profile_image')->move($directory, $uniqueName);
        $imageUrl = config('app.url').'/storage/profile_images/'.$user->id.'/'.$uniqueName;
        
        //add url to database
        $user->user_image_url = $imageUrl;
        $user->save();

        return response()->json(['profile_image' => $imageUrl]);
    }
}
