<?php

namespace ToStartWork\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use ToStartWork\Course;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserApplyCourseRequest;

class CourseUserController extends Controller
{

    /**
     * User can apply to attend a course
     * An email will be sent to the course provider contact
     *
     * @return mixed
     */
    public function store(UserApplyCourseRequest $request)
    {
        $course = Course::with(['courseProvider'])->whereId($request->get('course_id'))->first();

        $course->apply(Auth::user());

        return response()->json([]);
    }
}
