<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if ( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;

		$post = array();

		$upload = wp_upload_bits( 'themify-placeholder.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post = array(
				'post_mime_type' => $info['type']
			);
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$placeholder_image = wp_insert_attachment( $post, $upload['file'] );
		require_once( ABSPATH . 'wp-admin/includes/image.php' );
		wp_update_attachment_metadata( $placeholder_image, wp_generate_attachment_metadata( $placeholder_image, $upload['file'] ) );
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) || ! isset( $processed_terms[ intval( $term['parent'] ) ] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if ( ! empty( $placeholder ) && ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 11,
  'name' => 'Technology',
  'slug' => 'technology',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 12,
  'name' => 'Gadget',
  'slug' => 'gadget',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 13,
  'name' => 'News',
  'slug' => 'news',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 14,
  'name' => 'News',
  'slug' => 'news',
  'term_group' => 0,
  'taxonomy' => 'post_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 15,
  'name' => 'Tech',
  'slug' => 'tech',
  'term_group' => 0,
  'taxonomy' => 'post_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Tips',
  'slug' => 'tips',
  'term_group' => 0,
  'taxonomy' => 'post_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Gadget',
  'slug' => 'gadget',
  'term_group' => 0,
  'taxonomy' => 'post_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'App',
  'slug' => 'app',
  'term_group' => 0,
  'taxonomy' => 'post_tag',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 7,
  'name' => 'UX / UI',
  'slug' => 'ux-ui',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 8,
  'name' => 'Web Design',
  'slug' => 'web-design',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 9,
  'name' => 'Branding',
  'slug' => 'branding',
  'term_group' => 0,
  'taxonomy' => 'portfolio-category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 3,
  'name' => 'Footer Nav',
  'slug' => 'footer-nav',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 10,
  'name' => 'Main Menu',
  'slug' => 'main-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 365,
  'post_date' => '2016-08-15 07:48:46',
  'post_date_gmt' => '2016-08-15 07:48:46',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

Vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi.',
  'post_title' => 'Best Stereo Headphones',
  'post_excerpt' => '',
  'post_name' => 'best-stereo-headphones',
  'post_modified' => '2016-08-16 00:17:13',
  'post_modified_gmt' => '2016-08-16 00:17:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=365',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471306634:72\\",\\"element_id\\":\\"wqsg666\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"a310505\\"},\\"_thumbnail_id\\":{\\"0\\":\\"366\\",\\"element_id\\":\\"1b2x204\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/headphones-820341.jpg\\",\\"element_id\\":\\"ydox003\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5icq000\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"o3bk410\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"2cy0246\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"y5gy426\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"wkgn440\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"a8gp320\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"k20h438\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vjld344\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"q3uy350\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lyd6533\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wxva004\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"sd33430\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"4h2o056\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"nq7v604\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"q48b480\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hvcf206\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"i294412\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"v7yn336\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hxek333\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ilrd464\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"533m066\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"yxgk640\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"p7wc833\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"8r7j090\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"594t242\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"vpv0234\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"f4e4706\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'category' => 'news, technology',
    'post_tag' => 'news, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/headphones-820341.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 368,
  'post_date' => '2016-08-12 07:48:58',
  'post_date_gmt' => '2016-08-12 07:48:58',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias at vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.

quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus.',
  'post_title' => 'Android Entertainment App',
  'post_excerpt' => '',
  'post_name' => 'android-entertainment-app',
  'post_modified' => '2016-08-16 00:17:36',
  'post_modified_gmt' => '2016-08-16 00:17:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=368',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309724:72\\",\\"element_id\\":\\"og9p300\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"z9vu023\\"},\\"_thumbnail_id\\":{\\"0\\":\\"370\\",\\"element_id\\":\\"rwsx100\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/imac-606765.jpg\\",\\"element_id\\":\\"r3cp020\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"90h0320\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"4dxr063\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"zybb446\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"pvnm039\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"3bpw400\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"eqk5423\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"n9mz000\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dqqw360\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ky5e020\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8vhh020\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e598020\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"jknu040\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"tubk605\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2v8y062\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"uum7350\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4n1a306\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"neww506\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qyj4005\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"gx1u053\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wmkf239\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1xv9066\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"pced062\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"7jcj026\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"7bo4000\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3tcb003\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"uf9x362\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"13\\",\\"element_id\\":\\"z0ac603\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'category' => 'news, technology',
    'post_tag' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/imac-606765.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 323,
  'post_date' => '2016-08-10 06:29:14',
  'post_date_gmt' => '2016-08-10 06:29:14',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Combine Different Monitors',
  'post_excerpt' => '',
  'post_name' => 'combine-different-monitors',
  'post_modified' => '2016-08-13 13:11:30',
  'post_modified_gmt' => '2016-08-13 13:11:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=323',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471093890:172\\",\\"element_id\\":\\"f2di002\\"},\\"_thumbnail_id\\":{\\"0\\":\\"324\\",\\"element_id\\":\\"cdk4140\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/computer-1245714.jpg\\",\\"element_id\\":\\"e7hm448\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"v03y040\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"19gj815\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"bfjh808\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"p950040\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"7miw881\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"u27t818\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"0k1p841\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"eemt014\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vqhl014\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3fi9815\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"u3h1804\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lkv4480\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"4et4011\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"r8r5401\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"sdqb200\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"iqeq800\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"yi8s213\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"mvq2482\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6mz6500\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"myv4104\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"y6pr747\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"j9dl800\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"bdjm210\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"tveo301\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"azvf041\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"cx9b811\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"23vb440\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"13\\",\\"element_id\\":\\"fgng401\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'category' => 'news, technology',
    'post_tag' => 'news, tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/computer-1245714.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 359,
  'post_date' => '2016-08-07 07:30:42',
  'post_date_gmt' => '2016-08-07 07:30:42',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Et quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus omnis.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Driving Map APP',
  'post_excerpt' => '',
  'post_name' => 'driving-map-app',
  'post_modified' => '2016-08-13 13:11:54',
  'post_modified_gmt' => '2016-08-13 13:11:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=359',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471093914:172\\",\\"element_id\\":\\"z5k2050\\"},\\"_thumbnail_id\\":{\\"0\\":\\"360\\",\\"element_id\\":\\"h1ij100\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/drive-863123.jpg\\",\\"element_id\\":\\"o5b0030\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"hrld500\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"fkh1600\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"1g37002\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"gacn203\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"pcg8272\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"vrh3012\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"q707303\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4lgy400\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zh79720\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"grlu720\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"omcb000\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ipe0087\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"u9eh009\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"f8ne000\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"9up2833\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"q6ko820\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"kja3000\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3l5r308\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"newt200\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"snjf070\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"9wvr003\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dpzh039\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"n0xy300\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"uav0910\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"bvs8000\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"at9f903\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"e34e050\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"45gh009\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'technology',
    'post_tag' => 'app, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/drive-863123.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 343,
  'post_date' => '2016-08-05 07:07:53',
  'post_date_gmt' => '2016-08-05 07:07:53',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Color Density',
  'post_excerpt' => '',
  'post_name' => 'color-density',
  'post_modified' => '2016-08-13 13:12:10',
  'post_modified_gmt' => '2016-08-13 13:12:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=343',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471093930:172\\",\\"element_id\\":\\"7taf365\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"f3ss000\\"},\\"_thumbnail_id\\":{\\"0\\":\\"344\\",\\"element_id\\":\\"7lxy622\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/communication-1542722.jpg\\",\\"element_id\\":\\"xubr064\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"xrey054\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"9nld506\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"7cdh600\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"fyqm060\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"cn8r060\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"4gc4005\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"do6v250\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dzri556\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"etys956\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8x6y969\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lcbs560\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"cojk666\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"drqp698\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"uitw066\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"iftw051\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ualk650\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"9xra960\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dgo0560\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"kcgo965\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lrbv665\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"gifa660\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"xdy5956\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"62wv697\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"3uad776\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ewkx062\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"3g76690\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"qk07650\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'gadget, technology',
    'post_tag' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/communication-1542722.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 348,
  'post_date' => '2016-07-29 07:11:36',
  'post_date_gmt' => '2016-07-29 07:11:36',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Mars Rover',
  'post_excerpt' => '',
  'post_name' => 'mars-rover',
  'post_modified' => '2016-08-16 00:18:44',
  'post_modified_gmt' => '2016-08-16 00:18:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=348',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309722:72\\",\\"element_id\\":\\"a1wq913\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"l969339\\"},\\"_thumbnail_id\\":{\\"0\\":\\"349\\",\\"element_id\\":\\"fzkr939\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/mars-rover-1241266.jpg\\",\\"element_id\\":\\"uohg309\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"a5wa599\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"r42b333\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"mftx858\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"16t8559\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"9bxu193\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"r3eh930\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"epk2604\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"etf7995\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"h6ti930\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3jp4386\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wm0n730\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"p2z5039\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"b2tq393\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3v83300\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"nc2s000\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pbd4770\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6oxx990\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vl8m309\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"d4ni199\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pyp5308\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f0jn939\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"jh4q535\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"28b0000\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"y3qn999\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8dh6030\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"od1b300\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"\\",\\"element_id\\":\\"76ue030\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'technology',
    'post_tag' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/mars-rover-1241266.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 354,
  'post_date' => '2016-07-12 07:27:45',
  'post_date_gmt' => '2016-07-12 07:27:45',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.',
  'post_title' => 'NASA Space Rocket',
  'post_excerpt' => '',
  'post_name' => 'nasa-space-rocket',
  'post_modified' => '2016-08-13 13:13:02',
  'post_modified_gmt' => '2016-08-13 13:13:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=354',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471093982:172\\",\\"element_id\\":\\"6ryc800\\"},\\"_thumbnail_id\\":{\\"0\\":\\"355\\",\\"element_id\\":\\"1xuo506\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/space-travel-1245698.jpg\\",\\"element_id\\":\\"opir680\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"hehg768\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lpf9008\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"q3jn008\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"ylso101\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"awtz066\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"86un607\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"ybs2066\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"jw40606\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"s5ve600\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"d3yv800\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"bdwf807\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"97n7090\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"0cx4088\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"gnue610\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"phwy006\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"e66y040\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ruov066\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"h1ii688\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2y6h666\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dnm7888\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"7b1i660\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"kc4b606\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"ruwy816\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"qfnd626\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"cjge069\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qfpu040\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"2oyc090\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"mnrk990\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'news, technology',
    'post_tag' => 'news, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/space-travel-1245698.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 337,
  'post_date' => '2016-07-07 07:04:20',
  'post_date_gmt' => '2016-07-07 07:04:20',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus.  Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

<span id="more-133"></span>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.',
  'post_title' => 'Laptop for Designer',
  'post_excerpt' => '',
  'post_name' => 'laptop-for-designer',
  'post_modified' => '2016-08-13 13:13:31',
  'post_modified_gmt' => '2016-08-13 13:13:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=337',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471094011:172\\",\\"element_id\\":\\"rxbn538\\"},\\"_thumbnail_id\\":{\\"0\\":\\"338\\",\\"element_id\\":\\"gmde307\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/computer-767781.jpg\\",\\"element_id\\":\\"1sjb055\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"s7bd050\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"doix860\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"j2qk077\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"f4bt335\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"j60a030\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"4wbq310\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"4ed3202\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"b5ih300\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wg9q030\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"00fq856\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"mbmb358\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0yb9380\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"8fgf800\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"0j3o083\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"b00l030\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"5hib203\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ke5q835\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f1gi353\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"jt9i600\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"t59c080\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ed3n900\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hwnf933\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"01lo040\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"hwzq031\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"yded850\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hwyo003\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"vypp530\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"wwha503\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'news, technology',
    'post_tag' => 'tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/computer-767781.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 372,
  'post_date' => '2016-06-25 07:50:55',
  'post_date_gmt' => '2016-06-25 07:50:55',
  'post_content' => 'Dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Organized Working Space',
  'post_excerpt' => '',
  'post_name' => 'organized-working-space',
  'post_modified' => '2016-08-13 13:13:58',
  'post_modified_gmt' => '2016-08-13 13:13:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=372',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471094038:172\\",\\"element_id\\":\\"retl055\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"cwdv500\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"7p2j343\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"ixri355\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"hnzf105\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"r37f140\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"oby9035\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"swp5605\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tqt9070\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"jwla505\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"7jf8220\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"47cw150\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"cvqx050\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"1e34333\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"psjr504\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"rs6j205\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"llfn604\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"em75242\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qdrm050\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"iyhh345\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2xex345\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e71a043\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3hmh440\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"3di7003\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"h4hd503\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"i6ad063\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"7pjd430\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"vdra099\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"6oti545\\"},\\"_thumbnail_id\\":{\\"0\\":\\"390\\",\\"element_id\\":\\"kwtb105\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/06\\\\/desk-601540.jpg\\",\\"element_id\\":\\"1wn0543\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'news, technology',
    'post_tag' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/06/desk-601540.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 329,
  'post_date' => '2016-04-03 06:34:20',
  'post_date_gmt' => '2016-04-03 06:34:20',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

<span id="more-117"></span>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Personalize Your Screensaver',
  'post_excerpt' => '',
  'post_name' => 'personalise-your-screensaver',
  'post_modified' => '2016-08-19 18:29:21',
  'post_modified_gmt' => '2016-08-19 18:29:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=329',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471631821:72\\",\\"element_id\\":\\"ro4x795\\"},\\"_thumbnail_id\\":{\\"0\\":\\"330\\",\\"element_id\\":\\"1k49050\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/tablet-600649.jpg\\",\\"element_id\\":\\"3fw1555\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"xmqv119\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"i5eq580\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"nb1m790\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"dx93790\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"vgav227\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"krs2207\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"af0i279\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"anf1550\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dwu4969\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"p4v0727\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"7nmc770\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tvru209\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"lqop000\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"wfvf035\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"rzaz325\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"6v6z322\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vygf323\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"a1n4905\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"k9ng777\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6sig200\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"iz2t000\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"atk1094\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"j5n2544\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"273k702\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"3hvf080\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6dw4705\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"lpyl905\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"13\\",\\"element_id\\":\\"72fn252\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
    'post_tag' => 'news, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/tablet-600649.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 312,
  'post_date' => '2015-10-06 04:18:20',
  'post_date_gmt' => '2015-10-06 04:18:20',
  'post_content' => 'Vestibulum eu ante odio, in laoreet odio. Sed facilisis erat eget nunc porta ac dictum erat pharetra. Cras cursus rhoncus ante quis gravida. Sed pellentesque libero nec purus mattis semper.<span id="more-283"></span>

Cras et lectus consequat, lobortis massa sit amet, dignissim nisl. Aenean id ornare nisl. Aliquam efficitur vestibulum erat nec semper. Nam a tempor arcu, in tempor sapien. Phasellus aliquet, ex sed ullamcorper condimentum, ante nibh faucibus purus, ullamcorper sollicitudin leo odio at velit. Suspendisse lobortis, felis auctor rutrum porta, diam lectus vestibulum ex, eget sagittis elit neque in orci. Donec eu finibus sapien.

Donec id faucibus enim. Phasellus a massa id quam tristique pellentesque in sit amet orci. Quisque pretium eleifend eros nec faucibus. Fusce sit amet turpis vitae metus pretium semper. Nam ornare, eros non condimentum elementum, massa orci egestas ligula, id sodales odio augue eget mi. Pellentesque convallis molestie mi. Phasellus congue libero id metus sodales ornare. Vestibulum varius ligula et magna lobortis condimentum. Fusce porttitor ac tortor vel auctor.',
  'post_title' => 'Smart Watch New Version',
  'post_excerpt' => '',
  'post_name' => '312',
  'post_modified' => '2016-08-16 00:19:48',
  'post_modified_gmt' => '2016-08-16 00:19:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=312',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309722:72\\",\\"element_id\\":\\"fahs888\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"84bg885\\"},\\"_thumbnail_id\\":{\\"0\\":\\"438\\",\\"element_id\\":\\"pclt252\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"v0hx880\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"2pry515\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"5fea353\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"nnps150\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"icdu009\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"zojg983\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1lle981\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"j77b111\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"sswg551\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2yot510\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"b945519\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"24ar544\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"mmxt985\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"v1an945\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"p4zd404\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"rt2w000\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ju9g049\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ma4v908\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"x02w811\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0shk808\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"g7i9000\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"elok005\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"d6kw501\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"s588158\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vyte800\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"2drp195\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"\\",\\"element_id\\":\\"9cfn808\\"},\\"_post_image_attach_id\\":{\\"0\\":\\"438\\",\\"element_id\\":\\"vla2811\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'gadget',
    'post_tag' => 'gadget, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/smart-watch-821557_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 326,
  'post_date' => '2015-08-09 06:30:52',
  'post_date_gmt' => '2015-08-09 06:30:52',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => '2015 New Smartphones Review',
  'post_excerpt' => '',
  'post_name' => '2016-new-smartphones-review',
  'post_modified' => '2016-08-16 00:20:42',
  'post_modified_gmt' => '2016-08-16 00:20:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=326',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309725:72\\",\\"element_id\\":\\"3qis660\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"zwl9091\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6lyr313\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"9sng613\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"0xvm133\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"5syo353\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"4rqz067\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"rzj6336\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hobs993\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"xilu046\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zy0o423\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e9l8443\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"m9w8319\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"maas601\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"3ktd609\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"johw841\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"6f9v000\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e2y6300\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"y223223\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"84m6556\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"p4e3099\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tkkp666\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"oswd791\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"wg4u058\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"e5vn930\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"5zob901\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"bv6i160\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"h2c0331\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"12\\",\\"element_id\\":\\"squ0604\\"},\\"_thumbnail_id\\":{\\"0\\":\\"440\\",\\"element_id\\":\\"bh2b563\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/iphone-410324-1.jpg\\",\\"element_id\\":\\"m48d160\\"},\\"_post_image_attach_id\\":{\\"0\\":\\"440\\",\\"element_id\\":\\"n7mc607\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'gadget',
    'post_tag' => 'gadget, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/iphone-410324-1.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 351,
  'post_date' => '2015-04-24 07:17:33',
  'post_date_gmt' => '2015-04-24 07:17:33',
  'post_content' => 'Accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.

Omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'New Android Smartphone',
  'post_excerpt' => '',
  'post_name' => 'new-android-smartphone',
  'post_modified' => '2016-08-16 00:21:32',
  'post_modified_gmt' => '2016-08-16 00:21:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=351',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309719:72\\",\\"element_id\\":\\"kqtm008\\"},\\"_thumbnail_id\\":{\\"0\\":\\"352\\",\\"element_id\\":\\"ax5s909\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/mobile-phone-1273095.jpg\\",\\"element_id\\":\\"jdkb929\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"a5kp300\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c7pc990\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"752d428\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"mvwy102\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"wayi800\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"5uz6240\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"1nib200\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wn4n000\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"x8qm040\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ih5h022\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c4h0020\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"17e1082\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"u0ee842\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"nu8u042\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"n9u8024\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"kyr6081\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tzpf260\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"cdlj247\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"t825884\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"kzp9448\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"s86l218\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"l9ak088\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"h8uc448\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"8yme484\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"xzid008\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vet7220\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"409l000\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"12\\",\\"element_id\\":\\"znam884\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'gadget, technology',
    'post_tag' => 'gadget, tech',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/mobile-phone-1273095.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 320,
  'post_date' => '2015-02-11 06:24:32',
  'post_date_gmt' => '2015-02-11 06:24:32',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Virtual Reality Gadget',
  'post_excerpt' => '',
  'post_name' => 'virtual-reality-gadget',
  'post_modified' => '2016-08-16 00:21:00',
  'post_modified_gmt' => '2016-08-16 00:21:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=320',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_date' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309720:72\\",\\"element_id\\":\\"0upv573\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"5zw8000\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"r2fe807\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"xa4n003\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"dn3j020\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"2zn7703\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"tsr8070\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"twnb077\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"m65q090\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5yzl737\\"},\\"hide_post_date\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f8ga303\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5tgi000\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"nbr9606\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"vpil909\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"qdbo093\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"9wuz330\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"mwsy030\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pebj000\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ahr8009\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"cgno009\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hiz1044\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2saz094\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"l846000\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"d6i0055\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"9yul040\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"xhtu009\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lzlz411\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"9r2g100\\"},\\"_yoast_wpseo_primary_category\\":{\\"0\\":\\"11\\",\\"element_id\\":\\"d1i3401\\"},\\"_thumbnail_id\\":{\\"0\\":\\"334\\",\\"element_id\\":\\"na04195\\"},\\"_wp_old_slug\\":{\\"0\\":\\"future-flight-industries\\",\\"element_id\\":\\"iuf4011\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/man-1416141.jpg\\",\\"element_id\\":\\"r1rt197\\"}}',
  ),
  'tax_input' => 
  array (
    'category' => 'gadget, technology',
    'post_tag' => 'gadget',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/man-1416141.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4,
  'post_date' => '2016-08-03 12:30:04',
  'post_date_gmt' => '2016-08-03 12:30:04',
  'post_content' => '<!--themify_builder_static--><h1 style="margin-bottom: 0;">About Us</h1><h5>We are a digital partner</h5>
<h2>Who we are</h2><p>We develop strategies, create content, build products, launch campaigns, design systems and then some — all to inspire the people our brands care about most.</p>
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/jonathan-min-260x240.jpg" width="260" height="240" title="Jonathan" alt="Founder" /> <h3> Jonathan </h3> Founder
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/mandy-min-260x240.jpg" width="260" height="240" title="Man" alt="Developer" /> <h3> Man </h3> Developer
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/sebastian-min-260x240.jpg" width="260" height="240" title="Sebastian" alt="Creative Designer" /> <h3> Sebastian </h3> Creative Designer
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/147544687-260x240.jpg" width="260" height="240" title="Kelly" alt="Content Writer" /> <h3> Kelly </h3> Content Writer
<h2>Our Services</h2><p>We provide a wide array of software design and<br /> development services</p>
<h3> Wireframing </h3> <p>We create simple prototypes that can be transformed to efficient User experience</p>
<h3> User Interface (UI) </h3> <p>The first thing that brings someone to your app is a beautiful, original and modern look and feel.</p>
<h3> User Experience (UX) design </h3> <p>To create software that people will actually use, you need to create software that\'s simple and easy to use.</p>
<h3> Quality Assurance </h3> <p>Our specialized in-house QA team does the review and testing of all the software we build.</p>
<h3>Testimonials</h3>
<ul data-id="tb_6hex229" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="4" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" data-horizontal="" > <li> <p>"Because of your skill, work and excellence so many doors have opened to us and we are poised to expand in some really huge ways."</p><p><strong>John Henry Doe</strong>, Eye Heart World</p> </li> <li> <p>"Sed odio risus, ornare sed varius et, dapibus pellentesque mauris. Sed aliquet vulputate nisl, ut porttitor nulla placerat id."</p><p><strong>John Smith</strong>, X-Company</p> </li> <li> <p>"Because of your skill, work and excellence so many doors have opened to us and we are poised to expand in some really huge ways."</p><p><strong>Peter Doe</strong>, Themify</p> </li> <li> <p>"Sed odio risus, ornare sed varius et, dapibus pellentesque mauris. Sed aliquet vulputate nisl, ut porttitor nulla placerat id."</p><p><b>Alice</b>, iHeart</p> </li> </ul>
<h3>How We Work</h3>

<sup>01</sup> <h2>Team</h2>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tincidunt velit mi, et cursus dui maximus eu. Aenean malesuada felis dui, tincidunt elementum lacus tempus viverra. Nullam in lacus erat. Quisque quis gravida sapien. </p>

<sup>02</sup><h2>Collaboration</h2>
<p>Maecenas sed leo a dui accumsan commodo. Ut a porta leo. In vitae purus at augue tempus ultricies in eget tellus. Maecenas facilisis magna sit amet nulla lobortis, eget cursus odio finibus. </p>

<sup>03</sup> <h2>Results</h2>
<p>Nullam tortor metus, egestas quis sagittis non, mattis id enim. Pellentesque lacinia, mi at iaculis fermentum, ex nisl porta sapien, nec gravida elit ligula at nulla.</p>
<h2>Let\'s talk about your project?</h2>
<a href="http://themifydemo.me/r/mu/ultra-skin-agency/contact/" > Contact Us </a><!--/themify_builder_static-->',
  'post_title' => 'About Us',
  'post_excerpt' => '',
  'post_name' => 'about-us',
  'post_modified' => '2019-10-21 07:47:06',
  'post_modified_gmt' => '2019-10-21 07:47:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?page_id=4',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_full_scrolling' => 'no',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'transparent',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'background_auto' => 'yes',
    'background_autotimeout' => '5',
    'background_speed' => '500',
    'background_wrap' => 'yes',
    'footer_design' => 'default',
    'imagefilter_options' => 'grayscale',
    'imagefilter_options_hover' => 'none',
    'imagefilter_applyto' => 'all',
    'order' => 'desc',
    'orderby' => 'date',
    'layout' => 'list-post',
    'display_content' => 'content',
    'feature_size_page' => 'blank',
    'hide_title' => 'default',
    'unlink_title' => 'default',
    'hide_date' => 'default',
    'hide_image' => 'default',
    'unlink_image' => 'default',
    'hide_navigation' => 'default',
    'portfolio_order' => 'desc',
    'portfolio_orderby' => 'date',
    'portfolio_layout' => 'list-post',
    'portfolio_display_content' => 'content',
    'portfolio_feature_size_page' => 'blank',
    'portfolio_hide_title' => 'default',
    'portfolio_unlink_title' => 'default',
    'portfolio_hide_meta_all' => 'default',
    'portfolio_hide_image' => 'default',
    'portfolio_unlink_image' => 'default',
    'portfolio_hide_navigation' => 'default',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"element_id\\":\\"1na0048\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\"margin-bottom: 0;\\\\\\">About Us<\\\\/h1><h5>We are a digital partner<\\\\/h5>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"4i1c399\\"}],\\"styling\\":[],\\"element_id\\":\\"kxx6840\\"}],\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/about-min-1-1024x283.jpg\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"000000_0.57\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgba(82, 255, 238, 0.65)|100% rgba(96, 33, 255, 0.592)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgba(82, 255, 238, 0.65) 0%, rgba(96, 33, 255, 0.592) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgba(82, 255, 238, 0.65) 0%, rgba(96, 33, 255, 0.592) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgba(82, 255, 238, 0.65) 0%, rgba(96, 33, 255, 0.592) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgba(82, 255, 238, 0.65) 0%, rgba(96, 33, 255, 0.592) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgba(82, 255, 238, 0.65) 0%, rgba(96, 33, 255, 0.592) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"ffffff_1\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"13\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"\\",\\"animation_effect_delay\\":\\"\\",\\"animation_effect_repeat\\":\\"\\",\\"custom_parallax_scroll_speed\\":\\"\\",\\"custom_parallax_scroll_zindex\\":\\"\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"25\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"18\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"0ck6334\\"},{\\"row_order\\":\\"1\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"element_id\\":\\"iddc000\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Who we are<\\\\/h2><p>We develop strategies, create content, build products, launch campaigns, design systems and then some — all to inspire the people our brands care about most.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"gxd6493\\"},{\\"row_order\\":\\"2\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/jonathan-min.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"|\\",\\"height_image\\":\\"240\\",\\"title_image\\":\\"Jonathan\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"Founder\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"|\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"23c3d1\\",\\"border_bottom_width\\":\\"2\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_family_caption\\":\\"default\\",\\"font_color_caption\\":\\"23c3d1\\",\\"font_size_caption_unit\\":\\"px\\",\\"line_height_caption_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"iagn083\\"}],\\"styling\\":[],\\"element_id\\":\\"fsqj378\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/mandy-min.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"|\\",\\"height_image\\":\\"240\\",\\"title_image\\":\\"Man\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"Developer\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"|\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"23c3d1\\",\\"border_bottom_width\\":\\"2\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_family_caption\\":\\"default\\",\\"font_color_caption\\":\\"23c3d1\\",\\"font_size_caption_unit\\":\\"px\\",\\"line_height_caption_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"g1bd080\\"}],\\"styling\\":[],\\"element_id\\":\\"r5vo909\\"},{\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/sebastian-min.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"|\\",\\"height_image\\":\\"240\\",\\"title_image\\":\\"Sebastian\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"Creative Designer\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"|\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"23c3d1\\",\\"border_bottom_width\\":\\"2\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_family_caption\\":\\"default\\",\\"font_color_caption\\":\\"23c3d1\\",\\"font_size_caption_unit\\":\\"px\\",\\"line_height_caption_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"u2s7640\\"}],\\"styling\\":[],\\"element_id\\":\\"ijv2339\\"},{\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col4-1 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/147544687-260x240.jpg\\",\\"appearance_image\\":\\"|\\",\\"width_image\\":\\"260\\",\\"auto_fullwidth\\":\\"|\\",\\"height_image\\":\\"240\\",\\"title_image\\":\\"Kelly\\",\\"param_image\\":\\"|\\",\\"caption_image\\":\\"Content Writer\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"|\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"23c3d1\\",\\"border_bottom_width\\":\\"2\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_family_caption\\":\\"default\\",\\"font_color_caption\\":\\"23c3d1\\",\\"font_size_caption_unit\\":\\"px\\",\\"line_height_caption_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"g0vy098\\"}],\\"styling\\":[],\\"element_id\\":\\"jebv003\\"}],\\"element_id\\":\\"xqli008\\"}],\\"styling\\":[],\\"element_id\\":\\"a9ki933\\"}],\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\",\\"animation_effect\\":\\"\\",\\"animation_effect_delay\\":\\"\\",\\"animation_effect_repeat\\":\\"\\",\\"custom_parallax_scroll_speed\\":\\"\\",\\"custom_parallax_scroll_zindex\\":\\"\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"17\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"ax2t580\\"},{\\"row_order\\":\\"2\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"element_id\\":\\"b1fy180\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Our Services<\\\\/h2><p>We provide a wide array of software design and<br \\\\/> development services<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"lk2k878\\"},{\\"row_order\\":\\"2\\",\\"gutter\\":\\"gutter-none\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Wireframing\\",\\"content_feature\\":\\"<p>We create simple prototypes that can be transformed to efficient User experience<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-th-large\\",\\"icon_color_feature\\":\\"000000_1\\",\\"param_feature\\":\\"|\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"|\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"0\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\"}},\\"element_id\\":\\"ww0v097\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"\\"}},\\"element_id\\":\\"rbs3093\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"User Interface (UI)\\",\\"content_feature\\":\\"<p>The first thing that brings someone to your app is a beautiful, original and modern look and feel.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-sliders\\",\\"icon_color_feature\\":\\"000000_1\\",\\"param_feature\\":\\"|\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"|\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"ddd\\",\\"border_left_width\\":\\"1\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\"}},\\"element_id\\":\\"5vqj987\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"\\"}},\\"element_id\\":\\"34ji770\\"}],\\"element_id\\":\\"v6xg983\\"},{\\"row_order\\":\\"3\\",\\"gutter\\":\\"gutter-none\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"User Experience (UX) design\\",\\"content_feature\\":\\"<p>To create software that people will actually use, you need to create software that\\\'s simple and easy to use.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-connectdevelop\\",\\"icon_color_feature\\":\\"000000_1\\",\\"param_feature\\":\\"|\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"15\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_color\\":\\"ddd\\",\\"border_top_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right\\":\\"0\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_width\\":\\"0\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\"}},\\"element_id\\":\\"nx33080\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"\\"}},\\"element_id\\":\\"bisa930\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"mod_settings\\":{\\"title_feature\\":\\"Quality Assurance\\",\\"content_feature\\":\\"<p>Our specialized in-house QA team does the review and testing of all the software we build.<\\\\/p>\\",\\"layout_feature\\":\\"icon-left\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"small\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-check-square-o\\",\\"icon_color_feature\\":\\"000000_1\\",\\"param_feature\\":\\"|\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"15\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_color\\":\\"ddd\\",\\"border_top_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"ddd\\",\\"border_left_width\\":\\"1\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(0deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"0\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"|\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\"}},\\"element_id\\":\\"pl8c030\\"}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"\\"}},\\"element_id\\":\\"4o11398\\"}],\\"element_id\\":\\"j7q4803\\"}],\\"styling\\":[],\\"element_id\\":\\"9wc8773\\"}],\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\",\\"animation_effect\\":\\"\\",\\"animation_effect_delay\\":\\"\\",\\"animation_effect_repeat\\":\\"\\",\\"custom_parallax_scroll_speed\\":\\"\\",\\"custom_parallax_scroll_zindex\\":\\"\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"ecf2f4\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"fr5l003\\"},{\\"row_order\\":\\"3\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"element_id\\":\\"nqnh808\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Testimonials<\\\\/h3>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"000000_1.00\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"wawt383\\"},{\\"mod_name\\":\\"slider\\",\\"mod_settings\\":{\\"layout_display_slider\\":\\"text\\",\\"post_type\\":\\"post\\",\\"taxonomy\\":\\"category\\",\\"blog_category_slider\\":\\"|single\\",\\"portfolio_category_slider\\":\\"|single\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"content\\",\\"img_content_slider\\":[[]],\\"video_content_slider\\":[[]],\\"text_content_slider\\":[{\\"text_caption_slider\\":\\"<p>\\\\\\"Because of your skill, work and excellence so many doors have opened to us and we are poised to expand in some really huge ways.\\\\\\"<\\\\/p><p><strong>John Henry Doe<\\\\/strong>, Eye Heart World<\\\\/p>\\"},{\\"text_caption_slider\\":\\"<p>\\\\\\"Sed odio risus, ornare sed varius et, dapibus pellentesque mauris. Sed aliquet vulputate nisl, ut porttitor nulla placerat id.\\\\\\"<\\\\/p><p><strong>John Smith<\\\\/strong>, X-Company<\\\\/p>\\"},{\\"text_caption_slider\\":\\"<p>\\\\\\"Because of your skill, work and excellence so many doors have opened to us and we are poised to expand in some really huge ways.\\\\\\"<\\\\/p><p><strong>Peter Doe<\\\\/strong>, Themify<\\\\/p>\\"},{\\"text_caption_slider\\":\\"<p>\\\\\\"Sed odio risus, ornare sed varius et, dapibus pellentesque mauris. Sed aliquet vulputate nisl, ut porttitor nulla placerat id.\\\\\\"<\\\\/p><p><b>Alice<\\\\/b>, iHeart<\\\\/p>\\"}],\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"4\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_arrow_buttons_vertical\\":\\"|\\",\\"height_slider\\":\\"variable\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"line_height\\":\\"1.4\\",\\"line_height_unit\\":\\"em\\",\\"text_align\\":\\"left\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_family_content\\":\\"default\\",\\"font_size_content_unit\\":\\"px\\",\\"line_height_content_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"|\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_title\\":\\"default\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_family_content\\":\\"default\\",\\"font_size_content\\":\\"12\\",\\"font_size_content_unit\\":\\"px\\",\\"line_height_content_unit\\":\\"px\\"}},\\"element_id\\":\\"6hex229\\"}],\\"styling\\":[],\\"element_id\\":\\"eeik933\\"}],\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/testimonial-min-1024x342.jpg\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"best-fit-image\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"32c7d4\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"ffffff_1.00\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"\\",\\"animation_effect_delay\\":\\"\\",\\"animation_effect_repeat\\":\\"\\",\\"custom_parallax_scroll_speed\\":\\"\\",\\"custom_parallax_scroll_zindex\\":\\"\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"kgkj900\\"},{\\"row_order\\":\\"4\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"element_id\\":\\"xa9n983\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>How We Work<\\\\/h3>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"o48b933\\"},{\\"row_order\\":\\"2\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"sj9w090\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"4cm6148\\"}],\\"element_id\\":\\"7qtp939\\"},{\\"mod_name\\":\\"divider\\",\\"mod_settings\\":{\\"style_divider\\":\\"solid\\",\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"v47u844\\"},{\\"row_order\\":\\"4\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<div style=\\\\\\"color: #32c7d4;\\\\\\"><sup>01<\\\\/sup><\\\\/div>\\\\n<h2>Team<\\\\/h2>\\\\n\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"ai6l306\\"}],\\"styling\\":[],\\"element_id\\":\\"45nz034\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi tincidunt velit mi, et cursus dui maximus eu. Aenean malesuada felis dui, tincidunt elementum lacus tempus viverra. Nullam in lacus erat. Quisque quis gravida sapien. <\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"f4e7040\\"}],\\"styling\\":[],\\"element_id\\":\\"xqq4084\\"}],\\"element_id\\":\\"1hh0480\\"},{\\"mod_name\\":\\"divider\\",\\"mod_settings\\":{\\"style_divider\\":\\"solid\\",\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"zoyz099\\"},{\\"row_order\\":\\"6\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<div style=\\\\\\"color: #32c7d4;\\\\\\"><sup>02<\\\\/sup><\\\\/div><h2>Collaboration<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"emkm348\\"}],\\"styling\\":[],\\"element_id\\":\\"0xzz099\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Maecenas sed leo a dui accumsan commodo. Ut a porta leo. In vitae purus at augue tempus ultricies in eget tellus. Maecenas facilisis magna sit amet nulla lobortis, eget cursus odio finibus. <\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"080n308\\"}],\\"styling\\":[],\\"element_id\\":\\"2kze108\\"}],\\"element_id\\":\\"jqvw011\\"},{\\"mod_name\\":\\"divider\\",\\"mod_settings\\":{\\"style_divider\\":\\"solid\\",\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"dddddd\\",\\"divider_type\\":\\"fullwidth\\",\\"divider_width\\":\\"200\\",\\"divider_align\\":\\"left\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"2ve1038\\"},{\\"row_order\\":\\"8\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2 first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<div style=\\\\\\"color: #32c7d4;\\\\\\"><sup>03<\\\\/sup><\\\\/div>\\\\n<h2>Results<\\\\/h2>\\\\n\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"i790248\\"}],\\"styling\\":[],\\"element_id\\":\\"ijjz494\\"},{\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2 last\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Nullam tortor metus, egestas quis sagittis non, mattis id enim. Pellentesque lacinia, mi at iaculis fermentum, ex nisl porta sapien, nec gravida elit ligula at nulla.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"w5ob942\\"}],\\"styling\\":[],\\"element_id\\":\\"5try042\\"}],\\"element_id\\":\\"debr840\\"}],\\"styling\\":[],\\"element_id\\":\\"xy0a000\\"}],\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\",\\"animation_effect\\":\\"\\",\\"animation_effect_delay\\":\\"\\",\\"animation_effect_repeat\\":\\"\\",\\"custom_parallax_scroll_speed\\":\\"\\",\\"custom_parallax_scroll_zindex\\":\\"\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"px\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"aw8x083\\"},{\\"row_order\\":\\"5\\",\\"gutter\\":\\"gutter-default\\",\\"equal_column_height\\":\\"\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first\\",\\"grid_width\\":\\"\\",\\"modules\\":[{\\"element_id\\":\\"p75a042\\"},{\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Let\\\'s talk about your project?<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_family_h1\\":\\"default\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"font_family_h2\\":\\"default\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"font_family_h3\\":\\"default\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"font_family_h4\\":\\"default\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"font_family_h5\\":\\"default\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"font_family_h6\\":\\"default\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"ekbo380\\"},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"http:\\\\/\\\\/themifydemo.me\\\\/r\\\\/mu\\\\/ultra-skin-agency\\\\/contact\\\\/\\",\\"button_color_bg\\":\\"default\\",\\"new_window\\":[]}],\\"background_image-type\\":\\"image\\",\\"background_image-type_image\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"180\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"font_family\\":\\"default\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"padding_top_link_unit\\":\\"px\\",\\"padding_right_link_unit\\":\\"px\\",\\"padding_bottom_link_unit\\":\\"px\\",\\"padding_left_link_unit\\":\\"px\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_margin_top_unit\\":\\"px\\",\\"link_margin_right_unit\\":\\"px\\",\\"link_margin_bottom_unit\\":\\"px\\",\\"link_margin_left_unit\\":\\"px\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_border_top_style\\":\\"solid\\",\\"link_border_right_style\\":\\"solid\\",\\"link_border_bottom_style\\":\\"solid\\",\\"link_border_left_style\\":\\"solid\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_reverse\\":\\"|\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_desktop_show\\":\\"show\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_tablet_show\\":\\"show\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile\\":\\"show\\",\\"visibility_mobile_show\\":\\"show\\",\\"visibility_mobile_hide\\":\\"hide\\"},\\"element_id\\":\\"r9ks004\\"}],\\"styling\\":[],\\"element_id\\":\\"pm5o432\\"}],\\"styling\\":{\\"row_width\\":\\"\\",\\"row_height\\":\\"\\",\\"custom_css_row\\":\\"\\",\\"row_anchor\\":\\"\\",\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/drive-863123.jpg\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgba(255, 236, 140, 0.670588)|100% rgba(45, 227, 224, 0.8)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgba(255, 236, 140, 0.670588) 0%, rgba(45, 227, 224, 0.8) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgba(255, 236, 140, 0.670588) 0%, rgba(45, 227, 224, 0.8) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgba(255, 236, 140, 0.670588) 0%, rgba(45, 227, 224, 0.8) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgba(255, 236, 140, 0.670588) 0%, rgba(45, 227, 224, 0.8) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgba(255, 236, 140, 0.670588) 0%, rgba(45, 227, 224, 0.8) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"\\",\\"animation_effect_delay\\":\\"\\",\\"animation_effect_repeat\\":\\"\\",\\"custom_parallax_scroll_speed\\":\\"\\",\\"custom_parallax_scroll_zindex\\":\\"\\",\\"visibility_desktop\\":\\"show\\",\\"visibility_tablet\\":\\"show\\",\\"visibility_mobile\\":\\"show\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_slider\\":\\"\\",\\"background_slider_size\\":\\"\\",\\"background_slider_mode\\":\\"\\",\\"background_video\\":\\"\\",\\"background_image\\":\\"\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"background_repeat\\":\\"\\",\\"background_position\\":\\"\\",\\"background_color\\":\\"\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_gradient_hover-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\r\\\\n\\",\\"font_family\\":\\"default\\",\\"font_color\\":\\"\\",\\"font_size\\":\\"\\",\\"font_size_unit\\":\\"px\\",\\"line_height\\":\\"\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"\\",\\"link_color\\":\\"\\",\\"text_decoration\\":\\"\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top\\":\\"\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right\\":\\"\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom\\":\\"\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left\\":\\"\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"\\",\\"border_top_width\\":\\"\\",\\"border_top_style\\":\\"solid\\",\\"border_right_color\\":\\"\\",\\"border_right_width\\":\\"\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_color\\":\\"\\",\\"border_bottom_width\\":\\"\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_color\\":\\"\\",\\"border_left_width\\":\\"\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},\\"element_id\\":\\"er0g899\\"},{\\"row_order\\":\\"6\\",\\"gutter\\":\\"gutter-default\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full first last\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"element_id\\":\\"dzb3029\\"}],\\"element_id\\":\\"uvdu090\\"}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 317,
  'post_date' => '2016-08-12 04:19:43',
  'post_date_gmt' => '2016-08-12 04:19:43',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2017-01-10 22:31:08',
  'post_modified_gmt' => '2017-01-10 22:31:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?page_id=317',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'body_background_repeat' => 'fullcover',
    'background_repeat' => 'fullcover',
    'query_category' => '0',
    'display_content' => 'excerpt',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"gutter\\":\\"gutter-default\\",\\"column_alignment\\":\\"col_align_top\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"grid_width\\":\\"\\",\\"modules\\":[],\\"styling\\":[],\\"element_id\\":\\"qgbc301\\"}],\\"styling\\":[],\\"element_id\\":\\"5f8s106\\"}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 15,
  'post_date' => '2016-08-03 12:52:55',
  'post_date_gmt' => '2016-08-03 12:52:55',
  'post_content' => '<!--themify_builder_static--><h1>Contact</h1><h5>Ready To Share Your Story? We are listening.</h5>

<p>A. 123 North Steel 19th Street, G<br /> Block. 689 / Melbourne 1280</p>

<p>T. +61 (0) 142 9900 021<br /> F. +88 (0) 202 0000 0XX</p>

<p>M. mail@yourdomain.com</p>
<h3>Want to work with us?</h3><p>Use the contact form below to send us messages. We usually respond within 48hrs. If you didn\'t hear from us, please email us directly.</p>
<form action="https://themify.me/demo/themes/ultra-agency/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject </label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <label> <input type="checkbox" name="contact-sendcopy" id="contact-0--sendcopy" value="1" /> Send Copy </label> <label> <input type="checkbox" name="gdpr" value="1" required/> I consent to my submitted data being collected and stored * </label> <button type="submit"> Send </button> </form>
Visit us<!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2020-04-16 21:38:53',
  'post_modified_gmt' => '2020-04-16 21:38:53',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?page_id=15',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_full_scrolling' => 'no',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'transparent',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'background_auto' => 'yes',
    'background_autotimeout' => '5',
    'background_speed' => '500',
    'background_wrap' => 'yes',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'order' => 'desc',
    'orderby' => 'date',
    'layout' => 'list-post',
    'display_content' => 'content',
    'feature_size_page' => 'blank',
    'hide_title' => 'default',
    'unlink_title' => 'default',
    'hide_date' => 'default',
    'hide_image' => 'default',
    'unlink_image' => 'default',
    'hide_navigation' => 'default',
    'portfolio_order' => 'desc',
    'portfolio_orderby' => 'date',
    'portfolio_layout' => 'list-post',
    'portfolio_display_content' => 'content',
    'portfolio_feature_size_page' => 'blank',
    'portfolio_hide_title' => 'default',
    'portfolio_unlink_title' => 'default',
    'portfolio_hide_meta_all' => 'default',
    'portfolio_hide_image' => 'default',
    'portfolio_unlink_image' => 'default',
    'portfolio_hide_navigation' => 'default',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"20o7665\\",\\"cols\\":[{\\"element_id\\":\\"4dhx676\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bftm680\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Contact<\\\\/h1><h5>Ready To Share Your Story? We are listening.<\\\\/h5>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/ipad-605420_1920.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"000000_0.60\\",\\"cover_gradient-gradient-angle\\":\\"152\\",\\"cover_gradient-gradient\\":\\"0% rgba(255, 239, 120, 0.773)|100% rgba(214, 51, 255, 0.8)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"13\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"25\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"ds4w666\\",\\"cols\\":[{\\"element_id\\":\\"cehw684\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"maiy684\\",\\"mod_settings\\":{\\"icon_size\\":\\"xlarge\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-map-marker\\",\\"icon_color_bg\\":\\"tb_default_color\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0c6h685\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>A. 123 North Steel 19th Street, G<br \\\\/> Block. 689 \\\\/ Melbourne 1280<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"1zu0685\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"c4i9685\\",\\"mod_settings\\":{\\"icon_size\\":\\"xlarge\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-mobile\\",\\"icon_color_bg\\":\\"tb_default_color\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ho83686\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>T. +61 (0) 142 9900 021<br \\\\/> F. +88 (0) 202 0000 0XX<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"rtnd686\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"pwlf686\\",\\"mod_settings\\":{\\"icon_size\\":\\"xlarge\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-user\\",\\"icon_color_bg\\":\\"tb_default_color\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5zc9687\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>M. mail@yourdomain.com<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_color\\":\\"56f7e4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"000000_1.00\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"c29x667\\",\\"cols\\":[{\\"element_id\\":\\"5j9j687\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"45mm688\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Want to work with us?<\\\\/h3><p>Use the contact form below to send us messages. We usually respond within 48hrs. If you didn\\\'t hear from us, please email us directly.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"rcsc688\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_border_inputs_apply_all\\":\\"1\\",\\"checkbox_border_send_apply_all\\":\\"1\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"checkbox_border_success_message_apply_all\\":\\"1\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"checkbox_border_error_message_apply_all\\":\\"1\\",\\"layout_contact\\":\\"style1\\",\\"gdpr\\":\\"accept\\",\\"field_subject_active\\":\\"yes\\",\\"field_extra\\":\\"{\\\\\\"fields\\\\\\":[]}\\",\\"field_captcha_active\\":\\"yes\\",\\"field_sendcopy_active\\":\\"yes\\",\\"field_order\\":\\"{\\\\\\"undefined\\\\\\":0,\\\\\\"field_name_label\\\\\\":0,\\\\\\"field_email_label\\\\\\":1,\\\\\\"field_subject_label\\\\\\":2,\\\\\\"field_message_label\\\\\\":3,\\\\\\"field_extra\\\\\\":4,\\\\\\"field_captcha_label\\\\\\":0,\\\\\\"field_sendcopy_label\\\\\\":1,\\\\\\"field_order\\\\\\":2,\\\\\\"field_send_label\\\\\\":3}\\",\\"field_send_align\\":\\"left\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"contact_sent_from\\":\\"enable\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"17\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"17.5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"0\\",\\"padding_left\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"20\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"3u92667\\",\\"cols\\":[{\\"element_id\\":\\"9vln690\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"c6nr691\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"500\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"cool-grey\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"yes\\",\\"zoom_map\\":\\"16\\",\\"map_center\\":\\"1981 Broadway\\\\nNew York, NY 10023\\",\\"markers\\":[{\\"address\\":\\"1981 Broadway\\\\nNew York, NY 10023\\",\\"title\\":\\"Visit us\\",\\"image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/Apple-logo.png\\"}],\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"w_map_unit\\":\\"%\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"#ff0000_1\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"eeeeee_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 18,
  'post_date' => '2016-08-03 13:03:41',
  'post_date_gmt' => '2016-08-03 13:03:41',
  'post_content' => '<!--themify_builder_static--><h1> Tailored solution <br> for designers </h1>
<a href="https://themify.me/" > Learn more </a>
<h3> Responsive Layout </h3> <p>Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod.</p>
<h3> Custom Flexible Items </h3> <p>Tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.</p>
<h3> Subtle & Clean Design </h3> <p>Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.</p>
<h2>Great Features</h2><h5>Contemporary Design.</h5><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.</p>
<a href="https://themify.me/" > Learn More </a>
<h2>Great Experience</h2><h5>Best Practice Design.</h5><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.</p>
<a href="https://themify.me/" > Learn More </a>
<h3>Easy Access</h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.</p>
<a href="https://themify.me/" > Learn More </a>
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/great-feature-single-1-789x453.png" width="789" height="453" alt="great feature single 1" srcset="https://themify.me/demo/themes/ultra-agency/files/2016/08/great-feature-single-1.png 789w, https://themify.me/demo/themes/ultra-agency/files/2016/08/great-feature-single-1-300x172.png 300w, https://themify.me/demo/themes/ultra-agency/files/2016/08/great-feature-single-1-768x441.png 768w" sizes="(max-width: 789px) 100vw, 789px" />
<h3>Who are our clients</h3><p>Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.</p>
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/sony-min.png" alt="sony-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/apple-min.png" alt="apple-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/cisco-min.png" alt="cisco-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/google-min.png" alt="google-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/microsoft-min.png" alt="microsoft-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/amazon-min.png" alt="amazon-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/pixeden-min.png" alt="pixeden-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/yahoo-min-1.png" alt="yahoo-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/hp-min.png" alt="hp-min" />
<img src="https://themify.me/demo/themes/ultra-agency/files/2016/08/nvidia-min.png" alt="nvidia-min" />
<h3>Our workflow</h3>
<p>Analyze </p>
<p>Revise</p>
<p>Refine</p>
<h3>A few facts about our company</h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.</p>
<i>Pellentesque facilisis</i> <i>Lorem ipsum dolor</i> <i>Labore et dolore</i>
<h3>Build your site now</h3>
<a href="https://themify.me/demo/themes/ultra-agency/contact/" > Contact Us </a> <a href="https://themify.me" > Buy Theme </a>
Visit us
<h5>Address</h5><p>299 Street Avenue<br />New York City</p><hr /><p>M. mail@yourdomain.com<br /> T. 344-366-6868</p><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2020-04-16 21:37:37',
  'post_modified_gmt' => '2020-04-16 21:37:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?page_id=18',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'body_background_repeat' => 'fullcover',
    'mobile_menu_styles' => 'default',
    'header_wrap' => 'transparent',
    'background_repeat' => 'fullcover',
    'display_content' => 'content',
    'portfolio_display_content' => 'content',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"oswt31\\",\\"cols\\":[{\\"element_id\\":\\"3px435\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"typewriter\\",\\"element_id\\":\\"exqb36\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"span_background_color\\":\\"fff200_0.63\\",\\"span_font_color\\":\\"#ffffff\\",\\"span_padding_top\\":\\"7\\",\\"span_padding_right\\":\\"7\\",\\"span_padding_bottom\\":\\"7\\",\\"span_padding_left\\":\\"7\\",\\"checkbox_span_border_apply_all\\":\\"1\\",\\"builder_typewriter_tag\\":\\"h1\\",\\"builder_typewriter_text_before\\":\\"Tailored solution <br> for\\",\\"builder_typewriter_terms\\":[{\\"builder_typewriter_term\\":\\"designers\\"},{\\"builder_typewriter_term\\":\\"developers\\"},{\\"builder_typewriter_term\\":\\"you\\"}],\\"builder_typewriter_highlight_speed\\":\\"50\\",\\"builder_typewriter_type_speed\\":\\"60\\",\\"builder_typewriter_clear_delay\\":\\"1.5\\",\\"builder_typewriter_type_delay\\":\\"0.2\\",\\"builder_typewriter_typer_interval\\":\\"1.5\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"i9lz37\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"link_color\\":\\"ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\"},\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}]}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"video\\",\\"background_video\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/typing-keyboard_720p.mp4\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/typing-keyboard.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"544cad_1.00\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"000000_0.73\\",\\"cover_gradient-gradient\\":\\"0% rgba(235, 122, 255, 0.729412)|100% rgba(22, 48, 135, 0.941176)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"18\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"3pxq31\\",\\"cols\\":[{\\"element_id\\":\\"43mi38\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"qc9q39\\",\\"mod_settings\\":{\\"title_feature\\":\\"Responsive Layout\\",\\"content_feature\\":\\"<p>Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-desktop\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"zoomIn\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"0\\"},\\"icon_color_feature\\":\\"#000\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"0\\",\\"padding_right\\":\\"0\\",\\"padding_bottom\\":\\"0\\",\\"padding_left\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"rsip39\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"e4cj39\\",\\"mod_settings\\":{\\"title_feature\\":\\"Custom Flexible Items\\",\\"content_feature\\":\\"<p>Tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-tag\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"zoomIn\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"0\\"},\\"icon_color_feature\\":\\"#000\\"}}]},{\\"element_id\\":\\"klah39\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"w7fx39\\",\\"mod_settings\\":{\\"title_feature\\":\\"Subtle & Clean Design\\",\\"content_feature\\":\\"<p>Quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo.<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"2\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-clone\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"zoomIn\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"0\\"},\\"icon_color_feature\\":\\"#000\\"}}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"jcbj31\\",\\"cols\\":[{\\"element_id\\":\\"qmgd40\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"vpo940\\",\\"cols\\":[{\\"element_id\\":\\"ze2541\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"575m41\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Great Features<\\\\/h2><h5>Contemporary Design.<\\\\/h5><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"85qd41\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\",\\"button_color_bg\\":\\"tb_default_color\\"}]}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"23c3d1\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"checkbox_border_inner_apply_all\\":\\"1\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"7\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\"}}]}],\\"styling\\":{\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/great-features-min.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"mgpc42\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"6q5f42\\",\\"cols\\":[{\\"element_id\\":\\"e1nv42\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"nxuy42\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Great Experience<\\\\/h2><h5>Best Practice Design.<\\\\/h5><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"6o9y42\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}]}}],\\"styling\\":{\\"background_color\\":\\"ecf2f4\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"7\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}],\\"styling\\":{\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/great-experience-min.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"a1rg31\\",\\"cols\\":[{\\"element_id\\":\\"kygb43\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lbcb43\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Easy Access<\\\\/h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"slideInLeft\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"7unv43\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"animation_effect\\":\\"slideInLeft\\"}}]},{\\"element_id\\":\\"9ml843\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1amq44\\",\\"mod_settings\\":{\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/great-feature-single-1.png\\",\\"width_image\\":\\"789\\",\\"height_image\\":\\"453\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"slideInRight\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"margin\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"background_color\\":\\"ecf2f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"16\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"rrr532\\",\\"cols\\":[{\\"element_id\\":\\"61fe44\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"lbkr44\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Who are our clients<\\\\/h3><p>Sed purus sem, bibendum quis ligula sit amet, pellentesque cursus odio. Donec quis egestas elit. Sed a nibh lobortis, tristique tortor actium.<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"element_id\\":\\"9uyh44\\",\\"cols\\":[{\\"element_id\\":\\"g2w344\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"84fa45\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/sony-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"xzv545\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9y2z45\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/apple-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"xek345\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"lsyd45\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/cisco-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"3dxa46\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"yob046\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/google-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"d5ju46\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4yms46\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/microsoft-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]},{\\"element_id\\":\\"1s6546\\",\\"cols\\":[{\\"element_id\\":\\"5oya46\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"5nm447\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/amazon-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"1l6j47\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"86pz47\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/pixeden-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"mz1x47\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"mmcn47\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/yahoo-min-1.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"h1aj48\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"q1ky48\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/hp-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"ox5348\\",\\"grid_class\\":\\"col5-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"j7xw48\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/nvidia-min.png\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}]}]}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"16\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"2p7432\\",\\"cols\\":[{\\"element_id\\":\\"mh7r49\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ss5249\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our workflow<\\\\/h3>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"slideInLeft\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"biwi49\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"element_id\\":\\"lloj49\\",\\"cols\\":[{\\"element_id\\":\\"2gv649\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"0lm149\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Analyze <\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"1\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-mobile\\",\\"animation_effect\\":\\"slideInRight\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"margin_bottom\\":\\"0\\"},\\"icon_color_feature\\":\\"#000\\"}}]},{\\"element_id\\":\\"m6ee50\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"k3gt50\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Revise<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"1\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-desktop\\",\\"animation_effect\\":\\"slideInRight\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"0\\"},\\"icon_color_feature\\":\\"#000\\"}}]},{\\"element_id\\":\\"el6u50\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"feature\\",\\"element_id\\":\\"ld4950\\",\\"mod_settings\\":{\\"content_feature\\":\\"<p>Refine<\\\\/p>\\",\\"layout_feature\\":\\"icon-top\\",\\"circle_percentage_feature\\":\\"100\\",\\"circle_stroke_feature\\":\\"1\\",\\"circle_color_feature\\":\\"23c3d1\\",\\"circle_size_feature\\":\\"medium\\",\\"icon_type_feature\\":\\"icon\\",\\"icon_feature\\":\\"fa-object-ungroup\\",\\"animation_effect\\":\\"slideInRight\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"0\\"},\\"icon_color_feature\\":\\"#000\\"}}]}],\\"gutter\\":\\"gutter-narrow\\"}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_color\\":\\"eee\\",\\"border_top_width\\":\\"1\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"17\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"5hsi32\\",\\"cols\\":[{\\"element_id\\":\\"rjgh51\\",\\"grid_class\\":\\"col3-1\\",\\"styling\\":{\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/our-company-team-min.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"b0b0b0_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"170\\",\\"padding_bottom\\":\\"170\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"u1lf51\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"8h0d51\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>A few facts about our company<\\\\/h3><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.<\\\\/p>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"bsrk51\\",\\"mod_settings\\":{\\"progress_bars\\":[{\\"bar_label\\":\\"Pellentesque facilisis\\",\\"bar_percentage\\":\\"80\\",\\"bar_color\\":\\"23c3d1\\"},{\\"bar_label\\":\\"Lorem ipsum dolor\\",\\"bar_percentage\\":\\"65\\",\\"bar_color\\":\\"23c3d1\\"},{\\"bar_label\\":\\"Labore et dolore\\",\\"bar_percentage\\":\\"70\\",\\"bar_color\\":\\"23c3d1\\"}],\\"hide_percentage_text\\":\\"no\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"7\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"120\\",\\"padding_left\\":\\"7\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"ecf2f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"nky332\\",\\"cols\\":[{\\"element_id\\":\\"fifw52\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"da1x52\\",\\"cols\\":[{\\"element_id\\":\\"cdip52\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2mbt52\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Build your site now<\\\\/h3>\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"e4du52\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"di1x53\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"checkbox_link_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\"},\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"},{\\"label\\":\\"Buy Theme\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}]}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"right\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"left\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"gutter\\":\\"gutter-none\\"}],\\"styling\\":{\\"background_color\\":\\"ffffff_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"40\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"b_sh_inset\\":false,\\"b_sh_spread_unit\\":\\"px\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_hOffset_unit\\":\\"px\\"}}],\\"styling\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_zindex\\":\\"2\\",\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_top\\":\\"0\\",\\"margin_right\\":\\"0\\",\\"margin_bottom\\":\\"0\\",\\"margin_left\\":\\"0\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"hide_anchor\\":false,\\"zi\\":\\"1\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"-70\\",\\"margin-top_opp_top\\":false,\\"margin-top_unit\\":\\"px\\",\\"margin-top\\":\\"-70\\"}},{\\"element_id\\":\\"5y5232\\",\\"cols\\":[{\\"element_id\\":\\"l8sy53\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"jd6o53\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"500\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"cool-grey\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"desktop_only\\",\\"disable_map_ui\\":\\"yes\\",\\"zoom_map\\":\\"16\\",\\"map_center\\":\\"1981 Broadway\\\\nNew York, NY 10023\\",\\"markers\\":[{\\"address\\":\\"1981 Broadway\\\\nNew York, NY 10023\\",\\"title\\":\\"Visit us\\",\\"image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/Apple-logo.png\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"w_map_unit\\":\\"%\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"eeeeee_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"e3tf32\\",\\"cols\\":[{\\"element_id\\":\\"l1k954\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"flyu54\\",\\"mod_settings\\":{\\"content_text\\":\\"<h5>Address<\\\\/h5><p>299 Street Avenue<br \\\\/>New York City<\\\\/p><hr \\\\/><p>M. mail@yourdomain.com<br \\\\/> T. 344-366-6868<\\\\/p>\\",\\"add_css_text\\":\\"tf_contact-details\\",\\"background_color\\":\\"23c3d1\\",\\"font_color\\":\\"ffffff_1.00\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_h5\\":\\"ffffff_1\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"0\\",\\"margin_bottom\\":\\"0\\"}}}]}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 108,
  'post_date' => '2016-08-06 17:41:40',
  'post_date_gmt' => '2016-08-06 17:41:40',
  'post_content' => '<!--themify_builder_static--><h1 style="margin-bottom: 0;">Portfolio</h1><h5>We’ve worked with some of the world most recognized brands.</h5> 
 <h2>Need a kickstart?</h2> 
 <a href="https://themify.me/demo/themes/ultra-agency/contact/" >Contact Us</a><!--/themify_builder_static-->',
  'post_title' => 'Portfolio',
  'post_excerpt' => '',
  'post_name' => 'portfolio',
  'post_modified' => '2019-01-01 06:45:49',
  'post_modified_gmt' => '2019-01-01 06:45:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?page_id=108',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'body_background_repeat' => 'fullcover',
    'header_wrap' => 'transparent',
    'background_repeat' => 'fullcover',
    'imagefilter_options' => 'grayscale',
    'imagefilter_options_hover' => 'none',
    'display_content' => 'content',
    'portfolio_display_content' => 'content',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"fe58c64\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"bb1b33d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2c0aaca\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1 style=\\\\\\\\\\\\\\"margin-bottom: 0;\\\\\\\\\\\\\\">Portfolio<\\\\/h1><h5>We’ve worked with some of the world most recognized brands.<\\\\/h5>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/photo-1416339306562-f3d12fefd36f.jpg\\",\\"background_repeat\\":\\"builder-parallax-scrolling\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"000000_0.57\\",\\"cover_gradient-gradient\\":\\"0% rgba(155, 172, 173, 0.658824)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"000000_1.00\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"000000_1.00\\",\\"padding_top\\":\\"13\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"25\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"18\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"a351e37\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"0e1eb13\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"b50afb2\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"portfolio\\",\\"type_query_post\\":\\"portfolio-category\\",\\"category_post\\":\\"|single\\",\\"post_tag_post\\":\\"|single\\",\\"portfolio-category_post\\":\\"0|multiple\\",\\"post_per_page_post\\":\\"9\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"386\\",\\"img_height_post\\":\\"270\\",\\"hide_post_date_post\\":\\"yes\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"no\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"9366779\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"8148347\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"914a114\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Need a kickstart?<\\\\/h2>\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"wobble\\",\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"1bd24e1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_style\\":\\"outline\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"fe58c64\\",\\"unstick_when_el_mod_id\\":\\"2c0aaca\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/06\\\\/desk-601540.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"000000_0.54\\",\\"cover_gradient-gradient-angle\\":\\"0\\",\\"cover_gradient-gradient\\":\\"0% rgba(0, 0, 0, 0.741176)|56% rgba(20, 19, 19, 0.529412)|98% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"link_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"c21503e\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"07ac711\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 530,
  'post_date' => '2018-03-23 20:18:14',
  'post_date_gmt' => '2018-03-23 20:18:14',
  'post_content' => '',
  'post_title' => 'Agency',
  'post_excerpt' => '',
  'post_name' => 'agency',
  'post_modified' => '2018-03-23 20:18:14',
  'post_modified_gmt' => '2018-03-23 20:18:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/tbuilder-layout-part/agency/',
  'menu_order' => 0,
  'post_type' => 'tbuilder_layout_part',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"typewriter\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"span_background_color\\":\\"fff200_0.63\\",\\"span_font_color\\":\\"#000000\\",\\"span_padding_top\\":\\"7\\",\\"span_padding_right\\":\\"7\\",\\"span_padding_bottom\\":\\"7\\",\\"span_padding_left\\":\\"7\\",\\"checkbox_span_border_apply_all\\":\\"1\\",\\"builder_typewriter_tag\\":\\"h1\\",\\"builder_typewriter_text_before\\":\\"Tailored solution <br> for\\",\\"builder_typewriter_terms\\":[{\\"builder_typewriter_term\\":\\"designers\\"},{\\"builder_typewriter_term\\":\\"developers\\"},{\\"builder_typewriter_term\\":\\"you\\"}],\\"builder_typewriter_highlight_speed\\":\\"50\\",\\"builder_typewriter_type_speed\\":\\"60\\",\\"builder_typewriter_clear_delay\\":\\"1.5\\",\\"builder_typewriter_type_delay\\":\\"0.2\\",\\"builder_typewriter_typer_interval\\":\\"1.5\\",\\"cid\\":\\"c21\\"}},{\\"mod_name\\":\\"buttons\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"Learn more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"button_color_bg\\":\\"blue\\",\\"new_window\\":[\\"1\\"]}],\\"custom_parallax_scroll_reverse_reverse\\":\\"reverse\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"background_image-type\\":\\"image\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"link_color\\":\\"ffffff_1\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"padding_bottom\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\"},\\"cid\\":\\"c25\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"50\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_type\\":\\"video\\",\\"background_video\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/typing-keyboard_720p.mp4\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/typing-keyboard.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_color\\":\\"544cad_1.00\\",\\"cover_color-type\\":\\"cover_gradient\\",\\"cover_color\\":\\"000000_0.73\\",\\"cover_gradient-gradient\\":\\"0% rgba(235, 122, 255, 0.729412)|100% rgba(22, 48, 135, 0.941176)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"18\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 151,
  'post_date' => '2016-08-11 06:59:41',
  'post_date_gmt' => '2016-08-11 06:59:41',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Galmour',
  'post_excerpt' => 'Digital, Identity',
  'post_name' => 'galmour',
  'post_modified' => '2016-08-16 00:22:47',
  'post_modified_gmt' => '2016-08-16 00:22:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=151',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309718:72\\",\\"element_id\\":\\"i0wy013\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"swyq813\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f6dw170\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"rrz8873\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"a2zt010\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"q87b330\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"6ql1888\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"efyd717\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"g39d880\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ozks178\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zz6l030\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"urrp708\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"uq0c001\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"j6vb808\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"m7rd013\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"pyzo788\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1347893\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"u2zg807\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hnh1233\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"h29l037\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dv4j434\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pju5880\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"p4bm661\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"zzgp873\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"l3wy983\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"mrmd981\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ykvx801\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"533n203\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"\\",\\"element_id\\":\\"88s5283\\"},\\"_thumbnail_id\\":{\\"0\\":\\"165\\",\\"element_id\\":\\"r8zr830\\"},\\"_post_image_attach_id\\":{\\"0\\":\\"165\\",\\"element_id\\":\\"7a43000\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/ipad-605420_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 149,
  'post_date' => '2016-08-10 06:58:36',
  'post_date_gmt' => '2016-08-10 06:58:36',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.
Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Spring/Summer 2016',
  'post_excerpt' => 'App Experience Design',
  'post_name' => 'springsummer-2016',
  'post_modified' => '2016-08-16 00:23:56',
  'post_modified_gmt' => '2016-08-16 00:23:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=149',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471307037:72\\",\\"element_id\\":\\"0kac620\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"irk1003\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"koju209\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"f62c322\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"lnq8009\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"1gj5930\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"kfzg019\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"qsc5232\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"p0so030\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"t56p005\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6juw223\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3yxl070\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"2l6m033\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"p0p4022\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4m5u232\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"pzlh000\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8q8f490\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qpc4022\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"gir3626\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vxto828\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"laal920\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"atgg303\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"lx0c029\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"plwf333\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"qbp2904\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ilj4920\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wzsi309\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"ioiy003\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"7\\",\\"element_id\\":\\"qwkl039\\"},\\"_thumbnail_id\\":{\\"0\\":\\"444\\",\\"element_id\\":\\"wi5c209\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/ipad-820272_1920.jpg\\",\\"element_id\\":\\"m898200\\"},\\"_post_image_attach_id\\":{\\"0\\":\\"444\\",\\"element_id\\":\\"ausb423\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/ipad-820272_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 147,
  'post_date' => '2016-08-09 06:57:39',
  'post_date_gmt' => '2016-08-09 06:57:39',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Watch App',
  'post_excerpt' => 'Web Design',
  'post_name' => 'watch-app',
  'post_modified' => '2016-08-16 00:26:19',
  'post_modified_gmt' => '2016-08-16 00:26:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=147',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471307083:72\\",\\"element_id\\":\\"ig71555\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"8yc8100\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pb23400\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"b2te004\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"kvdj051\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"4jlq000\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"0eex221\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"va7c100\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"yaw8082\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zlpy060\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"evgc200\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"gug1030\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"81is050\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"w3se270\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vpap860\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"0fwj020\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"453b701\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lo8h000\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"jxga201\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e450920\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ri7c020\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dspt192\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"zzj5000\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"ymlw900\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"26qt912\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"azpl090\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hjxk011\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"79zv020\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"\\",\\"element_id\\":\\"db6r000\\"},\\"_thumbnail_id\\":{\\"0\\":\\"446\\",\\"element_id\\":\\"l0ml250\\"},\\"_post_image_attach_id\\":{\\"0\\":\\"446\\",\\"element_id\\":\\"1hkz101\\"},\\"_wp_old_slug\\":{\\"0\\":\\"portfolio-aaron-porter\\",\\"element_id\\":\\"itwn010\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/fashion-916400_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 187,
  'post_date' => '2016-08-08 06:50:11',
  'post_date_gmt' => '2016-08-08 06:50:11',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Voice and Music',
  'post_excerpt' => 'App Experience Design
',
  'post_name' => 'voice-and-music',
  'post_modified' => '2016-08-16 00:27:48',
  'post_modified_gmt' => '2016-08-16 00:27:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=187',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471307138:72\\",\\"element_id\\":\\"2opq550\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"8s6q115\\"},\\"_thumbnail_id\\":{\\"0\\":\\"188\\",\\"element_id\\":\\"cgx0162\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/mobile-616012_1920.jpg\\",\\"element_id\\":\\"s136588\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zf9k520\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"63qm285\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"5184000\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"a128055\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"n1b0520\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"wrgt505\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"slen577\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tq3j582\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hk3q585\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1n7a852\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"8lv5580\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"scup552\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2v57308\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"ir1z552\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ekuq535\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"b6pb058\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3fev880\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"u0hq405\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"27im080\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2qz3258\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"9pye302\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"ov42045\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"43tm500\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"a1of070\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"9u3h088\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"scdl880\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"7\\",\\"element_id\\":\\"xwks258\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/mobile-616012_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 161,
  'post_date' => '2016-08-05 06:03:10',
  'post_date_gmt' => '2016-08-05 06:03:10',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae. Vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'Elegance',
  'post_excerpt' => 'Digital, Identity
',
  'post_name' => 'elegance',
  'post_modified' => '2016-08-16 00:29:24',
  'post_modified_gmt' => '2016-08-16 00:29:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=161',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309717:72\\",\\"element_id\\":\\"kt7n150\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"7psb040\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"r177000\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"ntoo124\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"66uy042\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"wq9u070\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"70wq040\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"pguh440\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6v65727\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8b3p220\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tm82373\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4g1w077\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"7l4l407\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"o8o0400\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"yu46333\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"dfw1674\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"yvps440\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2dnj535\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c1os740\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"nrpe444\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"w1uf047\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wws9037\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"uukc747\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"z6zu447\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"gp64544\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"73sf007\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"m92y940\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"ufs3437\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"9\\",\\"element_id\\":\\"87od574\\"},\\"_thumbnail_id\\":{\\"0\\":\\"438\\",\\"element_id\\":\\"tywq754\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/smart-watch-821557_1920.jpg\\",\\"element_id\\":\\"vyqm554\\"},\\"_post_image_attach_id\\":{\\"0\\":\\"438\\",\\"element_id\\":\\"8ho3455\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/smart-watch-821557_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 119,
  'post_date' => '2016-08-03 06:51:01',
  'post_date_gmt' => '2016-08-03 06:51:01',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Oxford House',
  'post_excerpt' => 'Identity Design',
  'post_name' => 'oxford-house',
  'post_modified' => '2016-08-12 03:15:23',
  'post_modified_gmt' => '2016-08-12 03:15:23',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=119',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971599:172\\",\\"element_id\\":\\"6ck5166\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"03k0222\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"stom145\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"4k3p562\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"7yyn616\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"jdp5570\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"q0le160\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"8nm4106\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"s6z1005\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"x2kz120\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dksv003\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ao9k343\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"uubk030\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"1kmz506\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"64mq831\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"ari6100\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"84t3410\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8wzf004\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f4vk040\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8nbd141\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"q4om450\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hkxz115\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"sdmj507\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"vl08140\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"yh76101\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qous550\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"cylb651\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"ievi500\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"\\",\\"element_id\\":\\"ou53655\\"},\\"_thumbnail_id\\":{\\"0\\":\\"213\\",\\"element_id\\":\\"zaoz601\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/macbook-748857.jpg\\",\\"element_id\\":\\"3x8x116\\"}}',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web-design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/macbook-748857.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 183,
  'post_date' => '2016-08-03 06:45:35',
  'post_date_gmt' => '2016-08-03 06:45:35',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit.

Sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Date APP',
  'post_excerpt' => 'App Experience Design
',
  'post_name' => 'date-app',
  'post_modified' => '2016-08-16 00:32:02',
  'post_modified_gmt' => '2016-08-16 00:32:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=183',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471307442:72\\",\\"element_id\\":\\"sald409\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"dldd004\\"},\\"_thumbnail_id\\":{\\"0\\":\\"185\\",\\"element_id\\":\\"pcf0400\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/imac-605421_1920.jpg\\",\\"element_id\\":\\"aoci466\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"mohj000\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"d2sx494\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"u5c2470\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"72b2029\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"djw2944\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"wczf444\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"j27v090\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"j4ga904\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pzx2079\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"niig907\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"ckdq094\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"gt85041\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"idlh409\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"mr4j303\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f03i044\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"6j3e000\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"64pi090\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ue30090\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"p7wg840\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hxt1400\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"nuju091\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"725o940\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"17wu003\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"69jj400\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"desa004\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"r7ag947\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"7\\",\\"element_id\\":\\"b0xv444\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding, ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/imac-605421_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 131,
  'post_date' => '2016-08-02 06:55:36',
  'post_date_gmt' => '2016-08-02 06:55:36',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.',
  'post_title' => 'Ruben Sanchez',
  'post_excerpt' => 'Web Development',
  'post_name' => 'ruben-sanchez',
  'post_modified' => '2016-08-16 00:31:08',
  'post_modified_gmt' => '2016-08-16 00:31:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=131',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309716:72\\",\\"element_id\\":\\"d8kv404\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"xa5i809\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zx0m904\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"89x9558\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"rzqg489\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"i778600\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"0tq8998\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"ayc4092\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tnjv360\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0nbc339\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ve80396\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f235899\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"fhn0849\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"6d6y436\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"549r390\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"agf0147\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"9suv888\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"8xy2830\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ip5v440\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"iuh6730\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"nwga894\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ybke874\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"yl8m840\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"841e030\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"utnk980\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4xij804\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"n5nt220\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"50d8033\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"8\\",\\"element_id\\":\\"ce9q099\\"},\\"_thumbnail_id\\":{\\"0\\":\\"208\\",\\"element_id\\":\\"ba87035\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/twitter-1522890_1920.jpg\\",\\"element_id\\":\\"dbd9830\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web-design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/twitter-1522890_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 178,
  'post_date' => '2016-07-30 06:37:54',
  'post_date_gmt' => '2016-07-30 06:37:54',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptate. Omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.

Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'Johansson Eric',
  'post_excerpt' => 'Web Design',
  'post_name' => 'johansson-eric',
  'post_modified' => '2016-08-12 03:16:54',
  'post_modified_gmt' => '2016-08-12 03:16:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=178',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971812:172\\",\\"element_id\\":\\"zl5v001\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"yyyd012\\"},\\"_thumbnail_id\\":{\\"0\\":\\"179\\",\\"element_id\\":\\"caeh447\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/laptop-1209008_1280.jpg\\",\\"element_id\\":\\"vozy951\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"12fl917\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"jbee977\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"4ds6077\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"83xa087\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"j6sw077\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"qost281\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3gfb717\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zai1000\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f4i3617\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2luw717\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"00jw000\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"v9g8700\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"r49o700\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"anz3011\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"n17h810\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4wng113\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"yklp718\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"xtt2707\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"594z110\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0h3j081\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"26xo077\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"b3v4718\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"cxfy700\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3ccy020\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"butq737\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"6vhy727\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"9\\",\\"element_id\\":\\"w8qo052\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding, web-design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/laptop-1209008_1280.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 133,
  'post_date' => '2016-07-29 06:54:55',
  'post_date_gmt' => '2016-07-29 06:54:55',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'HAUS',
  'post_excerpt' => 'Digital, Identity',
  'post_name' => 'haus',
  'post_modified' => '2016-08-16 00:31:26',
  'post_modified_gmt' => '2016-08-16 00:31:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=133',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309860:72\\",\\"element_id\\":\\"x20i110\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"vc28940\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0u65997\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"9w71490\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"p5lx040\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"ib8k303\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"42v1475\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"7q4z057\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1dsg000\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"sfos606\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zl0f040\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"mhjy770\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"8guv098\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"wv2b706\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1dsm179\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"vjsw340\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5j22740\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"07gt974\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5j73970\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"krqg228\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vr57080\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"holb807\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"pyy4339\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"pv6v707\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"htck390\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"sbx7394\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"bhhs040\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"ofxn909\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"8\\",\\"element_id\\":\\"3col077\\"},\\"_thumbnail_id\\":{\\"0\\":\\"209\\",\\"element_id\\":\\"w0tz295\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/macbook-624707_1920.jpg\\",\\"element_id\\":\\"8zs7370\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web-design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/macbook-624707_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 176,
  'post_date' => '2016-07-29 06:27:45',
  'post_date_gmt' => '2016-07-29 06:27:45',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Genio',
  'post_excerpt' => 'Product Branding',
  'post_name' => 'genio',
  'post_modified' => '2016-08-12 03:17:10',
  'post_modified_gmt' => '2016-08-12 03:17:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=176',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971957:172\\",\\"element_id\\":\\"u534550\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"c5co031\\"},\\"_thumbnail_id\\":{\\"0\\":\\"177\\",\\"element_id\\":\\"kyo9550\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/photo-1416339306562-f3d12fefd36f.jpg\\",\\"element_id\\":\\"wmdt164\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"j7ka561\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"1wkw111\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"2zfx046\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"kdk4406\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"gc9o006\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"45rg400\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"xu10606\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"d12s166\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"w0k5040\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"jucw480\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"d6me664\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"qdf7006\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dhj3040\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"fwlt404\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ic0m606\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e8mc000\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"1geo607\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"wsqy000\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"meoc104\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"78i0820\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"syzm800\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"1l5j104\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"tv7i550\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"uf0d147\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"7saw800\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"672p140\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"9\\",\\"element_id\\":\\"bb6z600\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/photo-1416339306562-f3d12fefd36f.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 172,
  'post_date' => '2016-07-29 06:19:52',
  'post_date_gmt' => '2016-07-29 06:19:52',
  'post_content' => 'Similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum at vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'Weather APP',
  'post_excerpt' => 'App Experience Design
',
  'post_name' => 'weather-app',
  'post_modified' => '2016-08-12 03:17:58',
  'post_modified_gmt' => '2016-08-12 03:17:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=172',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971959:172\\",\\"element_id\\":\\"3ljf800\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"jrpp050\\"},\\"_thumbnail_id\\":{\\"0\\":\\"173\\",\\"element_id\\":\\"4cxu635\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/iphone-410324.jpg\\",\\"element_id\\":\\"4u4s220\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4rmo038\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"ewsc836\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"g1yd737\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"tvrg533\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"8tus866\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"vuo5380\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"url6522\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"13ix357\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lcn4733\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qukj053\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"bqre738\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"qkpi707\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ckrw883\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"35i2833\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c1qq338\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"lqsp883\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ffgd883\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"eslh883\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"exii883\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"pyfm833\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"ns3p531\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"qmmq353\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"80om353\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3mdq636\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"aoct305\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"f8mj508\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"7\\",\\"element_id\\":\\"1n1i300\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/iphone-410324.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 174,
  'post_date' => '2016-07-28 06:23:48',
  'post_date_gmt' => '2016-07-28 06:23:48',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'FFI Landing',
  'post_excerpt' => 'Web Design
',
  'post_name' => 'ffi-landing',
  'post_modified' => '2016-08-12 03:17:48',
  'post_modified_gmt' => '2016-08-12 03:17:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=174',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971958:172\\",\\"element_id\\":\\"5go2051\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"iw1l111\\"},\\"_thumbnail_id\\":{\\"0\\":\\"175\\",\\"element_id\\":\\"nfdd065\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/office-605503_1920.jpg\\",\\"element_id\\":\\"gzfs010\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qbbf016\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"wdk0602\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"0bux207\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"gjoe586\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"4u8k060\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"jzg9071\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"28ny512\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"i0oe351\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"g9zf571\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4d8v620\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"n6tt507\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"b7fo207\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"y0wo017\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"401p508\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"m6on012\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"bjmm508\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"l94w510\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"645a081\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"2yjm215\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"z95d011\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"d5rh828\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"ohm3121\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"3ndc150\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"n7bt529\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"fyrn212\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"vr00192\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"8\\",\\"element_id\\":\\"zk7g911\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web-design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/office-605503_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 170,
  'post_date' => '2016-07-27 06:14:49',
  'post_date_gmt' => '2016-07-27 06:14:49',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum neque porro quisquam est.

Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_title' => 'Art of Digital',
  'post_excerpt' => 'Digital, Identity
',
  'post_name' => 'art-of-digital',
  'post_modified' => '2016-08-12 03:18:11',
  'post_modified_gmt' => '2016-08-12 03:18:11',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=170',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971959:172\\",\\"element_id\\":\\"uyfq727\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"ab1u030\\"},\\"_thumbnail_id\\":{\\"0\\":\\"171\\",\\"element_id\\":\\"5pv9300\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/macbook-926425_1920.jpg\\",\\"element_id\\":\\"rei8080\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c839009\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"bc4b800\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"jo3w700\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"jvc3070\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"oepo077\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"rox3027\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"x48m807\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"vv1k404\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"oxxm220\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"j8xf004\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"3gjj407\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"gmv3000\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"a0gz251\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"l8sf702\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"4zz0404\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"qqnz205\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"m5a3068\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"zppz520\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"reir857\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"w9z7900\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"f9ih268\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"7z8q263\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"spn9006\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c470807\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5iy0660\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"zyub260\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"9\\",\\"element_id\\":\\"zmlt066\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/macbook-926425_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 168,
  'post_date' => '2016-07-26 06:11:29',
  'post_date_gmt' => '2016-07-26 06:11:29',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'XMOL',
  'post_excerpt' => 'APP Software',
  'post_name' => 'xmol',
  'post_modified' => '2016-08-12 03:18:21',
  'post_modified_gmt' => '2016-08-12 03:18:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=168',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/pen-926313_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 166,
  'post_date' => '2016-07-24 06:09:27',
  'post_date_gmt' => '2016-07-24 06:09:27',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Nemo enim ipsam voluptatem expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_title' => 'Business Plan',
  'post_excerpt' => 'App Experience Design
',
  'post_name' => 'business-plan',
  'post_modified' => '2016-08-12 03:18:37',
  'post_modified_gmt' => '2016-08-12 03:18:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=166',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/office-620817_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 164,
  'post_date' => '2016-07-20 06:05:36',
  'post_date_gmt' => '2016-07-20 06:05:36',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'The Firm',
  'post_excerpt' => 'Web Design
',
  'post_name' => 'the-firm',
  'post_modified' => '2016-08-12 03:18:46',
  'post_modified_gmt' => '2016-08-12 03:18:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=164',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1470971816:172\\",\\"element_id\\":\\"45jw999\\"},\\"_edit_last\\":{\\"0\\":\\"172\\",\\"element_id\\":\\"ojgv289\\"},\\"_thumbnail_id\\":{\\"0\\":\\"165\\",\\"element_id\\":\\"sdpd616\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/ipad-605420_1920.jpg\\",\\"element_id\\":\\"xoq6668\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"79be979\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"swtf680\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"yy5r990\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"57ld100\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"0nrk202\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"rzkb161\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"hwwp610\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"74ub666\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"q5z9901\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"rjed006\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"ayb9099\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"6yt1060\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"q8jw006\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"qb7z620\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"b16q490\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"e2xm090\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ekur002\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"dhjw766\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"b7qu906\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"et72699\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"uj84000\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"pl7i060\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"u7mp006\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"68su060\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"f57m505\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"2eze066\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"8\\",\\"element_id\\":\\"3kk5067\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'web-design',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/ipad-605420_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 121,
  'post_date' => '2016-06-04 06:52:39',
  'post_date_gmt' => '2016-06-04 06:52:39',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'Exoskills',
  'post_excerpt' => 'App Coding',
  'post_name' => 'exoskills',
  'post_modified' => '2016-08-16 00:31:48',
  'post_modified_gmt' => '2016-08-16 00:31:48',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=121',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '{\\"_edit_lock\\":{\\"0\\":\\"1471309714:72\\",\\"element_id\\":\\"6pz7000\\"},\\"_edit_last\\":{\\"0\\":\\"72\\",\\"element_id\\":\\"1rpe016\\"},\\"layout\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ewju107\\"},\\"content_width\\":{\\"0\\":\\"default_width\\",\\"element_id\\":\\"uprf310\\"},\\"feature_size\\":{\\"0\\":\\"blank\\",\\"element_id\\":\\"tkdu127\\"},\\"imagefilter_options\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"6jhm137\\"},\\"imagefilter_options_hover\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"3eu1031\\"},\\"imagefilter_applyto\\":{\\"0\\":\\"initial\\",\\"element_id\\":\\"9s8b713\\"},\\"hide_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"t94x177\\"},\\"unlink_post_title\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"ujbw193\\"},\\"hide_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"bs88005\\"},\\"unlink_post_image\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"mal9110\\"},\\"body_background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"thm0707\\"},\\"color_scheme_mode\\":{\\"0\\":\\"color-presets\\",\\"element_id\\":\\"i8p8000\\"},\\"color_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"49aq979\\"},\\"typography_mode\\":{\\"0\\":\\"typography-presets\\",\\"element_id\\":\\"s6r7000\\"},\\"font_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"tn91101\\"},\\"body_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"awoi330\\"},\\"heading_font\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"kf1x340\\"},\\"header_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0xjq783\\"},\\"fixed_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"0w7k763\\"},\\"full_height_header\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"5k2t070\\"},\\"header_wrap\\":{\\"0\\":\\"solid\\",\\"element_id\\":\\"50hp880\\"},\\"background_mode\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"zfrj038\\"},\\"background_repeat\\":{\\"0\\":\\"fullcover\\",\\"element_id\\":\\"r9qy070\\"},\\"footer_design\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"c6er007\\"},\\"hide_post_meta\\":{\\"0\\":\\"default\\",\\"element_id\\":\\"3kma151\\"},\\"builder_switch_frontend\\":{\\"0\\":\\"0\\",\\"element_id\\":\\"q9h6130\\"},\\"_yoast_wpseo_primary_portfolio-category\\":{\\"0\\":\\"\\",\\"element_id\\":\\"aoei707\\"},\\"_thumbnail_id\\":{\\"0\\":\\"215\\",\\"element_id\\":\\"m100380\\"},\\"post_image\\":{\\"0\\":\\"https://themify.me/demo/themes/ultra-agency\\\\/files\\\\/2016\\\\/08\\\\/startup-593322_1920.jpg\\",\\"element_id\\":\\"4fbb180\\"}}',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'branding, ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/startup-593322_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 135,
  'post_date' => '2015-10-08 06:56:49',
  'post_date_gmt' => '2015-10-08 06:56:49',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'DDNG',
  'post_excerpt' => 'App Development',
  'post_name' => 'ddng',
  'post_modified' => '2016-08-16 00:28:00',
  'post_modified_gmt' => '2016-08-16 00:28:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=135',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/iphone-926118_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 129,
  'post_date' => '2015-07-02 06:53:47',
  'post_date_gmt' => '2015-07-02 06:53:47',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Shiftbrain',
  'post_excerpt' => 'Web Design',
  'post_name' => 'shiftbrain',
  'post_modified' => '2016-08-16 00:29:34',
  'post_modified_gmt' => '2016-08-16 00:29:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?post_type=portfolio&#038;p=129',
  'menu_order' => 0,
  'post_type' => 'portfolio',
  'meta_input' => 
  array (
    'layout' => 'default',
    'content_width' => 'default_width',
    'feature_size' => 'blank',
    'hide_post_title' => 'default',
    'unlink_post_title' => 'default',
    'hide_post_meta' => 'default',
    'hide_post_image' => 'default',
    'unlink_post_image' => 'default',
    'body_background_repeat' => 'fullcover',
    'color_scheme_mode' => 'color-presets',
    'color_design' => 'default',
    'typography_mode' => 'typography-presets',
    'font_design' => 'default',
    'body_font' => 'default',
    'heading_font' => 'default',
    'header_design' => 'default',
    'fixed_header' => 'default',
    'full_height_header' => 'default',
    'header_wrap' => 'solid',
    'background_mode' => 'fullcover',
    'background_repeat' => 'fullcover',
    'footer_design' => 'default',
    'imagefilter_options' => 'initial',
    'imagefilter_options_hover' => 'initial',
    'imagefilter_applyto' => 'initial',
    'builder_switch_frontend' => '0',
  ),
  'tax_input' => 
  array (
    'portfolio-category' => 'ux-ui',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-agency/files/2016/08/coding-699318_1920.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 53,
  'post_date' => '2016-08-04 13:02:01',
  'post_date_gmt' => '2016-08-04 13:02:01',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2016-08-04 13:02:01',
  'post_modified_gmt' => '2016-08-04 13:02:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=53',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-nav',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 54,
  'post_date' => '2016-08-04 13:02:01',
  'post_date_gmt' => '2016-08-04 13:02:01',
  'post_content' => '',
  'post_title' => 'Terms',
  'post_excerpt' => '',
  'post_name' => 'terms',
  'post_modified' => '2016-08-04 13:02:01',
  'post_modified_gmt' => '2016-08-04 13:02:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=54',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '54',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-nav',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 55,
  'post_date' => '2016-08-04 13:02:01',
  'post_date_gmt' => '2016-08-04 13:02:01',
  'post_content' => '',
  'post_title' => 'Privacy',
  'post_excerpt' => '',
  'post_name' => 'privacy',
  'post_modified' => '2016-08-04 13:02:01',
  'post_modified_gmt' => '2016-08-04 13:02:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=55',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '55',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-nav',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 56,
  'post_date' => '2016-08-04 13:02:01',
  'post_date_gmt' => '2016-08-04 13:02:01',
  'post_content' => '',
  'post_title' => 'FAQ',
  'post_excerpt' => '',
  'post_name' => 'faq',
  'post_modified' => '2016-08-04 13:02:01',
  'post_modified_gmt' => '2016-08-04 13:02:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=56',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '56',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-nav',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 303,
  'post_date' => '2016-08-11 08:16:22',
  'post_date_gmt' => '2016-08-11 08:16:22',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '303',
  'post_modified' => '2016-08-13 07:45:47',
  'post_modified_gmt' => '2016-08-13 07:45:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=303',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '18',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 319,
  'post_date' => '2016-08-12 04:20:26',
  'post_date_gmt' => '2016-08-12 04:20:26',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '319',
  'post_modified' => '2016-08-13 07:45:47',
  'post_modified_gmt' => '2016-08-13 07:45:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=319',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '317',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 306,
  'post_date' => '2016-08-11 08:16:22',
  'post_date_gmt' => '2016-08-11 08:16:22',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '306',
  'post_modified' => '2016-08-13 07:45:47',
  'post_modified_gmt' => '2016-08-13 07:45:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=306',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '108',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 304,
  'post_date' => '2016-08-11 08:16:22',
  'post_date_gmt' => '2016-08-11 08:16:22',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '304',
  'post_modified' => '2016-08-13 07:45:47',
  'post_modified_gmt' => '2016-08-13 07:45:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=304',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 305,
  'post_date' => '2016-08-11 08:16:22',
  'post_date_gmt' => '2016-08-11 08:16:22',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '305',
  'post_modified' => '2016-08-13 07:45:47',
  'post_modified_gmt' => '2016-08-13 07:45:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-agency/?p=305',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '15',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => 'highlight-link',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-menu',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_recent-posts" );
$widgets[1002] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1003] = array (
  'title' => 'Recent Posts',
  'category' => '0',
  'show_count' => '3',
  'show_date' => 'on',
  'show_thumb' => 'on',
  'display' => 'none',
  'hide_title' => NULL,
  'thumb_width' => '50',
  'thumb_height' => '50',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1004] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'show_count' => '3',
  'hide_timestamp' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1005] = array (
  'title' => 'Contact us',
  'text' => '<p>We are here to answer any question you may have about our Agency. 
We will respond as soon as we can.</p>
 [themify_button link="https://themify.me/demo/themes/ultra-agency/contact/" style="small blue outline" text="#23c3d1"]Contact us[/themify_button]',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1006] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1007] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );



$sidebars_widgets = array (
  'wp_inactive_widgets' => 
  array (
    0 => 'recent-posts-1002',
  ),
  'sidebar-main' => 
  array (
    0 => 'themify-feature-posts-1003',
    1 => 'themify-twitter-1004',
    2 => 'text-1005',
  ),
  'social-widget' => 
  array (
    0 => 'themify-social-links-1006',
  ),
  'footer-social-widget' => 
  array (
    0 => 'themify-social-links-1007',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			$themify_data = array (
  'setting-webfonts_list' => 'recommended',
  'setting-default_layout' => 'sidebar1',
  'setting-default_post_layout' => 'list-post',
  'setting-post_filter' => 'yes',
  'setting-disable_masonry' => 'yes',
  'setting-post_gutter' => 'gutter',
  'setting-default_layout_display' => 'content',
  'setting-default_more_text' => 'More',
  'setting-index_orderby' => 'date',
  'setting-index_order' => 'DESC',
  'setting-default_media_position' => 'above',
  'setting-image_post_feature_size' => 'blank',
  'setting-default_page_post_layout' => 'sidebar1',
  'setting-default_page_post_layout_type' => 'classic',
  'setting-default_page_single_media_position' => 'above',
  'setting-image_post_single_feature_size' => 'blank',
  'setting-search-result_layout_display' => 'content',
  'setting-search-result_media_position' => 'above',
  'setting-default_page_layout' => 'sidebar1',
  'setting-custom_post_tglobal_style_single' => 'sidebar1',
  'setting-default_portfolio_index_layout' => 'sidebar-none',
  'setting-default_portfolio_index_post_layout' => 'grid3',
  'setting-portfolio_post_filter' => 'yes',
  'setting-portfolio_disable_masonry' => 'yes',
  'setting-portfolio_gutter' => 'gutter',
  'setting-default_portfolio_index_display' => 'content',
  'setting-default_portfolio_index_title' => ' ',
  'setting-default_portfolio_index_unlink_post_title' => ' ',
  'setting-default_portfolio_index_hide_post_date' => ' ',
  'setting-default_portfolio_index_post_meta_category' => 'yes',
  'setting-default_portfolio_index_unlink_post_image' => 'yes',
  'setting-default_portfolio_single_layout' => 'sidebar-none',
  'setting-default_portfolio_single_portfolio_layout_type' => 'fullwidth',
  'setting-default_portfolio_single_title' => ' ',
  'setting-default_portfolio_single_unlink_post_title' => ' ',
  'setting-default_portfolio_single_hide_post_date' => ' ',
  'setting-default_portfolio_single_post_meta_category' => ' ',
  'setting-default_portfolio_single_unlink_post_image' => 'yes',
  'themify_portfolio_slug' => 'project',
  'themify_portfolio_category_slug' => 'portfolio-category',
  'setting-customizer_responsive_design_tablet_landscape' => '1024',
  'setting-customizer_responsive_design_tablet' => '768',
  'setting-customizer_responsive_design_mobile' => '480',
  'setting-mobile_menu_trigger_point' => '1200',
  'setting-gallery_lightbox' => 'lightbox',
  'setting-header_design' => 'header-horizontal',
  'setting-exclude_search_form' => 'on',
  'setting_search_form' => 'live_search',
  'setting-exclude_rss' => 'on',
  'setting-header_widgets' => 'none',
  'setting-footer_design' => 'footer-horizontal-left',
  'setting-use_float_back' => 'on',
  'setting-footer_widgets' => 'none',
  'setting-mega_menu_posts' => '5',
  'setting-mega_menu_image_width' => '180',
  'setting-mega_menu_image_height' => '120',
  'setting-mega_menu_post_count' => 'off',
  'setting-imagefilter_applyto' => 'featuredonly',
  'setting-color_animation_speed' => '5',
  'setting-relationship_taxonomy' => 'category',
  'setting-relationship_taxonomy_entries' => '3',
  'setting-relationship_taxonomy_display_content' => 'none',
  'setting-single_slider_autoplay' => 'off',
  'setting-single_slider_speed' => 'normal',
  'setting-single_slider_effect' => 'slide',
  'setting-single_slider_height' => 'auto',
  'setting-more_posts' => 'infinite',
  'setting-entries_nav' => 'numbered',
  'setting-img_php_base_size' => 'large',
  'setting-global_feature_size' => 'blank',
  'setting-link_icon_type' => 'font-icon',
  'setting-link_type_themify-link-0' => 'image-icon',
  'setting-link_title_themify-link-0' => 'Twitter',
  'setting-link_img_themify-link-0' => 'https://themify.me/demo/themes/ultra-agency/wp-content/themes/themify-ultra/themify/img/social/twitter.png',
  'setting-link_type_themify-link-1' => 'image-icon',
  'setting-link_title_themify-link-1' => 'Facebook',
  'setting-link_img_themify-link-1' => 'https://themify.me/demo/themes/ultra-agency/wp-content/themes/themify-ultra/themify/img/social/facebook.png',
  'setting-link_type_themify-link-2' => 'image-icon',
  'setting-link_title_themify-link-2' => 'Google+',
  'setting-link_img_themify-link-2' => 'https://themify.me/demo/themes/ultra-agency/wp-content/themes/themify-ultra/themify/img/social/google-plus.png',
  'setting-link_type_themify-link-3' => 'image-icon',
  'setting-link_title_themify-link-3' => 'YouTube',
  'setting-link_img_themify-link-3' => 'https://themify.me/demo/themes/ultra-agency/wp-content/themes/themify-ultra/themify/img/social/youtube.png',
  'setting-link_type_themify-link-4' => 'image-icon',
  'setting-link_title_themify-link-4' => 'Pinterest',
  'setting-link_img_themify-link-4' => 'https://themify.me/demo/themes/ultra-agency/wp-content/themes/themify-ultra/themify/img/social/pinterest.png',
  'setting-link_type_themify-link-5' => 'font-icon',
  'setting-link_title_themify-link-5' => 'Twitter',
  'setting-link_link_themify-link-5' => 'https://themify.me/',
  'setting-link_ficon_themify-link-5' => 'fa-twitter',
  'setting-link_type_themify-link-7' => 'font-icon',
  'setting-link_title_themify-link-7' => 'Google+',
  'setting-link_link_themify-link-7' => 'https://themify.me/',
  'setting-link_ficon_themify-link-7' => 'fa-google-plus',
  'setting-link_type_themify-link-6' => 'font-icon',
  'setting-link_title_themify-link-6' => 'Facebook',
  'setting-link_link_themify-link-6' => 'https://themify.me/',
  'setting-link_ficon_themify-link-6' => 'fa-facebook',
  'setting-link_type_themify-link-8' => 'font-icon',
  'setting-link_title_themify-link-8' => 'YouTube',
  'setting-link_ficon_themify-link-8' => 'fa-youtube',
  'setting-link_type_themify-link-9' => 'font-icon',
  'setting-link_title_themify-link-9' => 'Pinterest',
  'setting-link_ficon_themify-link-9' => 'fa-pinterest',
  'setting-link_field_ids' => '{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-7":"themify-link-7","themify-link-6":"themify-link-6","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}',
  'setting-link_field_hash' => '10',
  'setting-page_builder_is_active' => 'enable',
  'setting-page_builder_animation_appearance' => 'none',
  'setting-page_builder_animation_parallax_bg' => 'none',
  'setting-page_builder_animation_scroll_effect' => 'none',
  'setting-page_builder_animation_sticky_scroll' => 'none',
  'setting-page_builder_cache' => 'on',
  'setting-page_builder_expiry' => '2',
  'skin' => 'agency',
  'import_images' => 'on',
);
themify_set_data( $themify_data );
$theme = get_option( 'stylesheet' );
$theme_mods = array (
  0 => false,
  'site-logo_image' => '{"stamp":1470255590584,"mode":"image","id":35,"src":"https://themify.me/demo/themes/ultra-agency/files/2016/08/logo.png"}',
  'site-tagline' => '{"stamp":1470257110001,"mode":"none"}',
  'custom_css_post_id' => -1,
);
update_option( "theme_mods_{$theme}", $theme_mods );
$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "footer-nav" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["footer-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "main-menu" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );



}
themify_do_demo_import();