<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if ( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;

		$post = array();

		$upload = wp_upload_bits( 'themify-placeholder.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post = array(
				'post_mime_type' => $info['type']
			);
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$placeholder_image = wp_insert_attachment( $post, $upload['file'] );
		require_once( ABSPATH . 'wp-admin/includes/image.php' );
		wp_update_attachment_metadata( $placeholder_image, wp_generate_attachment_metadata( $placeholder_image, $upload['file'] ) );
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) || ! isset( $processed_terms[ intval( $term['parent'] ) ] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if ( ! empty( $placeholder ) && ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 1,
  'name' => 'Uncategorized',
  'slug' => 'uncategorized',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Header Menu',
  'slug' => 'header-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Footer Menu',
  'slug' => 'footer-menu',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 6502,
  'post_date' => '2017-05-22 12:33:25',
  'post_date_gmt' => '2017-05-22 12:33:25',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias at vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.

quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus.',
  'post_title' => '7 Tips to Become a Successful Accountant',
  'post_excerpt' => '',
  'post_name' => '7-tips-become-successful-accountant',
  'post_modified' => '2017-06-05 15:42:17',
  'post_modified_gmt' => '2017-06-05 15:42:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6502',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/financial-growth.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6493,
  'post_date' => '2017-05-18 15:06:20',
  'post_date_gmt' => '2017-05-18 15:06:20',
  'post_content' => '<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>
<p>inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.</p>

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Five Year Record Evaluation',
  'post_excerpt' => '',
  'post_name' => 'five-year-record-evaluation',
  'post_modified' => '2019-07-24 03:23:06',
  'post_modified_gmt' => '2019-07-24 03:23:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6493',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/profit-chart.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6490,
  'post_date' => '2017-05-17 14:56:32',
  'post_date_gmt' => '2017-05-17 14:56:32',
  'post_content' => 'Ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit ess. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.',
  'post_title' => 'How to  Improving Teamwork',
  'post_excerpt' => '',
  'post_name' => 'improving-teamwork',
  'post_modified' => '2017-08-04 03:33:31',
  'post_modified_gmt' => '2017-08-04 03:33:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6490',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/team-discussion.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6483,
  'post_date' => '2017-05-15 15:34:02',
  'post_date_gmt' => '2017-05-15 15:34:02',
  'post_content' => 'Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus.  Ton provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.

<span id="more-133"></span>Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.',
  'post_title' => 'Leading The Way To Financial Success',
  'post_excerpt' => '',
  'post_name' => 'leading-way-financial-success',
  'post_modified' => '2017-06-05 15:46:57',
  'post_modified_gmt' => '2017-06-05 15:46:57',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6483',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/investment-direction.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6505,
  'post_date' => '2017-05-14 14:42:37',
  'post_date_gmt' => '2017-05-14 14:42:37',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est. Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.

Commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.

Perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.',
  'post_title' => 'Financial Management With Accountant',
  'post_excerpt' => '',
  'post_name' => 'financial-management-with-accountant',
  'post_modified' => '2017-08-04 03:34:20',
  'post_modified_gmt' => '2017-08-04 03:34:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6505',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/accountant-desk.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6486,
  'post_date' => '2017-05-13 18:36:34',
  'post_date_gmt' => '2017-05-13 18:36:34',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Et quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus omnis.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => '5 Tips for Effectively Managing Teams',
  'post_excerpt' => '',
  'post_name' => '5-tips-effectively-managing-teams',
  'post_modified' => '2017-06-05 15:47:09',
  'post_modified_gmt' => '2017-06-05 15:47:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6486',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/teamwork-success.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6479,
  'post_date' => '2017-05-11 16:26:22',
  'post_date_gmt' => '2017-05-11 16:26:22',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.',
  'post_title' => 'Accountant Skills Through Digital Learning',
  'post_excerpt' => '',
  'post_name' => 'accountant-skills-digital-learning',
  'post_modified' => '2017-08-04 03:35:16',
  'post_modified_gmt' => '2017-08-04 03:35:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6479',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/digital-learning.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6498,
  'post_date' => '2017-05-10 15:20:10',
  'post_date_gmt' => '2017-05-10 15:20:10',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Tips for Success in Accounting and Finance',
  'post_excerpt' => '',
  'post_name' => 'tips-success-accounting-finance',
  'post_modified' => '2017-08-04 03:35:01',
  'post_modified_gmt' => '2017-08-04 03:35:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6498',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/the-accountant.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6476,
  'post_date' => '2017-05-09 13:20:33',
  'post_date_gmt' => '2017-05-09 13:20:33',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?” repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Tasks Management For Company Accountant',
  'post_excerpt' => '',
  'post_name' => 'tasks-management-company-accountant',
  'post_modified' => '2017-06-04 16:23:18',
  'post_modified_gmt' => '2017-06-04 16:23:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6476',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/accountant.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6473,
  'post_date' => '2017-05-08 12:18:20',
  'post_date_gmt' => '2017-05-08 12:18:20',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

Inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => '5 Tips To Avoid Failure In Accounting',
  'post_excerpt' => '',
  'post_name' => '5-tips-avoid-failure-accounting',
  'post_modified' => '2017-06-04 16:20:01',
  'post_modified_gmt' => '2017-06-04 16:20:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6473',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/avoid-failure.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6470,
  'post_date' => '2017-05-07 15:14:34',
  'post_date_gmt' => '2017-05-07 15:14:34',
  'post_content' => 'Ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

Laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit ess. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam.',
  'post_title' => 'Investing Small In The Big Market',
  'post_excerpt' => '',
  'post_name' => 'investing-small-big-market',
  'post_modified' => '2017-06-04 16:17:47',
  'post_modified_gmt' => '2017-06-04 16:17:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6470',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/small-investment.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6466,
  'post_date' => '2017-05-06 17:10:54',
  'post_date_gmt' => '2017-05-06 17:10:54',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<span id="more-5716"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Accounting Process and Economic Knowledge',
  'post_excerpt' => '',
  'post_name' => 'accounting-process-economic-knowledge',
  'post_modified' => '2017-06-04 16:31:10',
  'post_modified_gmt' => '2017-06-04 16:31:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6466',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/market-calculation.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6462,
  'post_date' => '2017-05-05 11:00:18',
  'post_date_gmt' => '2017-05-05 11:00:18',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Simple Step To Get Maximum Target',
  'post_excerpt' => '',
  'post_name' => 'simple-step-get-maximum-target',
  'post_modified' => '2017-06-04 16:03:21',
  'post_modified_gmt' => '2017-06-04 16:03:21',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6462',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/company-target-discussion.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6459,
  'post_date' => '2017-05-03 16:54:08',
  'post_date_gmt' => '2017-05-03 16:54:08',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => '3 Main Elements for Audit Success',
  'post_excerpt' => '',
  'post_name' => '3-main-elements-audit-success',
  'post_modified' => '2017-06-04 16:00:01',
  'post_modified_gmt' => '2017-06-04 16:00:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6459',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/audit-succes.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6456,
  'post_date' => '2017-05-01 15:50:02',
  'post_date_gmt' => '2017-05-01 15:50:02',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => '4 Ways to Improve Workforce Diversity',
  'post_excerpt' => '',
  'post_name' => '4-ways-improve-workforce-diversity',
  'post_modified' => '2017-06-04 15:53:49',
  'post_modified_gmt' => '2017-06-04 15:53:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6456',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
    'category' => 'uncategorized',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-accountant/files/2017/06/working-together-in-harmony.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6376,
  'post_date' => '2017-03-23 11:13:10',
  'post_date_gmt' => '2017-03-23 11:13:10',
  'post_content' => '<!--themify_builder_static--><h1>About Us<br/>Who We Are</h1>
<p>Accounting is a premier accounting firm which provides taxation, accounting and bookkeeping services in the Greater Toronto Area.</p>
<p>We provide our clients with professional tax planning, e-file tax returns, book-keeping, accounting and business advisory services.</p>
<p>As a Registered Professional Accountant, we continue to have the honour and privilege of serving individuals and corporations since last 18 years. We pride ourselves on providing the highest level of customer service.</p><p>I place a great deal of emphasis on small businesses and sole-proprietorship and believe that by providing affordable quality accounting and tax services, it will help grow their business and prosper and in turn, help our local economy grow and prosper as well.</p>
<p>My personal goal and promise to you is to provide you a very high level of professional services and ensure you receive every dollar owed to you by Taxation Authorities.</p><p>My staff and I take away all the complexity and stress by employing fully advanced book-keeping and accounting system. Furthermore, by e-Filing your Tax Returns, you get the benefit of earlier refund giving you peace of mind and time to enjoy the things that you love most about your business.</p>
<ul data-id="tb_lvmm099" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="no" data-effect="cover-fade" data-height="variable" data-pause-on-hover="resume" data-horizontal="" > <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/jonathan-doe.png" alt="I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”." /> </figure> <h3>I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”.</h3> Jonathan Doe Director of Technical Support at Shopify </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-1.png" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio." /> </figure> <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio.</h3> Dennise King CEO Landmark Corporation </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-2.png" alt="Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur." /> </figure> <h3>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur.</h3> Robert Gill Vice President Wheel Spain Ltd </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-3.png" alt="Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae." /> </figure> <h3>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae.</h3> Juli Smith Manager County Road Association </li> </ul>
<h2>Our Team<br/>People together to celebrate an occasio</h2>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/chris-evans.jpg" title="Chris Evans" alt="CEO" srcset="https://themify.me/demo/themes/ultra-accountant/files/2017/03/chris-evans.jpg 480w, https://themify.me/demo/themes/ultra-accountant/files/2017/03/chris-evans-300x224.jpg 300w" sizes="(max-width: 480px) 100vw, 480px" /> <h3> Chris Evans </h3> CEO
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/jonathan-doe.jpg" title="Jonathan Doe" alt="Senior Accountant" srcset="https://themify.me/demo/themes/ultra-accountant/files/2017/03/jonathan-doe.jpg 480w, https://themify.me/demo/themes/ultra-accountant/files/2017/03/jonathan-doe-300x224.jpg 300w" sizes="(max-width: 480px) 100vw, 480px" /> <h3> Jonathan Doe </h3> Senior Accountant
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/marlene-jane.jpg" title="Marlene Jane" alt="Senior Analyst" srcset="https://themify.me/demo/themes/ultra-accountant/files/2017/03/marlene-jane.jpg 480w, https://themify.me/demo/themes/ultra-accountant/files/2017/03/marlene-jane-300x224.jpg 300w" sizes="(max-width: 480px) 100vw, 480px" /> <h3> Marlene Jane </h3> Senior Analyst
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/parlone-sabastian.jpg" title="Parlone Sabastian" alt="Business Analyst" srcset="https://themify.me/demo/themes/ultra-accountant/files/2017/03/parlone-sabastian.jpg 480w, https://themify.me/demo/themes/ultra-accountant/files/2017/03/parlone-sabastian-300x224.jpg 300w" sizes="(max-width: 480px) 100vw, 480px" /> <h3> Parlone Sabastian </h3> Business Analyst
<h1>Contact us Today and Receive a Free Tax Service.<br/>Let\'s talk about how we can help you</h1>
<a href="/contant-us" > Contact Us </a><!--/themify_builder_static-->',
  'post_title' => 'About Us',
  'post_excerpt' => '',
  'post_name' => 'about-us',
  'post_modified' => '2019-11-04 11:20:42',
  'post_modified_gmt' => '2019-11-04 11:20:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?page_id=6376',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"qpie943\\",\\"cols\\":[{\\"element_id\\":\\"9dmy990\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"1vng009\\",\\"mod_settings\\":{\\"heading\\":\\"About Us\\",\\"sub_heading\\":\\"Who We Are\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"main_margin_top_unit\\":\\"px\\",\\"main_margin_bottom_unit\\":\\"px\\",\\"font_size_subheading_unit\\":\\"px\\",\\"line_height_subheading_unit\\":\\"px\\",\\"sub_margin_top_unit\\":\\"px\\",\\"sub_margin_bottom_unit\\":\\"px\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bqt0695\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Accounting is a premier accounting firm which provides taxation, accounting and bookkeeping services in the Greater Toronto Area.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"h5_margin_top_unit\\":\\"px\\",\\"h5_margin_bottom_unit\\":\\"px\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"h6_margin_top_unit\\":\\"px\\",\\"h6_margin_bottom_unit\\":\\"px\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"column_divider_style\\":\\"solid\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"column_divider_style\\":\\"solid\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"30\\",\\"margin_left\\":\\"30\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"column_divider_style\\":\\"solid\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"40\\",\\"margin_left\\":\\"40\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"vertical-divider row-newsletter input-bg-white\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/about-us.jpg\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"21456b_0.78\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"14.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"q9tl951\\",\\"cols\\":[{\\"element_id\\":\\"kn74979\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"kb48000\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>We provide our clients with professional tax planning, e-file tax returns, book-keeping, accounting and business advisory services.<\\\\/p>\\",\\"add_css_text\\":\\"dropcap\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"text_drop_cap\\":\\"dropcap\\",\\"dropcap_margin_opp_left\\":false,\\"dropcap_margin_right\\":\\"10\\",\\"dropcap_margin_opp_top\\":false,\\"dropcap_padding_left\\":\\"0\\",\\"dropcap_padding_opp_left\\":false,\\"dropcap_padding_bottom\\":\\"2\\",\\"dropcap_padding_right\\":\\"0\\",\\"dropcap_padding_opp_top\\":false,\\"dropcap_padding_top\\":\\"12\\",\\"dropcap_font_size_unit\\":\\"em\\",\\"dropcap_font_size\\":\\"2.7\\",\\"dropcap_font_color\\":\\"#c4943a\\",\\"dropcap_background_color\\":\\"#000000_0.00\\",\\"font_style_regular\\":\\"normal\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.8\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_family_w\\":\\"900\\",\\"font_family\\":\\"Playfair Display\\"}}]},{\\"element_id\\":\\"madu050\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ygqz909\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>As a Registered Professional Accountant, we continue to have the honour and privilege of serving individuals and corporations since last 18 years. We pride ourselves on providing the highest level of customer service.<\\\\/p><p>I place a great deal of emphasis on small businesses and sole-proprietorship and believe that by providing affordable quality accounting and tax services, it will help grow their business and prosper and in turn, help our local economy grow and prosper as well.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"h5_margin_top_unit\\":\\"px\\",\\"h5_margin_bottom_unit\\":\\"px\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"h6_margin_top_unit\\":\\"px\\",\\"h6_margin_bottom_unit\\":\\"px\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]},{\\"element_id\\":\\"i1dq855\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"dz6r999\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>My personal goal and promise to you is to provide you a very high level of professional services and ensure you receive every dollar owed to you by Taxation Authorities.<\\\\/p><p>My staff and I take away all the complexity and stress by employing fully advanced book-keeping and accounting system. Furthermore, by e-Filing your Tax Returns, you get the benefit of earlier refund giving you peace of mind and time to enjoy the things that you love most about your business.<\\\\/p>\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_size_h1_unit\\":\\"px\\",\\"line_height_h1_unit\\":\\"px\\",\\"h1_margin_top_unit\\":\\"px\\",\\"h1_margin_bottom_unit\\":\\"px\\",\\"font_size_h2_unit\\":\\"px\\",\\"line_height_h2_unit\\":\\"px\\",\\"h2_margin_top_unit\\":\\"px\\",\\"h2_margin_bottom_unit\\":\\"px\\",\\"font_size_h3_unit\\":\\"px\\",\\"line_height_h3_unit\\":\\"px\\",\\"h3_margin_top_unit\\":\\"px\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_size_h4_unit\\":\\"px\\",\\"line_height_h4_unit\\":\\"px\\",\\"h4_margin_top_unit\\":\\"px\\",\\"h4_margin_bottom_unit\\":\\"px\\",\\"font_size_h5_unit\\":\\"px\\",\\"line_height_h5_unit\\":\\"px\\",\\"h5_margin_top_unit\\":\\"px\\",\\"h5_margin_bottom_unit\\":\\"px\\",\\"font_size_h6_unit\\":\\"px\\",\\"line_height_h6_unit\\":\\"px\\",\\"h6_margin_top_unit\\":\\"px\\",\\"h6_margin_bottom_unit\\":\\"px\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"padding_top\\":\\"11\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"aa5w900\\",\\"cols\\":[{\\"element_id\\":\\"ck8u100\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"lvmm099\\",\\"mod_settings\\":{\\"layout_testimonial\\":\\"image-top\\",\\"tab_content_testimonial\\":[{\\"title_testimonial\\":\\"I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/jonathan-doe.png\\",\\"person_name_testimonial\\":\\"Jonathan Doe\\",\\"person_position_testimonial\\":\\"Director of Technical Support at Shopify\\"},{\\"title_testimonial\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-1.png\\",\\"person_name_testimonial\\":\\"Dennise King\\",\\"person_position_testimonial\\":\\"CEO\\",\\"company_testimonial\\":\\"Landmark Corporation\\"},{\\"title_testimonial\\":\\"Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-2.png\\",\\"person_name_testimonial\\":\\"Robert Gill\\",\\"person_position_testimonial\\":\\"Vice President\\",\\"company_testimonial\\":\\"Wheel Spain Ltd\\"},{\\"title_testimonial\\":\\"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-3.png\\",\\"person_name_testimonial\\":\\"Juli Smith\\",\\"person_position_testimonial\\":\\"Manager\\",\\"company_testimonial\\":\\"County Road Association\\"}],\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"cover-fade\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_arrow_buttons_vertical\\":\\"vertical\\",\\"height_slider\\":\\"variable\\",\\"css_testimonial\\":\\"testimonials\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_content_unit\\":\\"px\\",\\"line_height_content_unit\\":\\"px\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"22436c_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"padding_top\\":\\"5.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"hqtm090\\",\\"cols\\":[{\\"element_id\\":\\"e7ds989\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"i7jj509\\",\\"mod_settings\\":{\\"heading\\":\\"Our Team\\",\\"sub_heading\\":\\"People together to celebrate an occasio\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"main_margin_top_unit\\":\\"px\\",\\"main_margin_bottom_unit\\":\\"px\\",\\"font_size_subheading_unit\\":\\"px\\",\\"line_height_subheading_unit\\":\\"px\\",\\"sub_margin_top_unit\\":\\"px\\",\\"sub_margin_bottom_unit\\":\\"px\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_type\\":\\"image\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"padding_top\\":\\"5.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"80\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"v7kx500\\",\\"cols\\":[{\\"element_id\\":\\"xt24595\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4k6m900\\",\\"mod_settings\\":{\\"style_image\\":\\"image-card-layout\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/chris-evans.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"title_image\\":\\"Chris Evans\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"CEO\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"image_zoom_icon\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false}}]},{\\"element_id\\":\\"i17u914\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8coe000\\",\\"mod_settings\\":{\\"style_image\\":\\"image-card-layout\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/jonathan-doe.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"title_image\\":\\"Jonathan Doe\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Senior Accountant\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"image_zoom_icon\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"left\\"}}}],\\"styling\\":{\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#dddddd\\",\\"border-type\\":\\"left\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"none\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#dddddd\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"left\\"}}},{\\"element_id\\":\\"4nxe171\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"x7ox058\\",\\"mod_settings\\":{\\"style_image\\":\\"image-card-layout\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/marlene-jane.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"title_image\\":\\"Marlene Jane\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Senior Analyst\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"image_zoom_icon\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false}}],\\"styling\\":{\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#dddddd\\",\\"border-type\\":\\"left\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#dddddd\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"none\\",\\"border-type\\":\\"all\\"}}},{\\"element_id\\":\\"w521050\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"eac0101\\",\\"mod_settings\\":{\\"style_image\\":\\"image-card-layout\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/parlone-sabastian.jpg\\",\\"auto_fullwidth\\":\\"1\\",\\"title_image\\":\\"Parlone Sabastian\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Business Analyst\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"image_zoom_icon\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false}}],\\"styling\\":{\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#dddddd\\",\\"border-type\\":\\"left\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#dddddd\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"none\\",\\"border-type\\":\\"all\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"tablet4-2\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"team-member\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"q862119\\",\\"cols\\":[{\\"element_id\\":\\"9lix510\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ueye041\\",\\"mod_settings\\":{\\"heading\\":\\"Contact us Today and Receive a Free Tax Service.\\",\\"sub_heading\\":\\"Let\\\'s talk about how we can help you\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"main_margin_top_unit\\":\\"px\\",\\"main_margin_bottom_unit\\":\\"px\\",\\"font_size_subheading\\":\\"1.1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"line_height_subheading_unit\\":\\"px\\",\\"sub_margin_top_unit\\":\\"px\\",\\"sub_margin_bottom_unit\\":\\"px\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_subheading_unit\\":\\"px\\",\\"line_height_subheading_unit\\":\\"px\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_subheading_unit\\":\\"px\\",\\"line_height_subheading_unit\\":\\"px\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"5awi110\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"squared\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"\\\\/contant-us\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"brown\\"}],\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top\\":\\"1.3\\",\\"margin_top_unit\\":\\"em\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"padding_top_link_unit\\":\\"px\\",\\"padding_right_link_unit\\":\\"px\\",\\"padding_bottom_link_unit\\":\\"px\\",\\"padding_left_link_unit\\":\\"px\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_margin_top_unit\\":\\"px\\",\\"link_margin_right_unit\\":\\"px\\",\\"link_margin_bottom_unit\\":\\"px\\",\\"link_margin_left_unit\\":\\"px\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_border_top_style\\":\\"solid\\",\\"link_border_right_style\\":\\"solid\\",\\"link_border_bottom_style\\":\\"solid\\",\\"link_border_left_style\\":\\"solid\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"about-team\\",\\"background_type\\":\\"image\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"f4f4f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6.15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6.85\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"50\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6385,
  'post_date' => '2017-03-23 11:37:39',
  'post_date_gmt' => '2017-03-23 11:37:39',
  'post_content' => '<!--themify_builder_static--><h1>Let\'s get in Touch<br/>Contact Us</h1>
<p>Email, call, or even visit our office, we\'d love to help you grow your business</p>

<p>(818)657-7220</p>

<p>6320 Canoga, 1430 Woodland Hills, CA</p>

<p>corporate@accap.com</p>
<h2>Let us know how we can help you.<br/>Use the contact form below to send us a message.</h2>
<form action="https://themify.me/demo/themes/ultra-accountant/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email Address </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
Our Shop<!--/themify_builder_static-->',
  'post_title' => 'Contact Us',
  'post_excerpt' => '',
  'post_name' => 'contact-us',
  'post_modified' => '2020-04-16 21:32:33',
  'post_modified_gmt' => '2020-04-16 21:32:33',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?page_id=6385',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ddf5721\\",\\"cols\\":[{\\"element_id\\":\\"sbf7723\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"tc1q724\\",\\"mod_settings\\":{\\"heading\\":\\"Let\\\'s get in Touch\\",\\"sub_heading\\":\\"Contact Us\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"p2gy725\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Email, call, or even visit our office, we\\\'d love to help you grow your business<\\\\/p>\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"vertical-divider row-newsletter input-bg-white\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/contact-us.jpg\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"21456b_0.78\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"14.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"m1m6721\\",\\"cols\\":[{\\"element_id\\":\\"b0is725\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"4pmk725\\",\\"mod_settings\\":{\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"fa-phone\\",\\"icon_color_bg\\":\\"blue\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_color_icon\\":\\"6fb0ed_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"60\\",\\"text-shadow_blur_unit\\":\\"px\\",\\"text-shadow_vShadow_unit\\":\\"px\\",\\"text-shadow_hShadow_unit\\":\\"px\\",\\"letter_spacing_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"font_size_unit\\":\\"px\\",\\"font_gradient_color-circle-radial\\":false,\\"font_gradient_color-gradient-angle\\":\\"180\\",\\"font_gradient_color-gradient-type\\":\\"linear\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"122c726\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>(818)657-7220<\\\\/p>\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"3eky726\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"hyw5726\\",\\"mod_settings\\":{\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"fa-map-marker\\",\\"icon_color_bg\\":\\"blue\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_color_icon\\":\\"6fb0ed_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"60\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2l2r726\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>6320 Canoga, 1430 Woodland Hills, CA<\\\\/p>\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"48ul726\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"1dsj726\\",\\"mod_settings\\":{\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"fa-envelope-o\\",\\"icon_color_bg\\":\\"blue\\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_color_icon\\":\\"6fb0ed_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"f_s_i_unit\\":\\"px\\",\\"f_s_i\\":\\"60\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mj4r726\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>corporate@accap.com<\\\\/p>\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"22436c_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"11\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"11\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"50\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"50\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"58su721\\",\\"cols\\":[{\\"element_id\\":\\"3clf727\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"gyi0727\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"jto1727\\",\\"mod_settings\\":{\\"heading\\":\\"Let us know how we can help you.\\",\\"sub_heading\\":\\"Use the contact form below to send us a message.\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"40\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"8hd5727\\",\\"mod_settings\\":{\\"layout_contact\\":\\"style2\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Email Address\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"text_align_success_message_left\\":\\"left\\",\\"text_align_success_message_center\\":\\"center\\",\\"text_align_success_message_right\\":\\"right\\",\\"text_align_success_message_justify\\":\\"justify\\",\\"text_align_error_message_left\\":\\"left\\",\\"text_align_error_message_center\\":\\"center\\",\\"text_align_error_message_right\\":\\"right\\",\\"text_align_error_message_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"contact_sent_from\\":\\"enable\\",\\"send_to_admins\\":\\"true\\",\\"field_optin_active\\":false,\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"provider\\":\\"mailchimp\\",\\"field_sendcopy_active\\":false,\\"field_captcha_active\\":false,\\"field_subject_active\\":false,\\"field_subject_require\\":false,\\"field_email_require\\":false,\\"field_name_require\\":false,\\"post_author\\":false,\\"user_role\\":\\"admin\\"}}]},{\\"element_id\\":\\"hfgd727\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"tablet-full\\",\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"5.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"dtgi721\\",\\"cols\\":[{\\"element_id\\":\\"l74y728\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"msf1728\\",\\"mod_settings\\":{\\"map_display_type\\":\\"dynamic\\",\\"w_map\\":\\"100\\",\\"unit_w\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"520\\",\\"unit_h\\":\\"px\\",\\"type_map\\":\\"ROADMAP\\",\\"style_map\\":\\"cool-grey\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"yes\\",\\"zoom_map\\":\\"16\\",\\"map_center\\":\\"6320 Canoga Avenue, Suite 1430 Woodland Hills, CA 91367\\",\\"markers\\":[{\\"address\\":\\"6320 Canoga Avenue, Suite 1430 Woodland Hills, CA 19367\\",\\"title\\":\\"Our Shop\\",\\"image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/themes\\\\/wp-content\\\\/uploads\\\\/addon-samples\\\\/shop-map-marker.png\\"}],\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"w_map_unit\\":\\"%\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"#ff0000_1\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6371,
  'post_date' => '2017-03-23 11:05:14',
  'post_date_gmt' => '2017-03-23 11:05:14',
  'post_content' => '<!--themify_builder_static--><h1>The First Finance Research in New York<br/>Tax Services & Returns Rectification</h1>
<a href="#appointment" target="_blank" rel="noopener"> Book Appointment </a>
<h2>Accounting Services<br/>Learn more what we serve</h2>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/computerized.png" title="Computerized Bookkeeping " alt="Computerized Bookkeeping " /> <h3> Computerized Bookkeeping & Accounting </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/incorporation.png" title="Business Registration / Incorporation" alt="Business Registration / Incorporation" /> <h3> Business Registration / Incorporation </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/tax.png" title="Tax Services " alt="Tax Services " /> <h3> Tax Services & Returns Rectification </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/cra-audit.png" title="Assistance with CRA audits " alt="Assistance with CRA audits " /> <h3> Assistance with CRA audits & matters </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/business-registration.png" title="Business Registration / Incorporation" alt="Business Registration / Incorporation" /> <h3> Business Registration / Incorporation </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/pay-roll.png" title="Employee Payroll Services, GST/HST " alt="Employee Payroll Services, GST/HST " /> <h3> Employee Payroll Services, GST/HST & W.S.I.B </h3>
<h1>Contact us Today and Receive a Free Tax Service.<br/>First Time Free Consultation</h1>
<a href="#appointment" target="_blank" rel="noopener"> Book Appointment </a>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/consultation-icon.png" title="Consultation and Registration of HST, Payroll, etc." alt="Consultation and Registration of HST, Payroll, etc." /> <h3> Consultation and Registration of HST, Payroll, etc. </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/tex-returns.png" title="Review and rectify past year tax returns" alt="Review and rectify past year tax returns" /> <h3> Review and rectify past year tax returns </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/storage-data-icon.png" title="Storage of data and files electronically" alt="Storage of data and files electronically" /> <h3> Storage of data and files electronically </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/initials-tax-icon.png" title="Initial Tax Return, Address change, and more..." alt="Initial Tax Return, Address change, and more..." /> <h3> Initial Tax Return, Address change, and more... </h3>
<h2>Latest News<br/>General Accounting News & Tips</h2>

<h3>Put yourself in the know and discover the most exclusive upcoming events before anyone else.<br/>Sign up to our Newsletter</h3>

<h4>Send us a Message</h4>
<form action="https://themify.me/demo/themes/ultra-accountant/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Email Address </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<h6>Contact Information</h6>
6320 Canoga , Suite 1430 Hills, CA
(818)657-7220
corporate@accap.com<!--/themify_builder_static-->',
  'post_title' => 'Home - Accountant',
  'post_excerpt' => '',
  'post_name' => 'home-accountant',
  'post_modified' => '2020-04-16 21:32:52',
  'post_modified_gmt' => '2020-04-16 21:32:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?page_id=6371',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"yenb220\\",\\"cols\\":[{\\"element_id\\":\\"ikh9224\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"huov225\\",\\"mod_settings\\":{\\"heading\\":\\"The First Finance Research in New York\\",\\"sub_heading\\":\\"Tax Services & Returns Rectification\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"iq98624\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"Book Appointment\\",\\"link\\":\\"#appointment\\",\\"link_options\\":\\"newtab\\",\\"button_color_bg\\":\\"yellow\\",\\"icon_alignment\\":\\"left\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"2\\",\\"margin_top_unit\\":\\"em\\",\\"margin_right_unit\\":\\"em\\",\\"margin_bottom_unit\\":\\"em\\",\\"margin_left_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"text_decoration\\":\\"none\\",\\"link_checkbox_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeInLeft\\",\\"animation_effect_delay\\":\\".2\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"circle\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/home-banner.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"21456b_0.78\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"14.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_bottom\\":\\"70\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"custom_css_row\\":\\"vertical-divider\\",\\"checkbox_padding_apply_all\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}},{\\"element_id\\":\\"e8kl220\\",\\"cols\\":[{\\"element_id\\":\\"dydm227\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"yh32228\\",\\"mod_settings\\":{\\"heading\\":\\"Accounting Services\\",\\"sub_heading\\":\\"Learn more what we serve\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"2.75\\",\\"margin_bottom_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"0\\",\\"margin_bottom\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"30\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"uyob228\\",\\"cols\\":[{\\"element_id\\":\\"7wfv229\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6wcg229\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/computerized.png\\",\\"title_image\\":\\"Computerized Bookkeeping & Accounting\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"zoomIn\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"top\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"14\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"padding_right\\":2,\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":2,\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":2,\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":2,\\"padding_top_unit\\":\\"%\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"gweq405\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"wd7266\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/incorporation.png\\",\\"title_image\\":\\"Business Registration \\\\/ Incorporation\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".2\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"14\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"padding_right\\":2,\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":2,\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":2,\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":2,\\"padding_top_unit\\":\\"%\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"}}},{\\"element_id\\":\\"up7x59\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ms3h848\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/tax.png\\",\\"title_image\\":\\"Tax Services & Returns Rectification\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".4\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"14\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"padding_right\\":2,\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":2,\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":2,\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":2,\\"padding_top_unit\\":\\"%\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"bottom\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"border-first\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_bottom\\":\\"0\\",\\"margin_bottom\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"gc34231\\",\\"cols\\":[{\\"element_id\\":\\"gvlm63\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e4tl63\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/cra-audit.png\\",\\"title_image\\":\\"Assistance with CRA audits & matters\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".6\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"14\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border-type\\":\\"right\\",\\"border_bottom_style\\":\\"none\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"padding_right\\":2,\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":2,\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":2,\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":2,\\"padding_top_unit\\":\\"%\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"bottom\\"},\\"border_right_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\"}},{\\"element_id\\":\\"rqb2894\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"rlvt692\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/business-registration.png\\",\\"title_image\\":\\"Business Registration \\\\/ Incorporation\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".8\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"14\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_style\\":\\"none\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"right\\"},\\"breakpoint_tablet\\":{\\"padding_right\\":2,\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":2,\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":2,\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":2,\\"padding_top_unit\\":\\"%\\",\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"bottom\\",\\"border_right_color\\":\\"#dddddd\\"}}},{\\"element_id\\":\\"0p0i999\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"6rx0208\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/pay-roll.png\\",\\"title_image\\":\\"Employee Payroll Services, GST\\\\/HST & W.S.I.B\\",\\"param_image\\":\\"regular\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\"1\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"40\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"0\\",\\"margin_top\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"t_sh_t_blur_unit\\":\\"px\\",\\"t_sh_t_vShadow_unit\\":\\"px\\",\\"t_sh_t_hShadow_unit\\":\\"px\\",\\"letter_spacing_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_title_unit\\":\\"px\\",\\"font_size_title\\":\\"14\\"}}}],\\"styling\\":{\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"breakpoint_tablet\\":{\\"padding_right\\":2,\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":2,\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":2,\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":2,\\"padding_top_unit\\":\\"%\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\"}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"border_left_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_top_style\\":\\"solid\\",\\"border-type\\":\\"bottom\\"}}}],\\"styling\\":{\\"custom_css_row\\":\\"accounting-services accounting-services-border\\",\\"padding_top\\":\\"7.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"10\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":false,\\"padding_top_unit\\":\\"%\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"20\\",\\"padding_bottom\\":\\"20\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_padding_apply_all\\":false,\\"padding_left_unit\\":\\"px\\",\\"padding_opp_left\\":false,\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"px\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"hide_anchor\\":false}},{\\"element_id\\":\\"zlpq220\\",\\"cols\\":[{\\"element_id\\":\\"990c234\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"12g6235\\",\\"mod_settings\\":{\\"heading\\":\\"Contact us Today and Receive a Free Tax Service.\\",\\"sub_heading\\":\\"First Time Free Consultation\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_subheading\\":\\"1.1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"animation_effect\\":\\"bounce\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"0trp235\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"buttons_style\\":\\"outline\\",\\"content_button\\":[{\\"label\\":\\"Book Appointment\\",\\"link\\":\\"#appointment\\",\\"link_options\\":\\"newtab\\",\\"button_color_bg\\":\\"yellow\\",\\"icon_alignment\\":\\"left\\"}],\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"1.2\\",\\"margin_top_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"text_decoration\\":\\"none\\",\\"link_checkbox_padding_apply_all\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"bounce\\",\\"animation_effect_delay\\":\\".2\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"circle\\"}}]}],\\"styling\\":{\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/servicebg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-top\\",\\"background_color\\":\\"22436c_1.00\\",\\"cover_color\\":\\"20476b_0.85\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"11.35\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"50\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"as2x220\\",\\"cols\\":[{\\"element_id\\":\\"xsyi235\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0keg235\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/consultation-icon.png\\",\\"title_image\\":\\"Consultation and Registration of HST, Payroll, etc.\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"29\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"25\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\"}}},{\\"element_id\\":\\"s2pe236\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ijw9236\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/tex-returns.png\\",\\"title_image\\":\\"Review and rectify past year tax returns\\",\\"param_image\\":\\"regular\\",\\"padding_top\\":\\"29\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"25\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"x16q236\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0wkq236\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/storage-data-icon.png\\",\\"title_image\\":\\"Storage of data and files electronically\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"29\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"25\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_left_style\\":\\"none\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"8686236\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"p0do237\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/initials-tax-icon.png\\",\\"title_image\\":\\"Initial Tax Return, Address change, and more...\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"29\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"25\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"none\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_style\\":\\"none\\",\\"border_left_style\\":\\"none\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"custom_css_row\\":\\"free-consultation \\",\\"background_color\\":\\"ffffff_1.00\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_bottom_color\\":\\"dddddd_1.00\\",\\"border_bottom_width\\":\\"1\\"}},{\\"element_id\\":\\"qb11220\\",\\"cols\\":[{\\"element_id\\":\\"8aw8237\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"c841237\\",\\"mod_settings\\":{\\"heading\\":\\"Latest News\\",\\"sub_heading\\":\\"General Accounting News & Tips\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_bottom\\":\\"2.35\\",\\"margin_bottom_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"dm2n237\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"1\\",\\"layout_post\\":\\"grid4\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"polaroid\\",\\"post_filter\\":\\"no\\",\\"disable_masonry\\":\\"no\\",\\"post_gutter\\":\\"no-gutter\\",\\"post_per_page_post\\":\\"4\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_height_post\\":\\"358\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"yes\\",\\"css_post\\":\\"latest-news\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"f4f4f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"7.55\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"9p6i220\\",\\"cols\\":[{\\"element_id\\":\\"h044238\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"puxy238\\",\\"mod_settings\\":{\\"heading\\":\\"Put yourself in the know and discover the most exclusive upcoming events before anyone else.\\",\\"sub_heading\\":\\"Sign up to our Newsletter\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"padding_left\\":\\"5\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"5\\",\\"padding_opp_top\\":false}},{\\"element_id\\":\\"g5mv181\\",\\"cols\\":[{\\"element_id\\":\\"lu66182\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":25.39999999999999857891452847979962825775146484375},{\\"element_id\\":\\"bf54183\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"optin\\",\\"element_id\\":\\"aaji726\\",\\"mod_settings\\":{\\"label_firstname\\":\\"First Name\\",\\"default_fname\\":\\"John\\",\\"label_lastname\\":\\"Last Name\\",\\"default_lname\\":\\"Doe\\",\\"label_submit\\":\\"Subscribe\\",\\"message\\":\\"<p>Success!<\\\\/p>\\",\\"layout\\":\\"tb_optin_horizontal\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"success_action\\":\\"s2\\",\\"lname_hide\\":\\"1\\",\\"fname_hide\\":\\"1\\",\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"provider\\":\\"mailchimp\\",\\"r_c_sb_opp_left\\":false,\\"r_c_sb_opp_bottom\\":false,\\"p_sb_opp_left\\":false,\\"p_sb_bottom\\":\\"15\\",\\"p_sb_opp_top\\":\\"1\\",\\"p_sb_top\\":\\"15\\",\\"f_s_s_unit\\":\\"px\\",\\"f_s_s\\":\\"14\\",\\"f_g_c-circle-radial\\":false,\\"f_c_t\\":\\"f_c_solid\\"}}],\\"grid_width\\":41.2000000000000028421709430404007434844970703125,\\"styling\\":{\\"padding_right\\":21,\\"padding_right_unit\\":\\"px\\"}},{\\"element_id\\":\\"v63b183\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":27}]}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"custom_css_row\\":\\"row-newsletter\\",\\"padding_top\\":\\"6.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"4714221\\",\\"cols\\":[{\\"element_id\\":\\"l2p7239\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ubld239\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>Send us a Message<\\\\/h4>\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"margin_bottom\\":20}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"ydod239\\",\\"mod_settings\\":{\\"layout_contact\\":\\"style2\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Email Address\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"text_align_success_message_left\\":\\"left\\",\\"text_align_success_message_center\\":\\"center\\",\\"text_align_success_message_right\\":\\"right\\",\\"text_align_success_message_justify\\":\\"justify\\",\\"text_align_error_message_left\\":\\"left\\",\\"text_align_error_message_center\\":\\"center\\",\\"text_align_error_message_right\\":\\"right\\",\\"text_align_error_message_justify\\":\\"justify\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"contact_sent_from\\":\\"enable\\",\\"send_to_admins\\":\\"true\\",\\"field_optin_active\\":false,\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"provider\\":\\"mailchimp\\",\\"field_sendcopy_active\\":false,\\"field_captcha_active\\":false,\\"field_subject_active\\":false,\\"field_subject_require\\":false,\\"field_email_require\\":false,\\"field_name_require\\":false,\\"post_author\\":false,\\"user_role\\":\\"admin\\"}}],\\"styling\\":{\\"background_color\\":\\"ffffff_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"padding_top\\":\\"4.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"border_top_color\\":\\"dddddd_1.00\\",\\"border_top_width\\":\\"1\\",\\"border_right_color\\":\\"dddddd_1.00\\",\\"border_right_width\\":\\"1\\",\\"border_bottom_color\\":\\"dddddd_1.00\\",\\"border_bottom_width\\":\\"1\\",\\"border_left_color\\":\\"dddddd_1.00\\",\\"border_left_width\\":\\"1\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"dh1o240\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"s4f8240\\",\\"mod_settings\\":{\\"content_text\\":\\"<h6>Contact Information<\\\\/h6>\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"r6ww240\\",\\"mod_settings\\":{\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-map-marker\\",\\"icon_color_bg\\":\\"blue\\",\\"label\\":\\"6320 Canoga , Suite 1430 Hills, CA \\",\\"link_options\\":\\"regular\\",\\"lightbox_width_unit\\":\\"px\\",\\"lightbox_height_unit\\":\\"px\\"}],\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_icon\\":\\"6fb0ed_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"1zrd240\\",\\"mod_settings\\":{\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-phone\\",\\"icon_color_bg\\":\\"blue\\",\\"label\\":\\"(818)657-7220\\",\\"link_options\\":\\"regular\\"}],\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_icon\\":\\"6fb0ed_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"nqud240\\",\\"mod_settings\\":{\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"none\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"fa-envelope-o\\",\\"icon_color_bg\\":\\"blue\\",\\"label\\":\\"corporate@accap.com\\",\\"link_options\\":\\"regular\\"}],\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_color_icon\\":\\"6fb0ed_1.00\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}],\\"styling\\":{\\"background_color\\":\\"22436c_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"4.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3.5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"4.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3.5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_border_apply_all\\":\\"border\\"}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"tablet-full\\",\\"styling\\":{\\"custom_css_row\\":\\"hp-contact\\",\\"row_anchor\\":\\"appointment\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"-185\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"em\\",\\"checkbox_border_apply_all\\":\\"border\\"}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6391,
  'post_date' => '2017-03-23 11:42:47',
  'post_date_gmt' => '2017-03-23 11:42:47',
  'post_content' => '<!--themify_builder_static--><h1>Accounting<br/>News</h1>

<!--/themify_builder_static-->',
  'post_title' => 'News',
  'post_excerpt' => '',
  'post_name' => 'news',
  'post_modified' => '2019-11-04 03:35:22',
  'post_modified_gmt' => '2019-11-04 03:35:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?page_id=6391',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"tvic000\\",\\"cols\\":[{\\"element_id\\":\\"kjb0330\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"q5f1880\\",\\"mod_settings\\":{\\"heading\\":\\"Accounting\\",\\"sub_heading\\":\\"News\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type\\":\\"image\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-type\\":\\"linear\\",\\"background_image-gradient-angle\\":\\"0\\",\\"padding_top_unit\\":\\"px\\",\\"padding_right_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"px\\",\\"padding_left_unit\\":\\"px\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"main_margin_top_unit\\":\\"px\\",\\"main_margin_bottom_unit\\":\\"px\\",\\"font_size_subheading_unit\\":\\"px\\",\\"line_height_subheading_unit\\":\\"px\\",\\"sub_margin_top_unit\\":\\"px\\",\\"sub_margin_bottom_unit\\":\\"px\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"element_id\\":\\"k2v2686\\",\\"cols\\":[{\\"element_id\\":\\"gmt6688\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":33.33330000000000126192389870993793010711669921875},{\\"element_id\\":\\"0cjn688\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"optin\\",\\"element_id\\":\\"3x1s854\\",\\"mod_settings\\":{\\"label_firstname\\":\\"First Name\\",\\"default_fname\\":\\"John\\",\\"label_lastname\\":\\"Last Name\\",\\"default_lname\\":\\"Doe\\",\\"label_submit\\":\\"Subscribe\\",\\"message\\":\\"<p>Success!<\\\\/p>\\",\\"layout\\":\\"tb_optin_horizontal\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"success_action\\":\\"s2\\",\\"lname_hide\\":\\"1\\",\\"fname_hide\\":\\"1\\",\\"mailchimp_list\\":\\"0f2a95e5de\\",\\"provider\\":\\"mailchimp\\",\\"p_sb_opp_left\\":false,\\"p_sb_bottom\\":\\"15\\",\\"p_sb_opp_top\\":\\"1\\",\\"p_sb_top\\":\\"15\\",\\"f_s_s_unit\\":\\"px\\",\\"f_s_s\\":\\"12\\",\\"f_c_i\\":\\"#636363\\",\\"bg_c_i\\":\\"#ffffff\\",\\"p_in_left\\":\\"10\\",\\"p_in_opp_left\\":\\"1\\",\\"p_in_bottom\\":\\"12\\",\\"p_in_right\\":\\"10\\",\\"p_in_opp_top\\":\\"1\\",\\"p_in_top\\":\\"12\\"}}],\\"grid_width\\":32.13329999999999841975295566953718662261962890625},{\\"element_id\\":\\"z7wk688\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":34.53329999999999699866748414933681488037109375}],\\"gutter\\":\\"gutter-none\\"},{\\"element_id\\":\\"8q1c208\\",\\"cols\\":[{\\"element_id\\":\\"xk4o208\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":31.199999999999999289457264239899814128875732421875},{\\"element_id\\":\\"a8nd209\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":30},{\\"element_id\\":\\"ruxq210\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":32.39999999999999857891452847979962825775146484375}]}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"vertical-divider row-newsletter input-bg-white\\",\\"background_type\\":\\"image\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/news-banner-min.jpg\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-bottom\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"21456b_0.78\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"14.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"g1vy068\\",\\"cols\\":[{\\"element_id\\":\\"a3zs604\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"c3iv800\\",\\"mod_settings\\":{\\"layout_post\\":\\"grid3\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"post_content_layout\\":\\"polaroid\\",\\"post_filter\\":\\"no\\",\\"post_gutter\\":\\"no-gutter\\",\\"post_per_page_post\\":\\"12\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"img_width_post\\":\\"390\\",\\"img_height_post\\":\\"400\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_page_nav_post\\":\\"no\\",\\"css_post\\":\\"latest-news\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_title_unit\\":\\"px\\",\\"line_height_title_unit\\":\\"px\\",\\"font_size_meta_unit\\":\\"px\\",\\"line_height_meta_unit\\":\\"px\\",\\"font_size_date_unit\\":\\"px\\",\\"line_height_date_unit\\":\\"px\\",\\"font_size_content_unit\\":\\"px\\",\\"line_height_content_unit\\":\\"px\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_gradient-gradient-type\\":\\"linear\\",\\"background_gradient-gradient-angle\\":\\"180\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient-type\\":\\"linear\\",\\"cover_gradient-gradient-angle\\":\\"180\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient-type\\":\\"linear\\",\\"cover_gradient_hover-gradient-angle\\":\\"180\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size_unit\\":\\"px\\",\\"line_height_unit\\":\\"px\\",\\"padding_top\\":\\"7.35\\",\\"padding_top_unit\\":\\"em\\",\\"padding_right_unit\\":\\"em\\",\\"padding_bottom\\":\\"7.35\\",\\"padding_bottom_unit\\":\\"em\\",\\"padding_left_unit\\":\\"em\\",\\"margin_top_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_left_unit\\":\\"px\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"40\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"border_top_style\\":\\"solid\\",\\"border_right_style\\":\\"solid\\",\\"border_bottom_style\\":\\"solid\\",\\"border_left_style\\":\\"solid\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6381,
  'post_date' => '2017-03-23 11:34:48',
  'post_date_gmt' => '2017-03-23 11:34:48',
  'post_content' => '<!--themify_builder_static--><h1>About Us<br/>What We Do</h1>
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer bibendum aliquam consectetur Vestibulum et hendrerit quam, vel mollis diam.</p>
<h2>Tax Compliance & Planning<br/></h2>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/computerized.png" title="Computerized Bookkeeping " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Computerized Bookkeeping & Accounting </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/incorporation.png" title="Business Registration / Incorporation" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Business Registration / Incorporation </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/tax.png" title="Tax Services " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Tax Services & Returns Rectification </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/cra-audit.png" title="Assistance with CRA audits " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Assistance with CRA audits & matters </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/business-registration.png" title="Business Registration / Incorporation" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Business Registration / Incorporation </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/pay-roll.png" title="Employee Payroll Services, GST/HST " alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Employee Payroll Services, GST/HST & W.S.I.B </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<h2>Accounting & Assurance<br/></h2>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/compilation-engagements.png" title="Compilation Engagements" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Compilation Engagements </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/review-engagements.png" title="Review Engagements" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Review Engagements </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/audit-engagements.png" title="Audit Engagements" alt="Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a." /> <h3> Audit Engagements </h3> Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.
<h2>Other Services<br/></h2>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/bookkeeping-icon.png" title="Bookkeeping" alt="Bookkeeping" /> <h3> Bookkeeping </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/purchase-icon.png" title="Purchase / Sale of a Business" alt="Purchase / Sale of a Business" /> <h3> Purchase / Sale of a Business </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/payroll-icon.png" title="Payroll Compliance" alt="Payroll Compliance" /> <h3> Payroll Compliance </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/business-plan-icon.png" title="Business Plans and Forecasts" alt="Business Plans and Forecasts" /> <h3> Business Plans and Forecasts </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/diligence-icon.png" title="Due Diligence Procedures" alt="Due Diligence Procedures" /> <h3> Due Diligence Procedures </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/task-provision-icon.png" title="Tax Provision Preparation " alt="Tax Provision Preparation " /> <h3> Tax Provision Preparation & Review </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/assistance-icon.png" title="Assistance with Obtaining Financing" alt="Assistance with Obtaining Financing" /> <h3> Assistance with Obtaining Financing </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/merger-icon.png" title="Mergers " alt="Mergers " /> <h3> Mergers & Acquisitions </h3>
<img src="https://themify.me/demo/themes/ultra-accountant/files/2017/07/strategic-icon.png" title="Strategic Tax Planning" alt="Strategic Tax Planning" /> <h3> Strategic Tax Planning </h3>
<ul data-id="tb_v00u649" data-visible="1" data-mob-visible="" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="no" data-effect="cover-fade" data-height="variable" data-pause-on-hover="resume" data-horizontal="" > <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/jonathan-doe.png" alt="I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”." /> </figure> <h3>I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”.</h3> Jonathan Doe Director of Technical Support at Shopify </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-1.png" alt="Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio." /> </figure> <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio.</h3> Dennise King CEO Landmark Corporation </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-2.png" alt="Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur." /> </figure> <h3>Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur.</h3> Robert Gill Vice President Wheel Spain Ltd </li> <li> 
 <figure> <img src="https://themify.me/demo/themes/ultra-accountant/files/2017/03/person-3.png" alt="Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae." /> </figure> <h3>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae.</h3> Juli Smith Manager County Road Association </li> </ul>
<h1>Contact us Today and Receive a Free Tax Service.<br/>Let\'s talk about how we can help you</h1>
<a href="https://themify.me/demo/themes/ultra-accountant/contact-us/" > Contact Us </a><!--/themify_builder_static-->',
  'post_title' => 'Services',
  'post_excerpt' => '',
  'post_name' => 'services',
  'post_modified' => '2019-11-04 07:50:43',
  'post_modified_gmt' => '2019-11-04 07:50:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?page_id=6381',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'builder_switch_frontend' => '0',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"dvn3626\\",\\"cols\\":[{\\"element_id\\":\\"4vvo632\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"6x1h634\\",\\"mod_settings\\":{\\"heading\\":\\"About Us\\",\\"sub_heading\\":\\"What We Do\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"animation_effect\\":\\"fadeInDown\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2mht635\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Integer bibendum aliquam consectetur Vestibulum et hendrerit quam, vel mollis diam.<\\\\/p>\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"custom_css_row\\":\\"vertical-divider\\",\\"background_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/servicebg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_position\\":\\"center-center\\",\\"cover_color\\":\\"21456b_0.78\\",\\"font_color\\":\\"ffffff_1.00\\",\\"text_align\\":\\"center\\",\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"14.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}},{\\"element_id\\":\\"ac35627\\",\\"cols\\":[{\\"element_id\\":\\"a97d637\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"bkd6637\\",\\"mod_settings\\":{\\"heading\\":\\"Tax Compliance & Planning\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_top\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"divider\\":\\"no\\",\\"margin_opp_left\\":false,\\"margin_bottom\\":\\"40\\",\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"checkbox_margin_apply_all\\":false,\\"margin_left_unit\\":\\"px\\",\\"margin_bottom_unit\\":\\"px\\",\\"margin_right_unit\\":\\"px\\",\\"margin_top_unit\\":\\"px\\"}},{\\"element_id\\":\\"j2yv637\\",\\"cols\\":[{\\"element_id\\":\\"h4m6156\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ub3d157\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/computerized.png\\",\\"title_image\\":\\"Computerized Bookkeeping & Accounting\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false,\\"padding_bottom\\":\\"30\\"}},{\\"element_id\\":\\"skbl768\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ov7a769\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/incorporation.png\\",\\"title_image\\":\\"Business Registration \\\\/ Incorporation\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".2\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false,\\"padding_bottom\\":\\"30\\"}},{\\"element_id\\":\\"lc7i706\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"xzx4706\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/tax.png\\",\\"title_image\\":\\"Tax Services & Returns Rectification\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".4\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false,\\"padding_bottom\\":\\"30\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"border-first\\"}},{\\"element_id\\":\\"0bz0640\\",\\"cols\\":[{\\"element_id\\":\\"54ui792\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"hrdg793\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/cra-audit.png\\",\\"title_image\\":\\"Assistance with CRA audits & matters\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".6\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false,\\"padding_bottom\\":\\"30\\"}},{\\"element_id\\":\\"1erp656\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"inrh657\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/business-registration.png\\",\\"title_image\\":\\"Business Registration \\\\/ Incorporation\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".8\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false,\\"padding_bottom\\":\\"30\\"}},{\\"element_id\\":\\"2xjr325\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zbw0326\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/pay-roll.png\\",\\"title_image\\":\\"Employee Payroll Services, GST\\\\/HST & W.S.I.B\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\"1\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false,\\"padding_bottom\\":\\"30\\"}}],\\"gutter\\":\\"gutter-none\\"}]}],\\"styling\\":{\\"custom_css_row\\":\\"accounting-services compliance-planning\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"7.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"bpud627\\",\\"cols\\":[{\\"element_id\\":\\"3h32641\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"0umi642\\",\\"mod_settings\\":{\\"heading\\":\\"Accounting & Assurance\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"0\\",\\"margin_bottom\\":\\"0\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"xyhv642\\",\\"cols\\":[{\\"element_id\\":\\"y2nx642\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"abaz642\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/compilation-engagements.png\\",\\"title_image\\":\\"Compilation Engagements\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false}},{\\"element_id\\":\\"d1nt642\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"jeqm642\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/review-engagements.png\\",\\"title_image\\":\\"Review Engagements\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".2\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"image_zoom_icon\\":false,\\"lightbox_height_unit\\":\\"px\\",\\"lightbox_width_unit\\":\\"px\\",\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false}},{\\"element_id\\":\\"igkb643\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"i24p643\\",\\"mod_settings\\":{\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/audit-engagements.png\\",\\"title_image\\":\\"Audit Engagements\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Duis a metus ac purus consequat tincidunt eu quis nulla. Nam pharetra libero nulla, sit amet maximus ligula pretium a.\\",\\"animation_effect\\":\\"zoomIn\\",\\"animation_effect_delay\\":\\".4\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}],\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"padding_left\\":\\"25\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"25\\",\\"padding_opp_top\\":false}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"custom_css_column\\":\\"border-first\\"}}]}],\\"styling\\":{\\"custom_css_row\\":\\"accounting-services compliance-planning\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"f4f4f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"7.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"80\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"sm34627\\",\\"cols\\":[{\\"element_id\\":\\"bv96643\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"juvs643\\",\\"mod_settings\\":{\\"heading\\":\\"Other Services\\",\\"heading_tag\\":\\"h2\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_image-css\\":\\"background-image: -moz-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -webkit-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -o-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: -ms-linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\nbackground-image: linear-gradient(180deg,rgb(0, 0, 0) 0%, rgb(255, 255, 255) 100%);\\\\n\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}},{\\"element_id\\":\\"vl4x644\\",\\"cols\\":[{\\"element_id\\":\\"2l1x644\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"h7as644\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/bookkeeping-icon.png\\",\\"title_image\\":\\"Bookkeeping\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}},{\\"element_id\\":\\"9u9t693\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"idwy693\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/purchase-icon.png\\",\\"title_image\\":\\"Purchase \\\\/ Sale of a Business\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".1\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}},{\\"element_id\\":\\"hdr6172\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"mm1s173\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/payroll-icon.png\\",\\"title_image\\":\\"Payroll Compliance\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".2\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}}]},{\\"element_id\\":\\"hxqy646\\",\\"cols\\":[{\\"element_id\\":\\"wtq7579\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"mh5u579\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/business-plan-icon.png\\",\\"title_image\\":\\"Business Plans and Forecasts\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".3\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"12\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_bottom\\":\\"6\\",\\"padding_opp_top\\":false,\\"padding_top\\":30,\\"padding_top_unit\\":\\"px\\"}},{\\"element_id\\":\\"8f91904\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"jobq905\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/diligence-icon.png\\",\\"title_image\\":\\"Due Diligence Procedures\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".4\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}},{\\"element_id\\":\\"80fv877\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"91vz877\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/task-provision-icon.png\\",\\"title_image\\":\\"Tax Provision Preparation & Review\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".5\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}}]},{\\"element_id\\":\\"kq0e648\\",\\"cols\\":[{\\"element_id\\":\\"5dx129\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"1nnq30\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/assistance-icon.png\\",\\"title_image\\":\\"Assistance with Obtaining Financing\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".6\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}},{\\"element_id\\":\\"h9mc21\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"7py522\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/merger-icon.png\\",\\"title_image\\":\\"Mergers & Acquisitions\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".7\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\"}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}},{\\"element_id\\":\\"5hm6108\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"k1gj109\\",\\"mod_settings\\":{\\"style_image\\":\\"image-left\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/07\\\\/strategic-icon.png\\",\\"title_image\\":\\"Strategic Tax Planning\\",\\"param_image\\":\\"regular\\",\\"text_decoration\\":\\"underline\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"animation_effect\\":\\"fadeIn\\",\\"animation_effect_delay\\":\\".8\\",\\"image_zoom_icon\\":false,\\"auto_fullwidth\\":false,\\"appearance_image\\":false,\\"caption_on_overlay\\":false,\\"title_margin_opp_left\\":false,\\"title_margin_opp_top\\":false,\\"title_margin_top\\":\\"15\\",\\"margin_opp_left\\":false,\\"margin_opp_top\\":false,\\"padding_opp_left\\":false,\\"padding_opp_top\\":false}}],\\"styling\\":{\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_opp_left\\":false,\\"padding_opp_top\\":false,\\"padding_top\\":\\"30\\"}}]}]}],\\"styling\\":{\\"custom_css_row\\":\\"other-services\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"padding_top\\":\\"7.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_bottom_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"70\\",\\"padding_bottom\\":\\"70\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"hide_anchor\\":false}},{\\"element_id\\":\\"1xku627\\",\\"cols\\":[{\\"element_id\\":\\"v944649\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"testimonial-slider\\",\\"element_id\\":\\"v00u649\\",\\"mod_settings\\":{\\"layout_testimonial\\":\\"image-top\\",\\"tab_content_testimonial\\":[{\\"title_testimonial\\":\\"I am glad I switched over to Electro Accounting. In my very first year, I found I could claim expenses I never thought I could. Even better, I got a refund. Something I never got dealing with so called “Professionals”.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/jonathan-doe.png\\",\\"person_name_testimonial\\":\\"Jonathan Doe\\",\\"person_position_testimonial\\":\\"Director of Technical Support at Shopify\\"},{\\"title_testimonial\\":\\"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent dapibus sodales accumsan. Maecenas vulputate erat, sed varius ipsum velit sed odio.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-1.png\\",\\"person_name_testimonial\\":\\"Dennise King\\",\\"person_position_testimonial\\":\\"CEO\\",\\"company_testimonial\\":\\"Landmark Corporation\\"},{\\"title_testimonial\\":\\"Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Similique suscipit, id ducimus illum corporis pariatur.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-2.png\\",\\"person_name_testimonial\\":\\"Robert Gill\\",\\"person_position_testimonial\\":\\"Vice President\\",\\"company_testimonial\\":\\"Wheel Spain Ltd\\"},{\\"title_testimonial\\":\\"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae.\\",\\"person_picture_testimonial\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/files\\\\/2017\\\\/03\\\\/person-3.png\\",\\"person_name_testimonial\\":\\"Juli Smith\\",\\"person_position_testimonial\\":\\"Manager\\",\\"company_testimonial\\":\\"County Road Association\\"}],\\"visible_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"cover-fade\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"no\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_arrow_buttons_vertical\\":\\"vertical\\",\\"height_slider\\":\\"variable\\",\\"css_testimonial\\":\\"testimonials\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"animation_effect\\":\\"fadeInUp\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"22436c_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_color\\":\\"ffffff_1.00\\",\\"padding_top\\":\\"5.5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"5.5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet_landscape\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"30\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"element_id\\":\\"t9wb627\\",\\"cols\\":[{\\"element_id\\":\\"id6e650\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"s056650\\",\\"mod_settings\\":{\\"heading\\":\\"Contact us Today and Receive a Free Tax Service.\\",\\"sub_heading\\":\\"Let\\\'s talk about how we can help you\\",\\"heading_tag\\":\\"h1\\",\\"text_alignment\\":\\"themify-text-center\\",\\"background_image-gradient-angle\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"font_size_subheading\\":\\"1.1\\",\\"font_size_subheading_unit\\":\\"em\\",\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"padding\\",\\"margin_right\\":\\"20\\",\\"margin_left\\":\\"20\\",\\"checkbox_border_apply_all\\":\\"border\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"31lw650\\",\\"mod_settings\\":{\\"buttons_size\\":\\"normal\\",\\"content_button\\":[{\\"label\\":\\"Contact Us\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-accountant\\\\/contact-us\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"brown\\",\\"icon_alignment\\":\\"left\\"}],\\"background_image-type_gradient\\":\\"gradient\\",\\"background_image-gradient-angle\\":\\"0\\",\\"text_align_left\\":\\"left\\",\\"text_align_center\\":\\"center\\",\\"text_align_right\\":\\"right\\",\\"text_align_justify\\":\\"justify\\",\\"checkbox_padding_apply_all\\":\\"padding\\",\\"checkbox_padding_apply_all_padding\\":\\"padding\\",\\"margin_top\\":\\"1.3\\",\\"margin_top_unit\\":\\"em\\",\\"checkbox_margin_apply_all_margin\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"checkbox_border_apply_all_border\\":\\"border\\",\\"checkbox_link_padding_apply_all\\":\\"padding\\",\\"checkbox_link_padding_apply_all_padding\\":\\"padding\\",\\"link_checkbox_margin_apply_all\\":\\"margin\\",\\"link_checkbox_margin_apply_all_margin\\":\\"margin\\",\\"link_checkbox_border_apply_all\\":\\"border\\",\\"link_checkbox_border_apply_all_border\\":\\"border\\",\\"custom_parallax_scroll_fade_fade\\":\\"fade\\",\\"visibility_desktop_hide\\":\\"hide\\",\\"visibility_tablet_hide\\":\\"hide\\",\\"visibility_mobile_hide\\":\\"hide\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"squared\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"custom_css_row\\":\\"about-team\\",\\"background_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"background_color\\":\\"f4f4f4_1.00\\",\\"cover_color-type\\":\\"color\\",\\"cover_gradient-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_gradient_hover-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"text_align\\":\\"center\\",\\"padding_top\\":\\"6.15\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6.85\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\",\\"breakpoint_tablet\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"60\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"},\\"breakpoint_mobile\\":{\\"text_decoration\\":\\"underline\\",\\"padding_top\\":\\"50\\",\\"padding_bottom\\":\\"60\\",\\"checkbox_margin_apply_all\\":\\"margin\\",\\"checkbox_border_apply_all\\":\\"border\\"}}}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6451,
  'post_date' => '2017-06-03 13:37:19',
  'post_date_gmt' => '2017-06-03 13:37:19',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6451',
  'post_modified' => '2019-03-06 09:16:40',
  'post_modified_gmt' => '2019-03-06 09:16:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6451',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6376',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6450,
  'post_date' => '2017-06-03 13:37:19',
  'post_date_gmt' => '2017-06-03 13:37:19',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6450',
  'post_modified' => '2019-03-06 09:16:40',
  'post_modified_gmt' => '2019-03-06 09:16:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6450',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6381',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6453,
  'post_date' => '2017-06-03 13:37:19',
  'post_date_gmt' => '2017-06-03 13:37:19',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6453',
  'post_modified' => '2019-03-06 09:16:40',
  'post_modified_gmt' => '2019-03-06 09:16:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6453',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6391',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6454,
  'post_date' => '2017-06-03 13:37:19',
  'post_date_gmt' => '2017-06-03 13:37:19',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact-2',
  'post_modified' => '2019-03-06 09:16:40',
  'post_modified_gmt' => '2019-03-06 09:16:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6454',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6385',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'footer-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6444,
  'post_date' => '2017-06-03 13:34:40',
  'post_date_gmt' => '2017-06-03 13:34:40',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6444',
  'post_modified' => '2019-03-06 09:17:14',
  'post_modified_gmt' => '2019-03-06 09:17:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6444',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6376',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'header-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6445,
  'post_date' => '2017-06-03 13:34:40',
  'post_date_gmt' => '2017-06-03 13:34:40',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6445',
  'post_modified' => '2019-03-06 09:17:14',
  'post_modified_gmt' => '2019-03-06 09:17:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6445',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6381',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'header-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6447,
  'post_date' => '2017-06-03 13:34:40',
  'post_date_gmt' => '2017-06-03 13:34:40',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6447',
  'post_modified' => '2019-03-06 09:17:14',
  'post_modified_gmt' => '2019-03-06 09:17:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6447',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6391',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'header-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6448,
  'post_date' => '2017-06-03 13:34:40',
  'post_date_gmt' => '2017-06-03 13:34:40',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '6448',
  'post_modified' => '2019-03-06 09:17:14',
  'post_modified_gmt' => '2019-03-06 09:17:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6448',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6385',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'header-menu',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6449,
  'post_date' => '2017-06-03 13:34:40',
  'post_date_gmt' => '2017-06-03 13:34:40',
  'post_content' => '',
  'post_title' => 'Book Appointment',
  'post_excerpt' => '',
  'post_name' => 'book-appointment',
  'post_modified' => '2019-03-06 09:17:14',
  'post_modified_gmt' => '2019-03-06 09:17:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-accountant/?p=6449',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6449',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => 'highlight-link',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-accountant/#appointment',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'header-menu',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_archives" );
$widgets[1002] = array (
  'title' => '',
  'count' => 0,
  'dropdown' => 0,
);
update_option( "widget_archives", $widgets );

$widgets = get_option( "widget_meta" );
$widgets[1003] = array (
  'title' => '',
);
update_option( "widget_meta", $widgets );

$widgets = get_option( "widget_search" );
$widgets[1004] = array (
  'title' => '',
);
update_option( "widget_search", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1005] = array (
  'title' => '',
  'text' => '<span class="fa fa-phone"></span><a href="tel:(818)657-7220">(818)657-7220</a>',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1006] = array (
  'title' => 'About',
  'text' => 'The Ultra theme is Themify\'s flagship theme. It\'s a WordPress designed to give you more control on the design of your theme. Built to work seamlessly with our drag & drop Builder plugin, it gives you the ability to customize the look and feel of your content. ',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_categories" );
$widgets[1007] = array (
  'title' => '',
  'count' => 0,
  'hierarchical' => 0,
  'dropdown' => 0,
);
update_option( "widget_categories", $widgets );

$widgets = get_option( "widget_recent-posts" );
$widgets[1008] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_recent-comments" );
$widgets[1009] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-comments", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1010] = array (
  'title' => 'Recent Posts',
  'category' => '0',
  'show_count' => '3',
  'show_date' => 'on',
  'show_thumb' => 'on',
  'display' => 'none',
  'hide_title' => NULL,
  'thumb_width' => '50',
  'thumb_height' => '50',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1011] = array (
  'title' => 'Recent Posts',
  'category' => '0',
  'show_count' => '3',
  'show_date' => 'on',
  'show_thumb' => 'on',
  'display' => 'none',
  'hide_title' => NULL,
  'thumb_width' => '50',
  'thumb_height' => '50',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1012] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1013] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1014] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'show_count' => '3',
  'hide_timestamp' => NULL,
  'show_follow' => 'on',
  'follow_text' => '→ Follow me',
  'include_retweets' => 'on',
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1015] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'show_count' => '2',
  'hide_timestamp' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1016] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1017] = array (
  'title' => 'Recent Posts',
  'category' => '0',
  'show_count' => '3',
  'show_date' => 'on',
  'show_thumb' => 'on',
  'display' => 'none',
  'hide_title' => NULL,
  'thumb_width' => '50',
  'thumb_height' => '50',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1018] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'show_count' => '3',
  'hide_timestamp' => NULL,
  'show_follow' => 'on',
  'follow_text' => '→ Follow me',
  'include_retweets' => 'on',
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1019] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1020] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1021] = array (
  'title' => '',
  'text' => '<span class="fa fa-phone"></span><a href="tel:(818)657-7220">(818)657-7220</a>',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1022] = array (
  'title' => '',
  'show_link_name' => NULL,
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'horizontal',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1023] = array (
  'title' => 'Widget 3',
  'text' => 'For example, phone #: 123-333-4567',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1024] = array (
  'title' => 'Recent Posts',
  'category' => '0',
  'show_count' => '3',
  'show_date' => 'on',
  'show_thumb' => 'on',
  'display' => 'none',
  'hide_title' => NULL,
  'thumb_width' => '50',
  'thumb_height' => '50',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1025] = array (
  'title' => 'About',
  'text' => 'The Ultra theme is Themify\'s flagship theme. It\'s a WordPress designed to give you more control on the design of your theme. Built to work seamlessly with our drag & drop Builder plugin, it gives you the ability to customize the look and feel of your content. ',
  'filter' => false,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1026] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'show_count' => '2',
  'hide_timestamp' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );



$sidebars_widgets = array (
  'wp_inactive_widgets' => 
  array (
    0 => 'archives-1002',
    1 => 'meta-1003',
    2 => 'search-1004',
    3 => 'text-1005',
    4 => 'text-1006',
    5 => 'categories-1007',
    6 => 'recent-posts-1008',
    7 => 'recent-comments-1009',
    8 => 'themify-feature-posts-1010',
    9 => 'themify-feature-posts-1011',
    10 => 'themify-social-links-1012',
    11 => 'themify-social-links-1013',
    12 => 'themify-twitter-1014',
    13 => 'themify-twitter-1015',
    14 => 'themify-social-links-1016',
  ),
  'sidebar-main' => 
  array (
    0 => 'themify-feature-posts-1017',
    1 => 'themify-twitter-1018',
  ),
  'social-widget' => 
  array (
    0 => 'themify-social-links-1019',
  ),
  'footer-social-widget' => 
  array (
    0 => 'themify-social-links-1020',
  ),
  'header-widget-1' => 
  array (
    0 => 'text-1021',
  ),
  'header-widget-2' => 
  array (
    0 => 'themify-social-links-1022',
  ),
  'header-widget-3' => 
  array (
    0 => 'text-1023',
  ),
  'footer-widget-1' => 
  array (
    0 => 'themify-feature-posts-1024',
  ),
  'footer-widget-2' => 
  array (
    0 => 'text-1025',
  ),
  'footer-widget-3' => 
  array (
    0 => 'themify-twitter-1026',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$homepage = get_posts( array( 'name' => 'home-accountant', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			$themify_data = array (
  'setting-webfonts_list' => 'recommended',
  'setting-default_layout' => 'sidebar1',
  'setting-default_post_layout' => 'list-post',
  'setting-post_filter' => 'yes',
  'setting-disable_masonry' => 'yes',
  'setting-post_gutter' => 'gutter',
  'setting-default_layout_display' => 'excerpt',
  'setting-default_more_text' => 'Read More',
  'setting-excerpt_more' => '1',
  'setting-index_orderby' => 'date',
  'setting-index_order' => 'DESC',
  'setting-default_media_position' => 'above',
  'setting-image_post_feature_size' => 'blank',
  'setting-default_page_post_layout' => 'sidebar1',
  'setting-default_page_post_layout_type' => 'classic',
  'setting-default_page_single_media_position' => 'above',
  'setting-image_post_single_feature_size' => 'blank',
  'setting-search-result_layout_display' => 'content',
  'setting-search-result_media_position' => 'above',
  'setting-default_page_layout' => 'sidebar1',
  'setting-custom_post_tglobal_style_single' => 'sidebar1',
  'setting-default_portfolio_index_layout' => 'sidebar-none',
  'setting-default_portfolio_index_post_layout' => 'grid3',
  'setting-portfolio_post_filter' => 'yes',
  'setting-portfolio_disable_masonry' => 'yes',
  'setting-portfolio_gutter' => 'gutter',
  'setting-default_portfolio_index_display' => 'none',
  'setting-default_portfolio_index_title' => ' ',
  'setting-default_portfolio_index_unlink_post_title' => ' ',
  'setting-default_portfolio_index_hide_post_date' => ' ',
  'setting-default_portfolio_index_post_meta_category' => 'yes',
  'setting-default_portfolio_index_unlink_post_image' => 'yes',
  'setting-default_portfolio_single_layout' => 'sidebar-none',
  'setting-default_portfolio_single_portfolio_layout_type' => 'fullwidth',
  'setting-default_portfolio_single_title' => ' ',
  'setting-default_portfolio_single_unlink_post_title' => ' ',
  'setting-default_portfolio_single_hide_post_date' => ' ',
  'setting-default_portfolio_single_post_meta_category' => ' ',
  'setting-default_portfolio_single_unlink_post_image' => 'yes',
  'themify_portfolio_slug' => 'project',
  'themify_portfolio_category_slug' => 'portfolio-category',
  'setting-customizer_responsive_design_tablet_landscape' => '1024',
  'setting-customizer_responsive_design_tablet' => '768',
  'setting-customizer_responsive_design_mobile' => '480',
  'setting-mobile_menu_trigger_point' => '1000',
  'setting-gallery_lightbox' => 'lightbox',
  'setting-cache_gzip' => 'on',
  'setting-header_design' => 'header-top-widgets',
  'setting-exclude_search_form' => 'on',
  'setting_search_form' => 'live_search',
  'setting-exclude_rss' => 'on',
  'setting-exclude_social_widget' => 'on',
  'setting-header_widgets' => 'headerwidget-2col',
  'setting-footer_design' => 'footer-horizontal-left',
  'setting-use_float_back' => 'on',
  'setting-footer_widgets' => 'none',
  'setting-mega_menu_posts' => '5',
  'setting-mega_menu_image_width' => '180',
  'setting-mega_menu_image_height' => '120',
  'setting-mega_menu_post_count' => 'off',
  'setting-imagefilter_applyto' => 'featuredonly',
  'setting-color_animation_speed' => '5',
  'setting-relationship_taxonomy' => 'category',
  'setting-relationship_taxonomy_entries' => '3',
  'setting-relationship_taxonomy_display_content' => 'none',
  'setting-single_slider_autoplay' => 'off',
  'setting-single_slider_speed' => 'normal',
  'setting-single_slider_effect' => 'slide',
  'setting-single_slider_height' => 'auto',
  'setting-more_posts' => 'infinite',
  'setting-autoinfinite' => 'on',
  'setting-entries_nav' => 'numbered',
  'setting-footer_text_left' => '&copy; Copyright <a href="http://themify.me/" target="_blank">Themify</a> 2017. All right reserved.',
  'setting-footer_text_right_hide' => 'hide',
  'setting-img_php_base_size' => 'large',
  'setting-global_feature_size' => 'blank',
  'setting-link_icon_type' => 'font-icon',
  'setting-link_type_themify-link-0' => 'image-icon',
  'setting-link_title_themify-link-0' => 'Twitter',
  'setting-link_img_themify-link-0' => 'https://themify.me/demo/themes/ultra/wp-content/themes/themify-ultra/themify/img/social/twitter.png',
  'setting-link_type_themify-link-1' => 'image-icon',
  'setting-link_title_themify-link-1' => 'Facebook',
  'setting-link_img_themify-link-1' => 'https://themify.me/demo/themes/ultra/wp-content/themes/themify-ultra/themify/img/social/facebook.png',
  'setting-link_type_themify-link-2' => 'image-icon',
  'setting-link_title_themify-link-2' => 'Google',
  'setting-link_img_themify-link-2' => 'https://themify.me/demo/themes/ultra/wp-content/themes/themify-ultra/themify/img/social/google-plus.png',
  'setting-link_type_themify-link-3' => 'image-icon',
  'setting-link_title_themify-link-3' => 'YouTube',
  'setting-link_img_themify-link-3' => 'https://themify.me/demo/themes/ultra/wp-content/themes/themify-ultra/themify/img/social/youtube.png',
  'setting-link_type_themify-link-4' => 'image-icon',
  'setting-link_title_themify-link-4' => 'Pinterest',
  'setting-link_img_themify-link-4' => 'https://themify.me/demo/themes/ultra/wp-content/themes/themify-ultra/themify/img/social/pinterest.png',
  'setting-link_type_themify-link-6' => 'font-icon',
  'setting-link_title_themify-link-6' => 'Facebook',
  'setting-link_link_themify-link-6' => 'https://facebook.com/themify',
  'setting-link_ficon_themify-link-6' => 'fa-facebook',
  'setting-link_type_themify-link-5' => 'font-icon',
  'setting-link_title_themify-link-5' => 'Twitter',
  'setting-link_link_themify-link-5' => 'https://twitter.com/themify',
  'setting-link_ficon_themify-link-5' => 'fa-twitter',
  'setting-link_type_themify-link-10' => 'font-icon',
  'setting-link_title_themify-link-10' => 'Instagram',
  'setting-link_link_themify-link-10' => 'https://themify.me',
  'setting-link_ficon_themify-link-10' => 'ti-instagram',
  'setting-link_type_themify-link-11' => 'font-icon',
  'setting-link_title_themify-link-11' => 'Pinterest',
  'setting-link_link_themify-link-11' => 'https://themify.me',
  'setting-link_ficon_themify-link-11' => 'ti-pinterest',
  'setting-link_type_themify-link-8' => 'font-icon',
  'setting-link_title_themify-link-8' => 'YouTube',
  'setting-link_link_themify-link-8' => 'https://youtube.com/user/themify',
  'setting-link_ficon_themify-link-8' => 'fa-youtube',
  'setting-link_type_themify-link-12' => 'font-icon',
  'setting-link_title_themify-link-12' => 'Google Plus',
  'setting-link_link_themify-link-12' => 'https://themify.me',
  'setting-link_ficon_themify-link-12' => 'ti-google',
  'setting-link_field_ids' => '{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-6":"themify-link-6","themify-link-5":"themify-link-5","themify-link-10":"themify-link-10","themify-link-11":"themify-link-11","themify-link-8":"themify-link-8","themify-link-12":"themify-link-12"}',
  'setting-link_field_hash' => '13',
  'setting-page_builder_is_active' => 'enable',
  'setting-page_builder_animation_appearance' => 'none',
  'setting-page_builder_animation_parallax_bg' => 'none',
  'setting-page_builder_animation_scroll_effect' => 'none',
  'setting-page_builder_animation_sticky_scroll' => 'none',
  'setting-page_builder_cache' => 'on',
  'setting-page_builder_expiry' => '2',
  'skin' => 'accountant',
  'import_images' => 'on',
);
themify_set_data( $themify_data );
$theme = get_option( 'stylesheet' );
$theme_mods = array (
  0 => false,
  'custom_css_post_id' => -1,
  'site-logo_image' => '{"family":null,"mode":"text","id":"","src":""}',
  'site-logo_position' => '{"position":"","top":{"auto":"auto"},"auto":"auto","same":"","right":{"auto":"auto"},"bottom":{"auto":"auto"},"left":{"auto":"auto"}}',
  'site-tagline_position' => '{"position":"","top":{"auto":"auto"},"auto":"auto","same":"","right":{"auto":"auto"},"bottom":{"auto":"auto"},"left":{"auto":"auto"}}',
  'sticky_headerwrap_background' => '{"fixedbg":"","id":"","src":""}',
  'sticky_header_imageselect' => '{"id":"","src":"","imgwidth":"","imgheight":""}',
  'site-tagline' => '{"stamp":1572838629242,"sizenum":""}',
  'module_title_background' => '{"color":"cc6e6e","opacity":"0.48"}',
  'module_title_border' => '{"top":{"color":"","opacity":"","style":"","width":""},"left":{"color":"","opacity":"","style":"","width":""},"bottom":{"color":"","opacity":"","style":"","width":""},"right":{"color":"","opacity":"","style":"","width":""},"style":"double","same":"same","color":"c40202","opacity":"1.00","width":"7"}',
  'module_title_margin' => '{"top":{"width":"","unit":"px"},"left":{"width":"","unit":"px"},"bottom":{"width":"","unit":"px"},"right":{"width":"","unit":"px"},"width":"22","same":"same"}',
  'module_title_padding' => '{"top":{"width":"","unit":"px"},"left":{"width":"","unit":"px"},"bottom":{"width":"","unit":"px"},"right":{"width":"","unit":"px"},"width":"22","same":"same"}',
  'module_title_color' => '{"color":"11db22","opacity":"1.00"}',
  'module_title_font' => '{"sizenum":"32","linenum":"4","weight":"500","letterspacing":"3","italic":"","normal":"normal","underline":"underline","linethrough":"","nostyle":"","texttransform":"lowercase","align":"center"}',
);
update_option( "theme_mods_{$theme}", $theme_mods );
$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "header-menu" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "footer-menu" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["footer-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );



}
themify_do_demo_import();