<?php

use Carbon\Carbon;
use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;
use ToStartWork\Graphs\Dashboard\GenerateAxisTicks;
use ToStartWork\Graphs\Dashboard\TotalSubscribedUsers;
use ToStartWork\Graphs\Dashboard\TotalUserSignupsMonth;


class GraphTest extends TestCase
{
    use DatabaseMigrations;

    public function setUp()
    {
        parent::setUp();
        $this->withoutMiddleware();
    }
    
    public function testGraphTicks()
    {
        $axisTicks = app(GenerateAxisTicks::class);

        $knownDate = Carbon::create(2017, 01, 01);
        Carbon::setTestNow($knownDate);
        $ticks = $axisTicks->get();

        $this->assertEquals([
            [0, 'Feb'],
            [1, 'Mar'],
            [2, 'Apr'],
            [3, 'May'],
            [4, 'Jun'],
            [5, 'Jul'],
            [6, 'Aug'],
            [7, 'Sep'],
            [8, 'Oct'],
            [9, 'Nov'],
            [10, 'Dec'],
            [11, 'Jan']

        ], $ticks);

        $knownDate = Carbon::create(2016, 5, 21);
        Carbon::setTestNow($knownDate);
        $ticks = $axisTicks->get();

        $this->assertEquals([
            [0, 'Jun'],
            [1, 'Jul'],
            [2, 'Aug'],
            [3, 'Sep'],
            [4, 'Oct'],
            [5, 'Nov'],
            [6, 'Dec'],
            [7, 'Jan'],
            [8, 'Feb'],
            [9, 'Mar'],
            [10, 'Apr'],
            [11, 'May']

        ], $ticks);

        Carbon::setTestNow();
    }

    /**
     * totals new users per month over the last 12 months
     */
    public function testUserSignupsMonthlyData()
    {
        $startDate = Carbon::create(2016, 01, 31);
       // $startDate = Carbon::now()->subMonths(12);
        Carbon::setTestNow($startDate);

        //Setup fake users over last 12 months
        for ($i=0;$i<=11;$i++) {
            factory(\ToStartWork\User::class, 3)->create();
            Carbon::setTestNow($startDate->addMonth());
        }

        $totalUserSignupsMonthly = app(TotalUserSignupsMonth::class);
        $totals = $totalUserSignupsMonthly->get();

        for ($i=0;$i<=11;$i++) {
            $this->assertEquals(3, $totals[$i][1]);
        }
    }

    /**
     * totals new users per month over the last 12 months
     */
    public function testTotalSubscribedUsersData()
    {
        $startDate = Carbon::create(2016, 01, 31);
        //$startDate = Carbon::now()->subMonths(12);
        Carbon::setTestNow($startDate);

        //Setup fake users over last 12 months
        for ($i=0;$i<=11;$i++) {
            $users = factory(\ToStartWork\User::class, 3)->create();
            Carbon::setTestNow($startDate->addMonth());
        }

        $TotalSubscribedUsers = app(TotalSubscribedUsers::class);
        $totals = $TotalSubscribedUsers->get();

        for ($i=0;$i<=11;$i++) {
            $this->assertEquals(3*($i+1), $totals[$i][1]);
        }
    }


}
