<?php $__env->startSection('content'); ?>
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <h2 class="font-light m-b-xs">
                    Edit Qualification <?php echo e($qualification->name); ?>

                </h2>
            </div>
        </div>
    </div>

    <div class="content">
        <?php echo Former::horizontal_open()->id('edit-qualification')->rules(['name' => 'required'])->method('PUT')->action(route('qualifications.update', [$qualification->id])); ?>


        <div class="hpanel">
            <div class="panel-body">
                <div class="form-horizontal">
                    <div class="row">
                        <div class="col-lg-6">
                            <h4>Qualification Details</h4>
                            <?php echo Former::text('name')->label('Name')->value($qualification->name); ?>

                            <?php echo Former::text('type')->setAttribute('readonly', 'readonly')->label('Type')->value($qualification->type_name); ?>

                            <?php echo Former::text('trade_type')->setAttribute('readonly', 'readonly')->label('Trade Type')->value($qualification->trade_type_name); ?>

                            <?php if($qualification->can_be_approved): ?>
                                <div class="form-group">
                                    <label for="is_approved" class="control-label col-lg-4 col-sm-4">Is Approved</label>
                                    <div class="col-lg-8 col-sm-8">
                                        <div class="checkbox">
                                            <?php if($qualification->is_approved): ?>
                                                <input class="js-switch-primary" id="is_approved" type="checkbox"
                                                       name="is_approved" checked>
                                            <?php else: ?>
                                                <input class="js-switch-primary" id="is_approved" type="checkbox"
                                                       name="is_approved">
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div><!-- /.row -->
                </div><!-- /.form-horizontal -->
            </div>
        </div><!-- /.hpanel -->

        <div class="hpanel">
            <div class="panel-body">
                <a href="<?php echo e(route('qualifications.index')); ?>" class="btn btn-default">Cancel</a>
                <button class="btn btn-success">Save Changes</button>
                <a href="<?php echo e(route('qualifications.archive', $qualification->id)); ?>" class="btn btn-danger pull-right">Archive</a>
            </div>
        </div><!-- /.hpanel -->
        <?php echo Former::close(); ?>


    </div><!-- /.content -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        /* Switchery Toggles */
        var js_switch_primary = Array.prototype.slice.call(document.querySelectorAll('.js-switch-primary'));

        js_switch_primary.forEach(function (html) {
          new Switchery(html, {
            color: '#3498db',
            size: 'small'
          }).enable();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>