<?php $__env->startSection('javascript'); ?>


    <!-- Datatables -->
    <script>
        function showLoading(name) {
            $('.file-name').text(name);
            $('.lead').show();
        }

        function hideLoading() {
            $('.lead').hide();
            $('.file-name').text('');
        }

        $(document).ready(function(){
            $('label[for="csv[]"]').hide();

            $('#table-courses').DataTable({
                //dom: '<"html5buttons"B>lTfgitp',
                dom: '<"html5buttons"B>fgitp',
                bPaginate: true,
                "columnDefs": [
                    { "orderable": false, "targets": [2,3] }
                ],
                "aaSorting": [],
                buttons: [
                    {extend: 'copy'},
                    {extend: 'csv'},
                    {extend: 'excel', title: 'ExampleFile'},
                    {extend: 'pdf', title: 'ExampleFile'},

                    {extend: 'print',
                        customize: function (win){
                            $(win.document.body).addClass('white-bg');
                            $(win.document.body).css('font-size', '10px');

                            $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                        }
                    }
                ]
            });

            $('#upload-csv').click(function (e) {
                e.preventDefault();
                $('.upload').click()
            });

            $('.upload').on('change', function () {
                var file = this.files[0];
                var oData = new FormData();
                oData.append('csv', file);

                if (!file.type.match(/.*csv.*/)) {
                    swal('Only csv file can be uploaded');
                    return;
                }

                showLoading(file.name);

                $.ajax({
                    headers: {'X-CSRF-Token': "<?php echo e(csrf_token()); ?>"},
                    url: '/course-csv',
                    type: 'POST',
                    data: oData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (msg) {
                        console.log(msg);
                        hideLoading();
                        swal({
                            type: 'success',
                            title: 'Success',
                            text: 'Successfully imported course csv file'
                        });
                    },
                    error: function (msg) {
                        hideLoading();
                        swal({
                            type: 'error',
                            title: 'Error',
                            text: 'Failed to import csv file, please make sure the csv is in the right format.'
                        });
                    }
                })
            })
        });

    </script>

    <!-- /.switchery -->
    <script>
        /* Switchery Toggles */
        var js_switch_primary = document.querySelectorAll('.js-switch-primary');
        js_switch_primary.forEach(function(html) {
            var switchery = new Switchery(html, {
                color: '#3498db',
                size: 'small'
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-12 col-md-8 col-lg-9">
                        <h2 class="font-light m-b-xs">
                            Course Management
                        </h2>
                    </div>
                    <div class="col-sm-12 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('courses.create')); ?>" class="btn btn-success btn-block form-btn-no-label"><i class="fa fa-plus"></i> New Course</a>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>
    </div>

    <div class="content">

        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-lg-6">
                        <p><strong>Bulk Import</strong></p>
                        <p>
                            Please upload the csv file of courses to be added.
                            <a href="/course-template">Download template CSV</a>
                            <strong><i class="fa fa-bars"></i></strong>
                            <a href="/course-ids">Download provider and category ids CSV</a>
                        </p>

                        <div class="form-group form-group-file-box">
                            <div class="row">
                                <div class="col-lg-4">
                                    <button id="upload-csv" class="btn btn-block btn-info"><i class="fa fa-cloud-upload"></i> Select File</button>
                                    <?php echo Former::files('csv')->accept('csv')->addClass('hidden upload'); ?>

                                </div>
                                <div class="col-lg-8">
                                    <p class="truncate file-name"></p>
                                </div>
                            </div><!-- /.row -->
                            <p class="lead hidden">Uploading...</p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <p><strong>Category Management</strong></p>
                        <p>Manage and edit categories.</p>
                        <div class="hpanel hpanel-sm">
                            <div class="panel-body">
                                <a href="<?php echo e(route('categories.index')); ?>" class="btn btn-default">Edit Categories</a>
                                <a href="<?php echo e(route('providers.index')); ?>" class="btn btn-default">Edit Providers</a>
                            </div>
                        </div>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>

        <div class="hpanel">
            <div class="panel-body">

                <div class="table-responsive">
                    <table id="table-courses" class="table table-striped table-bordered table-hover" >
                        <thead>
                        <tr>
                            <th>Title</th>
                            <th>Category</th>
                            
                            <th>Requests</th>
                            <th>Visible</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                            <tr>
                                <td><?php echo e($course->name); ?></td>
                                <td><?php echo e($course->category->name); ?></td>
                                
                                    
                                
                                <th>
                                    <?php echo e(count($course->users)); ?>

                                </th>
                                <th>
                                    <input type="checkbox" class="js-switch-primary" checked />
                                </th>
                                <td>
                                    <a href="<?php echo e(route('courses.edit', [$course->id])); ?>" class="btn btn-info btn-block btn-sm">Edit</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

                        </tbody>
                    </table>

                </div><!-- /.table-responsive -->

            </div>
        </div><!-- /.hpanel -->

    </div><!-- /.content -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>