<?php $__env->startSection('javascript'); ?>

    <!-- Datatables -->
    <script>

        $(document).ready(function(){
            $('#table-providers').DataTable({
                //dom: '<"html5buttons"B>lTfgitp',
                dom: '<"html5buttons"B>fgitp',
                bPaginate: true,
                "columnDefs": [
                    { "orderable": false, "targets": [1,2,4,5,9] }
                ],
                "aaSorting": []
            });
        });

    </script>

    <!-- /.switchery -->
    <script>
        /* Switchery Toggles */
        var js_switch_primary = document.querySelectorAll('.js-switch-primary');
        js_switch_primary.forEach(function(html) {
            var switchery = new Switchery(html, {
                color: '#3498db',
                size: 'small'
            });
        });
    </script>

    <!--  Sweet Alert-->
    <script src="/vendor/sweetalert/lib/sweet-alert.min.js"></script>
    <script>
        $('.delete-provider').click(function (e) {
            e.preventDefault();
            swal({
                title: 'Confirm',
                text: "Please confirm you want to delete this provider",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'rgb(168, 67, 23)',
                confirmButtonText: 'Yes, delete it!',
                showLoaderOnConfirm: true

            }, function () {
                $.ajax({
                    url: e.target.href,
                    type: 'delete',
                    data: {_token: '<?php echo e(csrf_token()); ?>'},
                    success: function () {
                        swal({
                            title: 'Deleted!',
                            text: "Provider successfully deleted",
                            type: 'success',
                            confirmButtonColor: 'rgb(120, 182, 211)',
                            confirmButtonText: 'OK'
                        }, function () {
                            window.location = "<?php echo e(route('providers.index')); ?>"
                        });
                    }
                })

            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-12 col-md-8 col-lg-9">
                        <h2 class="font-light m-b-xs">
                            Course Providers
                        </h2>
                    </div>
                    <div class="col-sm-12 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('providers.create')); ?>" class="btn btn-success btn-block form-btn-no-label"><i class="fa fa-plus"></i> New Provider</a>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>
    </div>



    <div class="content">

        <div class="hpanel">
            <div class="panel-body">

                <div class="table-responsive">
                    <table id="table-providers" class="table table-striped table-bordered table-hover" >
                        <thead>
                        <tr>
                            <th>Contact Name</th>
                            <th>Contact Phone</th>
                            <th>Contact Email</th>
                            <th>Company</th>
                            <th>Address Line 1</th>
                            <th>Address Line 2</th>
                            <th>City</th>
                            <th>Postcode</th>
                            <th>State</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $providers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $provider): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                            <tr>
                                <td><?php echo e($provider->contact_name); ?></td>
                                <td><?php echo e($provider->contact_phone); ?></td>
                                <td><?php echo e($provider->contact_email); ?></td>
                                <td><?php echo e($provider->company); ?></td>
                                <td><?php echo e($provider->address_line_1); ?></td>
                                <td><?php echo e($provider->address_line_2); ?></td>
                                <td><?php echo e($provider->city); ?></td>
                                <td><?php echo e($provider->postcode); ?></td>
                                <td><?php echo e($provider->state); ?></td>
                                <td>
                                    <a href="<?php echo e(route('providers.edit', [$provider->id])); ?>" class="btn btn-primary btn-sm alert-category-edit">Edit</a>
                                    <a href="<?php echo e(route('providers.destroy', [$provider->id])); ?>" class="btn btn-danger btn-sm alert-category-delete delete-provider">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

                        </tbody>
                    </table>

                </div><!-- /.table-responsive -->

            </div>
        </div><!-- /.hpanel -->

    </div><!-- /.content -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>