<!DOCTYPE html>
<html lang="en">
<head>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title>toStartWork</title>

    <!-- Favicon and iOS Home Screen -->
    <link rel="shortcut icon" href="/favicon.ico"/>
    <link rel="apple-touch-icon-precomposed" href="apple-touch-icon.png"/>

    <!-- Site Styles -->
    <link href="//netdna.bootstrapcdn.com/font-awesome/4.6.3/css/font-awesome.min.css" rel="stylesheet"/>
    <link rel="stylesheet" href="/vendor/metisMenu/dist/metisMenu.css"/>
    <link rel="stylesheet" href="/vendor/animate.css/animate.css"/>
    <link rel="stylesheet" href="/vendor/select2/select2.min.css"/>
    <link rel="stylesheet" href="/vendor/select2-bootstrap/select2-bootstrap.css"/>
    <link rel="stylesheet" href="/vendor/redactor/redactor.css"/>
    <link rel="stylesheet" href="/vendor/sweetalert/lib/sweet-alert.css"/>
    <link rel="stylesheet" href="/vendor/bootstrap/dist/css/bootstrap.css"/>
    <link rel="stylesheet" href="/vendor/switchery/switchery.css" rel="stylesheet"/>
    <link rel="stylesheet" href="/vendor/datatables/media/css/dataTables.bootstrap.min.css"/>


    <!-- App styles -->
    <link rel="stylesheet" href="/fonts/pe-icon-7-stroke/css/pe-icon-7-stroke.css"/>
    <link rel="stylesheet" href="/fonts/pe-icon-7-stroke/css/helper.css"/>
    <link rel="stylesheet" href="/css/style.css"/>
    <link rel="stylesheet" href="/tsw.css"/>

</head>
<body class="fixed-navbar fixed-sidebar">

<div id="header">

    <div class="color-line"></div>

    <div id="logo" class="light-version">
        <img src="/img/logo-320.png" alt="To Start Work"/>
    </div><!-- /#logo -->

    <nav role="navigation">

        <div class="header-link hide-menu"><i class="fa fa-bars"></i></div>

        <div class="small-logo">
            <img src="/img/logo-320.png" alt="To Start Work"/>
        </div>

        <div class="mobile-menu">
            <button type="button" class="navbar-toggle mobile-menu-toggle" data-toggle="collapse"
                    data-target="#mobile-collapse">
                <i class="fa fa-chevron-down"></i>
            </button>
            <div class="collapse mobile-navbar" id="mobile-collapse">
                <ul class="nav navbar-nav">
                    <li>
                        <a href="<?php echo e(url('/logout')); ?>"
                           onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                            Logout
                        </a>

                        <form id="logout-form" action="<?php echo e(url('/logout')); ?>" method="POST" style="display: none;">
                            <?php echo e(csrf_field()); ?>

                        </form>
                    </li>
                </ul>
            </div>
        </div>
        <div class="navbar-right">
            <ul class="nav navbar-nav no-borders">
                <li class="dropdown">
                    <a href="<?php echo e(url('/logout')); ?>"
                       onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();">
                        <i class="pe-7s-upload pe-rotate-90"></i>
                    </a>

                    <form id="logout-form" action="<?php echo e(url('/logout')); ?>" method="POST" style="display: none;">
                        <?php echo e(csrf_field()); ?>

                    </form>

                </li>
            </ul>
        </div>
    </nav>

</div><!-- /#header -->

<aside id="menu">
    <div id="navigation">
        <ul class="nav" id="side-menu">
            <li class="<?php echo e(app('menu')->isActiveRoute('//')); ?>"><a href="/"><span class="nav-label">Dashboard</span></a></li>
            <li class="<?php echo e(app('menu')->isActiveRoute('notifications')); ?>"><a href="/notifications"><span class="nav-label">Push Notifications</span></a></li>
            <li class="<?php echo e(app('menu')->isActiveRoute('courses')); ?>"><a href="/courses"><span class="nav-label">Course Management</span></a></li>
            <li class="<?php echo e(app('menu')->isActiveRoute('users')); ?>"><a href="/users"><span class="nav-label">User Management</span></a></li>
            <li class="<?php echo e(app('menu')->isActiveRoute('qualifications')); ?>">
                <a href="/qualifications">
                    <span class="nav-label"> Qualification Management</span> <span id="qmn" class="hidden label label-danger"></span>
                </a>
            </li>
        </ul>
    </div>
</aside><!-- /#menu -->
<!-- Main Wrapper -->
<div id="wrapper">


    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer-->
    <footer class="footer">
		<span class="pull-right">
			&copy; toStartWork <?php echo e(date('Y')); ?>

		</span>
    </footer>

</div><!-- /#wrapper -->

<!-- Vendor scripts -->
<script src="/vendor/jquery/dist/jquery.min.js"></script>
<script src="/vendor/jquery-ui/jquery-ui.min.js"></script>
<script src="/vendor/bootstrap/dist/js/bootstrap.min.js"></script>
<script src="/vendor/jquery-flot/jquery.flot.js"></script>
<script src="/vendor/jquery-flot/jquery.flot.resize.js"></script>
<script src="/vendor/jquery-flot/jquery.flot.pie.js"></script>
<script src="/vendor/flot.curvedlines/curvedLines.js"></script>
<script src="/vendor/jquery.flot.spline/index.js"></script>
<script src="/vendor/metisMenu/dist/metisMenu.min.js"></script>
<script src="/vendor/iCheck/icheck.min.js"></script>
<script src="/vendor/select2/select2.min.js"></script>
<script src="/vendor/datatables/media/js/jquery.dataTables.min.js"></script>
<script src="/vendor/datatables/media/js/dataTables.bootstrap.min.js"></script>
<script src="/vendor/bootstrap-notify-3.1.3/dist/bootstrap-notify.min.js"></script>
<script src="/vendor/switchery/switchery.js"></script>
<script src="/vendor/sweetalert/lib/sweet-alert.js"></script>

<!-- App scripts -->
<script src="/js/homer.js"></script>

<!-- Select2 -->
<script>
    $(document).ready(function () {
        $(".select2").select2();
        $(".select2tags").select2({
            tags: true
        });

        var qmn = $('#qmn');

        $.ajax({
            headers: {'X-CSRF-Token': "<?php echo e(csrf_token()); ?>"},
            url: '/num-of-unapproved-qualifications',
            type: 'GET',
            success: function (num) {
                qmn.text(num);
                qmn.removeClass('hidden');
            },
            error: function (msg) {
                qmn.hide();
            }
        });
    });
</script>

<script>
    <?php if(session('status')): ?>
       $.notify( {
        message: "<?php echo e(session('status')); ?>"
    }, {
        placement: {
            from: "bottom",
            align: "right"
        }
    });
    <?php endif; ?>
</script>

<?php echo $__env->yieldContent('javascript'); ?>


<!-- Sweet Alert -->
<!-- <script src="vendor/sweetalert/lib/sweet-alert.min.js"></script>
<script>
    $('.alert-discussion-updated').click(function () {
        swal({
            title: 'Discussion Updated.',
            text: "Please ensure any changes are reflected in your conclusion",
            type: 'warning',
            showCancelButton: false,
            confirmButtonColor: '#8199C5',
            confirmButtonText: 'Continue'
        }).then(function() {
            swal(
                'Withdrawn!',
                'Your endorsement has been withdrawn.',
                'success'
                )
        })
    });
</script> -->

</body>
</html>
