<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::post('/user/signup', ['uses' => 'Api\UserController@store']);
Route::post('/user/signin', ['uses' => 'Api\Auth\LoginController@authenticate']);
Route::post('/user/social/signin', ['uses' => 'Api\Auth\LoginController@socialAuthenticate']);

Route::group(['middleware' => ['jwt.auth']], function() {
    Route::get('/qualification/list/types', ['uses' => 'Api\QualificationTypeController@index']);
    Route::get('/qualification/list/tradetypes', ['uses' => 'Api\QualificationTradeTypeController@index']);
    Route::get('/qualification/list/categories', ['uses' => 'Api\QualificationController@index']);
    Route::post('/qualification/list/categories/add', ['uses' => 'Api\QualificationController@store']);

    Route::get('/qualification/list', ['uses' => 'Api\QualificationUserController@index']);
    Route::post('/qualification/add', ['uses' => 'Api\QualificationUserController@store']);
    Route::post('/qualification/send', ['uses' => 'Api\QualificationPdfController@downloadPdf']);
    Route::post('/qualification/{qualificationId}/update', ['uses' => 'Api\QualificationUserController@update']);
    Route::post('/qualification/{qualificationId}/remove', ['uses' => 'Api\QualificationUserController@destroy']);

    Route::post('qualification/{qualificationId}/image/update/front', ['uses' => 'Api\QualificationUserFrontImageController@store']);
    Route::get('qualification/{qualificationId}/image/front', ['uses' => 'Api\QualificationUserFrontImageController@show']);
    Route::post('qualification/{qualificationId}/image/update/back', ['uses' => 'Api\QualificationUserBackImageController@store']);
    Route::get('qualification/{qualificationId}/image/back', ['uses' => 'Api\QualificationUserBackImageController@show']);

    Route::get('/course/list', ['uses' => 'Api\CourseController@index']);
    Route::post('/course/apply', ['uses' => 'Api\CourseUserController@store']);

    Route::get('/notification/list', ['uses' => 'Api\NotificationController@index']);
    Route::post('/notification/delete', ['uses' => 'Api\NotificationController@destroy']);

    Route::post('/user/profile/update', ['uses' => 'Api\UserProfileController@update']);
    Route::post('/user/profile/image/update', ['uses' => 'Api\UserProfileImageController@store']);
    Route::post('/user/update', ['uses' => 'Api\UserController@update']);

    Route::get('/poster/image', ['uses' => 'Api\PosterController@getImage']);
});





Route::get('/user', function (Request $request) {
    return $request->user();

})->middleware('auth:api');
