<?php

namespace ToStartWork;

use Davibennun\LaravelPushNotification\Facades\PushNotification;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Support\Facades\Hash;
use ToStartWork\Helpers\Misc;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /*public function setPasswordAttribute($pass) {
        $this->attributes['password'] = Hash::make($pass);
    }*/

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function courses()
    {
        return $this->belongsToMany(Course::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function contacts()
    {
        return $this->hasMany(Contact::class);
    }


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function employment()
    {
        return $this->hasMany(Employment::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function qualifications()
    {
        return $this->BelongsToMany(Qualification::class);
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function trades()
    {
        return $this->BelongsToMany(
            QualificationTradeType::class, 'trade_user', 'user_id', 'qualification_trade_types_id'
        );
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsToMany
     */
    public function notifications()
    {
        return $this->BelongsToMany(Notification::class);
    }

    static function createFromGoogle($socialData)
    {
        return self::create([
            'email' => $socialData['email'],
            'google_token' => $socialData['token'],
            'username' => $socialData['user_name'],
            'user_image_url' => $socialData['user_image_url'],
        ]);
    }

    static function createFromFacebook($socialData)
    {
        return self::create([
            'email' => $socialData['email'],
            'facebook_token' => $socialData['token'],
            'username' => $socialData['user_name'],
            'user_image_url' => $socialData['user_image_url'],
        ]);
    }

    public function resetPassword($newPassword)
    {
        $this->password = bcrypt($newPassword);
        $this->save();
    }

    public function getNameAttribute()
    {
        return sprintf('%s %s', $this->first_name, $this->last_name);
    }

    public function getContactPhoneNoAttribute($value)
    {
        return Misc::formatPhone($value);
    }

    public function getIsSetupAttribute($value)
    {
        return (boolean)$value;
    }

    /**
     * @return array
     */
    static function getRegisteredMobileDevices()
    {
        $devices = [];

        return self::whereNotNull('ios_device_token')->get();
    }
}
