<?php

namespace ToStartWork;

use Carbon\Carbon;
use Davibennun\LaravelPushNotification\Facades\PushNotification;
use Illuminate\Database\Eloquent\Model;
use ToStartWork\Events\SendPushNotification;

class Notification extends Model
{

    public $guarded = [];

    public $timestamps = true;

    public $dates = ['sent'];

    /**
     * @return array
     */
    public function devices() {
        return User::getRegisteredMobileDevices();
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function user() {
        return $this->belongsToMany(User::class);
    }

    /**
     * Show only sent notifications
     *
     * @param $query
     * @return mixed
     */
    public function scopeSent($query) {
        return $query->whereStatus('sent');
    }

    /**
     * Show only draft notifications
     *
     * @param $query
     * @return mixed
     */
    public function scopeDraft($query) {
        return $query->whereStatus('draft');
    }

    /**
     * Send push notification to registered devices
     */
    public function send() {
        $devices = [];

        foreach ($this->devices() as $user) {
            $devices[] = PushNotification::Device($user->ios_device_token);
        }

        event(new SendPushNotification($this, $devices));

        foreach ($this->devices() as $user) {
            $user->notifications()->attach($this->id);
        }

        $this->sent = Carbon::now();
        $this->status = "sent";
        $this->save();
    }
    
}
