<?php

namespace ToStartWork\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class QualificationPdfGenerated extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * @var
     */
    private $pdf;
    /**
     * @var
     */
    private $receiver;
    /**
     * @var
     */
    private $user;

    /**
     * Create a new message instance.
     * @param $pdf
     * @param $receiver
     * @param $user
     */
    public function __construct($pdf, $receiver, $user)
    {
        $this->pdf = $pdf;
        $this->receiver = $receiver;
        $this->user = $user;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $userName = array_get($this->receiver, 'full_name') ? $this->receiver['full_name'] : trim($this->user->name);

        $subject = $userName ? 'Qualifications for ' . $userName : 'Qualifications';

        return $this->from('admin@tostartwork.com', 'toStartWork')
            ->subject($subject)
            ->view('emails.user_qualification_generated', ['receiver' => $this->receiver, 'userName' => $userName])
            ->attachData($this->pdf, 'qualification.pdf', [
                'mime' => 'application/pdf',
            ]);
    }
}
