<?php

namespace ToStartWork\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use ToStartWork\Qualification;

class QualificationCreated extends Mailable
{
    use Queueable, SerializesModels;
    /**
     * @var Qualification
     */
    private $qualification;

    /**
     * Create a new message instance.
     *
     * @param Qualification $qualification
     */
    public function __construct(Qualification $qualification)
    {
        $this->qualification = $qualification;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->view('emails.user_qualification_created')->with(['qualification' => $this->qualification]);
    }
}
