<?php

namespace ToStartWork\Listeners;

use Davibennun\LaravelPushNotification\Facades\PushNotification;
use Illuminate\Support\Facades\Mail;
use ToStartWork\Events\SendPushNotification;
use ToStartWork\Events\UserAppliedToCourse;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use ToStartWork\Mail\UserAppliedToCourse as UserAppliedToCourseMail;

class SendNotificationToUsers implements ShouldQueue
{


    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  UserAppliedToCourse  $event
     * @return void
     */
    public function handle(SendPushNotification $event)
    {
        $message = PushNotification::Message($event->notification->title, [
            'content-available' => 1,
            'badge' => 1,
            'custom' => [
                'custom-data' => [
                    'notification_id' => $event->notification->id
                ]
            ]
        ]);

        PushNotification::app('ToStartWorkIOS')
            ->to(PushNotification::DeviceCollection($event->devices))
            ->send($message);
    }
}
