<?php

namespace ToStartWork\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;


use ToStartWork\Http\Requests\Admin\UserManagement\StoreUserRequest;
use ToStartWork\Http\Requests\Admin\UserManagement\UpdateUserRequest;

use ToStartWork\Notification;
use ToStartWork\User;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     */
    public function index()
    {
        $users = User::orderBy('is_admin', 'desc')->orderBy('last_name', 'asc')->get();

        return view('user/index')->with('users', $users);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('user/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request|StoreUserRequest $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreUserRequest $request)
    {
        User::create(
            $request->only(['first_name', 'last_name', 'email']) + ['password' => bcrypt($request->get('password'))]
        );

        return Redirect::route('users.index')->with('status', 'Created User');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param User $user
     * @internal param Notification $notification
     * @internal param int $id
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function edit(User $user)
    {
        return view('user.edit')->with('user', $user);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request|UpdateUserRequest $request
     * @param User $user
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function update(UpdateUserRequest $request, User $user)
    {
        $user->update($request->only(['first_name', 'last_name', 'email']));
        $user->update(['active' => (boolean)$request->input('active', '')]);
        $user->update(['is_admin' => (boolean)$request->input('is_admin', '')]);

        if ($request->has('password') && strlen($request->get('password'))) {
            $user->resetPassword($request->get('password'));
        }

        return Redirect::route('users.edit', $user->id)->with('status', 'Updated User');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
