<?php

namespace ToStartWork\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;


use ToStartWork\CourseProvider;
use ToStartWork\Http\Requests\Admin\ProviderManagement\StoreProviderRequest;
use ToStartWork\Http\Requests\Admin\ProviderManagement\UpdateProviderRequest;

use ToStartWork\Notification;
use ToStartWork\User;
use ToStartWork\Course;

class ProviderController extends Controller
{
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index()
	{
		$providers = CourseProvider::orderBy('contact_name', 'asc')->get();

		return view('providers/index', compact('providers'));
	}

	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create()
	{
		$stateOptions = [
			'SA' => 'SA',
			'NSW' => 'NSW',
			'VIC' => 'VIC',
			'NT' => 'NT',
			'WA' => 'WA',
			'QLD' => 'QLD',
			'TAS' => 'TAS'
		];

		return view('providers/create', compact('stateOptions'));
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param StoreProviderRequest $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(StoreProviderRequest $request)
	{
		CourseProvider::create($request->except('_token'));

		return Redirect::route('providers.index')->with('status', 'Created Provider');
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param CourseProvider $courseProvider
	 * @return \Illuminate\Http\Response
	 * @internal param Notification $notification
	 * @internal param int $id
	 */
	public function edit(CourseProvider $courseProvider)
	{
		$stateOptions = [
			'SA' => 'SA',
			'NSW' => 'NSW',
			'VIC' => 'VIC',
			'NT' => 'NT',
			'WA' => 'WA',
			'QLD' => 'QLD',
			'TAS' => 'TAS'
		];

		return view('providers.edit', compact('courseProvider', 'stateOptions'));
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param UpdateProviderRequest $request
	 * @param CourseProvider $courseProvider
	 * @return \Illuminate\Http\Response
	 * @internal param int $id
	 */
	public function update(UpdateProviderRequest $request, CourseProvider $courseProvider)
	{
		$courseProvider->update($request->except('_token'));

		return Redirect::route('providers.index')->with('status', 'Updated Course');
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy(Course $course)
	{
		dd('something', $course);
	}
}
