<?php

namespace ToStartWork\Http\Controllers;

use Carbon\Carbon;
use Davibennun\LaravelPushNotification\Facades\PushNotification;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;
use ToStartWork\Events\SendPushNotification;
use ToStartWork\Http\Requests\Admin\Notification\StoreNotificationRequest;
use ToStartWork\Http\Requests\Admin\Notification\UpdateNotificationRequest;
use ToStartWork\Notification;
use ToStartWork\User;

class NotificationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $notifications = Notification::orderBy('created_at', 'desc')->get();

        return view('notification/index')
            ->with('notifications', $notifications);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('notification/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreNotificationRequest $request)
    {
        $notification = Notification::create($request->only(['title', 'subtitle', 'content', 'status']));

        if ($request->send == true) {
            $notification->send();
            return Redirect::route('notifications.index')->with('status', 'Notification queued to be sent');
        }

        return Redirect::route('notifications.index')->with('status', 'Created Draft Notification');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Notification $notification
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function edit(Notification $notification)
    {
        return view('notification.edit')
            ->with('notification', $notification);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Request|UpdateNotificationRequest $request
     * @param Notification $notification
     * @return \Illuminate\Http\Response
     * @internal param int $id
     */
    public function update(UpdateNotificationRequest $request, Notification $notification)
    {
        $notification->update($request->only(['title', 'subtitle', 'content']));

        if ($request->send == true) {
            $notification->send();
        }

        return Redirect::route('notifications.index')->with('status', 'Updated Notification');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
