<?php

namespace ToStartWork\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redirect;


use ToStartWork\CourseCategory;
use ToStartWork\CourseProvider;
use ToStartWork\Http\Requests\Admin\CourseManagement\StoreCourseRequest;
use ToStartWork\Http\Requests\Admin\CourseManagement\UpdateCourseRequest;
use ToStartWork\Http\Requests\Admin\UserManagement\StoreUserRequest;
use ToStartWork\Http\Requests\Admin\UserManagement\UpdateUserRequest;

use ToStartWork\Notification;
use ToStartWork\User;
use ToStartWork\Course;
use Nitmedia\Wkhtml2pdf\Facades\Wkhtml2pdf as PDF;

class CategoryController extends Controller
{
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index()
	{
		$categories = CourseCategory::orderBy('name', 'asc')->get();

		return view('categories/index', compact('categories' ));
	}

	public function downloadPdf(Request $request)
	{


		PDF::setOrientation('portrait');
		PDF::setOutputMode('S');
//		PDF::setOptions("-B 0 -L 0 -R 0 -T 0 --disable-javascript --page-size A4");
		PDF::setOptions("--javascript-delay 1000 --no-stop-slow-scripts --debug-javascript --enable-smart-shrinking -B 0 -L 0 -R 0 -T 0");

//		return view('pdf.cover');
		$cover = response(PDF::html("pdf.cover", compact('data'), 'pdf report'), 200)
			->header('Content-Type', 'application/pdf')
			->header('Content-Disposition', 'attachment; filename="induction.pdf"')
		;

//		return view('pdf.main');
		$pdf = response(PDF::html("pdf.main", compact('data'), 'pdf report'), 200)
			->header('Content-Type', 'application/pdf')
			->header('Content-Disposition', 'attachment; filename="induction.pdf"')
		;

		return $pdf;

	}
	/**
	 * Show the form for creating a new resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function create()
	{
		$providerOptions = CourseProvider::orderBy('contact_name', 'desc')->get()->pluck('contact_name', 'id');
		$categoryOptions = CourseCategory::orderBy('name', 'desc')->get()->pluck('name', 'id');

		return view('categories/create', compact('providerOptions', 'categoryOptions'));
	}

	/**
	 * Store a newly created resource in storage.
	 *
	 * @param  \Illuminate\Http\Request  $request
	 * @return \Illuminate\Http\Response
	 */
	public function store(StoreCourseRequest $request)
	{
		CourseCategory::create($request->except('_token'));

		return Redirect::route('categories.index')->with('status', 'Created Category');
	}

	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param Course $course
	 * @return \Illuminate\Http\Response
	 * @internal param Notification $notification
	 * @internal param int $id
	 */
	public function edit(CourseCategory $courseCategory)
	{
		$providerOptions = CourseProvider::orderBy('contact_name', 'desc')->get()->pluck('contact_name', 'id');
		$categoryOptions = CourseCategory::orderBy('name', 'desc')->get()->pluck('name', 'id');

		return view('categories.edit', compact('course', 'providerOptions', 'categoryOptions'));
	}

	/**
	 * Update the specified resource in storage.
	 *
	 * @param Request|UpdateCourseRequest $request
	 * @param CourseCategory $courseCategory
	 * @return \Illuminate\Http\Response
	 * @internal param Course $course
	 * @internal param int $id
	 */
	public function update(Request $request, CourseCategory $courseCategory)
	{
		$courseCategory->update($request->except('_token'));

//		return Redirect::route('categories.index')->with('status', 'Updated Category');
	}

	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return \Illuminate\Http\Response
	 */
	public function destroy(Course $course)
	{
		dd('something', $course);
	}
}
