<?php

namespace ToStartWork\Http\Controllers\Api;

use Auth;
use Illuminate\Http\Request;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserStoreQualificationBackImage;

class QualificationUserBackImageController extends Controller
{
    /**
     * Show image for qualification
     *
     * @param $qualificationId
     * @return \Symfony\Component\HttpFoundation\BinaryFileResponse
     */
    public function show($qualificationId)
    {
        $qualification = Auth::user()->qualifications()->wherePivot('qualification_id', $qualificationId)->withPivot(['back_image'])->first();

        return response()->download(storage_path('app/'.$qualification->pivot->back_image));
    }

    /**
     * @param $qualificationId
     * @param UserStoreQualificationFrontImage $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function store($qualificationId, UserStoreQualificationBackImage $request)
    {
        $path = $request->file('back_image')->store('uploads');

        Auth::user()->qualifications()->updateExistingPivot($qualificationId, ['back_image' => $path]);

        return response()->json(['back_image' => $path]);
    }
}
