<?php

namespace ToStartWork\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\QualificationListRequest;
use ToStartWork\Http\Requests\UserRemoveQualificationRequest;
use ToStartWork\Http\Requests\UserStoreQualificationCategoryRequest;
use ToStartWork\Http\Requests\UserUpdateQualificationRequest;
use ToStartWork\Mail\QualificationCreated;
use ToStartWork\Qualification;

class QualificationController extends Controller
{
    /**
     * @param QualificationListRequest $request
     * @return \Illuminate\Database\Eloquent\Collection|static[]
     */
    public function index(QualificationListRequest $request)
    {
        $user = Auth::user();

        $qualifications = Qualification::query();

        $qualifications->where(function ($query) use ($user) {
            return $query->where('is_approved', true)->orWhere('user_id', $user->id);
        });

        if ($request->has('trade_type_id')) {
            $qualifications->where('trade_type_id', $request->get('trade_type_id'));
        }

        if ($request->has('type_id')) {
            $typeId = $request->get('type_id');

            if ($typeId > 0) {
                $qualifications->where('type_id', $typeId);
            }
        }

        return $qualifications->get();
    }

    public function store(UserStoreQualificationCategoryRequest $request)
    {
        $user = Auth::user();

        $qualification = Qualification::create([
            'type_id' => $request->input('type_id'),
            'trade_type_id' => $request->input('trade_type_id'),
            'name' => $request->input('name'),
            'user_id' => $user->id,
        ]);

        \Mail::to(env('ADMIN_EMAIL', 'nick@codium.com.au'))->send(new QualificationCreated($qualification));

        return response()->json(['qualification' => $qualification]);
    }
}
