<?php

namespace ToStartWork\Http\Controllers\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use ToStartWork\Course;
use ToStartWork\Http\Controllers\Controller;
use ToStartWork\Http\Requests\UserDeleteNotificationRequest;
use ToStartWork\Notification;

class NotificationController extends Controller
{

    /**
     * User notifications
     * Each notification is linked to users when sent, users can delete there own relation to this notification
     *
     * @return mixed
     */
    public function index()
    {
        return  \Auth::user()->notifications()->orderBy('sent')->get();
    }

    /**
     * User deleting a notification from there inbox
     *
     * @param UserDeleteNotificationRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy(UserDeleteNotificationRequest $request)
    {
        \Auth::user()->notifications()->detach($request->get('id'));

        return response()->json([]);
    }
}
