<?php

namespace ToStartWork;

use Illuminate\Database\Eloquent\Model;
use ToStartWork\Events\UserAppliedToCourse;

class Course extends Model
{
    public $guarded = [];

    public $timestamps = false;

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function category()
    {
        return $this->belongsTo(CourseCategory::class, 'category_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function courseProvider()
    {
        return $this->belongsTo(CourseProvider::class, 'provider_id', 'id');
    }

    public function users()
    {
        return $this->belongsToMany(User::class);
    }

    /**
     * A user can apply to attend a course
     *
     * @param User $user
     */
    public function apply(User $user)
    {
        $this->users()->attach($user->id);

        event(new UserAppliedToCourse($this, $user));
    }
}
