<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 3,
  'name' => 'Sermon',
  'slug' => 'sermon',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 4,
  'name' => 'Sermon',
  'slug' => 'sermon',
  'term_group' => 0,
  'taxonomy' => 'tribe_events_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 2,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 136,
  'post_date' => '2019-05-25 18:35:30',
  'post_date_gmt' => '2019-05-25 18:35:30',
  'post_content' => '<!-- wp:paragraph -->
<p>

&nbsp;Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.<a href="javascript:void(0);"></a><br></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'This Week\'s Sermon Series: ReThinking Outreach',
  'post_excerpt' => '',
  'post_name' => 'rethinking-outreach',
  'post_modified' => '2019-05-28 21:20:27',
  'post_modified_gmt' => '2019-05-28 21:20:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=136',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'lightbox_link' => 'https://www.youtube.com/watch?v=sP5mepLMSTc',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sermon',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-church/files/2019/05/old-church-in-praire.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 125,
  'post_date' => '2019-05-24 18:28:41',
  'post_date_gmt' => '2019-05-24 18:28:41',
  'post_content' => '<!-- wp:paragraph -->
<p>At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.<a href="javascript:void(0);"></a><br></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'The Prodigal God by Tim Keller',
  'post_excerpt' => '',
  'post_name' => 'the-prodigal-god-by-tim-keller',
  'post_modified' => '2019-05-29 05:20:28',
  'post_modified_gmt' => '2019-05-29 05:20:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=125',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'lightbox_link' => 'https://www.youtube.com/watch?v=OasF7lWlX_M',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sermon',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-city.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 142,
  'post_date' => '2019-05-22 18:44:44',
  'post_date_gmt' => '2019-05-22 18:44:44',
  'post_content' => '<!-- wp:paragraph -->
<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<a href="javascript:void(0);"></a><br></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Everybody\'s Somebody by Lucas Cooper',
  'post_excerpt' => '',
  'post_name' => 'voluptatum-deleniti-atque-corrupti-quos-dolores',
  'post_modified' => '2019-05-28 21:22:58',
  'post_modified_gmt' => '2019-05-28 21:22:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=142',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'lightbox_link' => 'https://www.youtube.com/watch?v=1KO8espGH38',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sermon',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-church/files/2019/05/church-in-the-middle-of-lake.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 282,
  'post_date' => '2019-05-21 11:32:04',
  'post_date_gmt' => '2019-05-21 11:32:04',
  'post_content' => '<!-- wp:paragraph -->
<p>Justo curabitur bibendum mauris, condimentum curabitur nibh eu. Eleifend dolor sollicitudin neque sed a, potenti turpis in felis augue natoque, penatibus sit ligula maecenas in, lacus porta quam eget commodo erat eget, porta mattis porta posuere donec rutrum augue. At dui sed est cras montes, nostra turpis iaculis a felis. Tristique ac diam habitasse lobortis. Elementum sodales donec nisl, pede placerat odio massa aenean sociis vel, mauris rutrum justo doloribus nec, nonummy neque et nulla suscipit, libero adipiscing risus. Accumsan scelerisque enim, suspendisse tellus leo magna, etiam ullam pretium rutrum phasellus suspendisse ac, pellentesque sollicitudin sociis erat, vulputate urna sagittis enim in. Id congue sed imperdiet augue, tellus aliquam in suscipit adipiscing tellus semper, neque gravida, nibh porta vitae eu a risus adipiscing, ut a risus libero vestibulum pellentesque. Eget velit suspendisse libero massa congue amet, ornare scelerisque sagittis et a egestas, vel eius lorem scelerisque per. Diam non posuere pellentesque consectetuer, purus class, varius nunc molestiae nisl potenti, ipsum interdum ut vehicula, mauris urna sodales blandit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Nam leo id sapien, diam sodales vitae at natoque velit ut, nibh metus. Ut lorem consectetuer, ante sollicitudin eiusmod mattis non lorem, risus at risus ipsum sit libero, feugiat arcu nec sem ultrices nisl congue, purus vel in. Aenean proin felis arcu, dui vestibulum, semper sit odio varius ornare, nunc viverra quis integer nunc sodales, urna sapien sed. Tincidunt cras arcu curabitur a pellentesque, dignissim suspendisse tellus. Luctus tellus et viverra eget placerat augue, nullam amet eros amet. A erat malesuada cursus eleifend mi non, et platea nec, etiam sit, vehicula vehicula mi in enim dolor pede. Ultricies fermentum faucibus quis, tempus sit suspendisse, erat in pulvinar justo. Urna turpis quam augue a velit vel, quis sit morbi nibh morbi, turpis viverra non erat parturient wisi, elit libero. Mi proin lectus, ligula rutrum odio ut delectus, sapien lacus curae ut et curae lorem, ornare non nec rhoncus curabitur morbi, eu ac eu dui pede aliquam suscipit.<br><br></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'From Atheist to Christian at Yale by Dr. Paul Lim',
  'post_excerpt' => '',
  'post_name' => 'from-atheist-to-christian',
  'post_modified' => '2019-05-28 21:24:29',
  'post_modified_gmt' => '2019-05-28 21:24:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=282',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'lightbox_link' => 'https://www.youtube.com/watch?v=zJ9TfkdgeFc',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sermon',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-church/files/2019/05/candle-blossom.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 285,
  'post_date' => '2019-05-20 11:35:16',
  'post_date_gmt' => '2019-05-20 11:35:16',
  'post_content' => '<!-- wp:paragraph -->
<p>Nam leo id sapien, diam sodales vitae at natoque velit ut, nibh metus. Ut lorem consectetuer, ante sollicitudin eiusmod mattis non lorem, risus at risus ipsum sit libero, feugiat arcu nec sem ultrices nisl congue, purus vel in. Aenean proin felis arcu, dui vestibulum, semper sit odio varius ornare, nunc viverra quis integer nunc sodales, urna sapien sed. Tincidunt cras arcu curabitur a pellentesque, dignissim suspendisse tellus. Luctus tellus et viverra eget placerat augue, nullam amet eros amet. A erat malesuada cursus eleifend mi non, et platea nec, etiam sit, vehicula vehicula mi in enim dolor pede. Ultricies fermentum faucibus quis, tempus sit suspendisse, erat in pulvinar justo. Urna turpis quam augue a velit vel, quis sit morbi nibh morbi, turpis viverra non erat parturient wisi, elit libero. Mi proin lectus, ligula rutrum odio ut delectus, sapien lacus curae ut et curae lorem, ornare non nec rhoncus curabitur morbi, eu ac eu dui pede aliquam suscipit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Praesent duis libero. Wisi bibendum pede, suspendisse erat vestibulum nostra. Nulla varius diam justo quisque in, purus quis elit leo morbi, a fusce elit justo amet bibendum neque, praesent placerat vivamus parturient dui, proin augue aliquam eleifend vivamus mauris libero. Porta felis id id convallis, nisl quis vel nibh, vulputate donec lacus aut. Mi urna mauris luctus eget. Massa nascetur pharetra risus, eros metus proin luctus lorem, elit ultrices, sollicitudin libero sit ipsum voluptate vehicula semper, dolor ac fusce integer lectus adipiscing vestibulum. Scelerisque orci sed risus nulla. Amet laoreet, congue sodales nonummy sem sed dis commodo, ut blandit felis.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph -->
<p>Justo curabitur bibendum mauris, condimentum curabitur nibh eu. Eleifend dolor sollicitudin neque sed a, potenti turpis in felis augue natoque, penatibus sit ligula maecenas in, lacus porta quam eget commodo erat eget, porta mattis porta posuere donec rutrum augue. At dui sed est cras montes, nostra turpis iaculis a felis. Tristique ac diam habitasse lobortis. Elementum sodales donec nisl, pede placerat odio massa aenean sociis vel, mauris rutrum justo doloribus nec, nonummy neque et nulla suscipit, libero adipiscing risus. Accumsan scelerisque enim, suspendisse tellus leo magna, etiam ullam pretium rutrum phasellus suspendisse ac, pellentesque sollicitudin sociis erat, vulputate urna sagittis enim in. Id congue sed imperdiet augue, tellus aliquam in suscipit adipiscing tellus semper, neque gravida, nibh porta vitae eu a risus adipiscing, ut a risus libero vestibulum pellentesque. Eget velit suspendisse libero massa congue amet, ornare scelerisque sagittis et a egestas, vel eius lorem scelerisque per. Diam non posuere pellentesque consectetuer, purus class, varius nunc molestiae nisl potenti, ipsum interdum ut vehicula, mauris urna sodales blandit.<br></p>
<!-- /wp:paragraph -->

<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Eden Sermon 8: God and the Fall',
  'post_excerpt' => '',
  'post_name' => 'eden-sermon-8-god-and-the-fall',
  'post_modified' => '2019-05-28 21:26:27',
  'post_modified_gmt' => '2019-05-28 21:26:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=285',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'lightbox_link' => 'https://www.youtube.com/watch?v=4gM6L0feAwI',
    'mobile_menu_styles' => 'default',
  ),
  'tax_input' => 
  array (
    'category' => 'sermon',
  ),
  'thumb' => 'https://themify.me/demo/themes/ultra-church/files/2019/05/great-church.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 57,
  'post_date' => '2019-05-23 02:47:50',
  'post_date_gmt' => '2019-05-23 02:47:50',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Learn More About Us</h1>
<h3>Who We Are</h3> <p>Encountering the truth in the person of Jesus means that we can walk in freedom, courage, and boldness. It means that we walk in the light and live truthful lives, seen in both what we do and what we say. The rest of this text is a church-style lorem ipsum. Purpose-driven church family embolden. Five point relevant spiritual formation echo reach the nations tithes and offerings. Ignite postmodern talks and guard your heart. </p>
<h2>Our Mission</h2>
<p>Good steward anointed resurgent community group God. Inspiration bind intercessor youth pastor ignite guard your heart good Father catalyst in the world community group pour out oceans. Guard your heart slippery slope, community group apostolic revelation so blessed radiate. Revelation worship leader community group lock in, unpack that christian congregation.</p>
<p>Fellowship love on community the bridge reverb love offering pointing to the light. Oceans anthem community unchurched ignite revival emergent. Free hyper-spiritual reach the nations potluck testimony window the bridge atmosphere. Youth pastor lock the message dig in oceans NIV authentic missional watered down small group. </p>
<h2>Our Vision </h2>
<h2>History<br/></h2>
<ul> <li id="timeline-0">
 Sep 2004 
 <h2>The Start of Our Church</h2> <p>Established in 2004, our small gathering increased from a basement home to this historic building on Queen St.</p> 
 </li>
 <li id="timeline-1">
 Dec 2006 
 <h2>Community Kitchen Launch</h2> <p>From the day we opened up our Queen street doors, we\'ve always wanted to reach out to the community around us. After saving and government funding, we opened up our food kitchen during one of the coldest months of the year.</p> 
 </li>
 <li id="timeline-2">
 Mar 2009 
 <h2>Cambodian Orphanage</h2> <p>Another goal of our members and leaders was to provide a safe and secure home for the ones who need it most. Open to all children 18 and younger since 2009, our Cambodian home has been full of love and hope.</p> 
 </li>
 <li id="timeline-3">
 Apr 2014 
 <h2>Inner City Social Works</h2> <p>We want to help anyone in need, not just those under the roof of our church. Our latest initiative is to reach those in Toronto, forgotten or diminished by the harshness of life in a big city.</p> 
 </li>
 </ul>
<h2>Pastors<br/></h2>
<h6>Our team of Pastors and Youth Leaders work together to build life-giving relationships and serve everyone around us in love.</h6>
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/pastor-john-smith-580x435.jpg" width="580" alt="pastor-john-smith" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/pastor-john-smith-580x435.jpg 580w, https://themify.me/demo/themes/ultra-church/files/2019/05/pastor-john-smith.jpg 583w" sizes="(max-width: 580px) 100vw, 580px" />
<h3>Michael Okuju</h3> <p>Serving as the lead Pastor for 8 years at our downtown Toronto location, Michael and his family are dedicated to serving with love.</p>
+001 416 1234567
michael-pastors@domain.com
<h3>Juan Gonzales</h3> <p>As the lead Pastor at our North York location since it\'s beginning in 2012, Juan is looking forward to many more years with his family in North York.</p>
+001 416 1234567
juan-pastors@domain.com
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/pastor-gonzales-580x432.jpg" width="580" alt="pastor-gonzales" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/pastor-gonzales-580x432.jpg 580w, https://themify.me/demo/themes/ultra-church/files/2019/05/pastor-gonzales.jpg 600w" sizes="(max-width: 580px) 100vw, 580px" />
<h2>Staff<br/></h2>
<h6>Incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas.</h6>
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/sandy-staff-370x250.jpg" width="370" title="Sandy Lee" alt="Loem Ipsum dolor sit" /> <h3> Sandy Lee </h3> Loem Ipsum dolor sit
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/alexander-370x250.jpg" width="370" title="Andre Montoya" alt="Loem Ipsum dolor sit" /> <h3> Andre Montoya </h3> Loem Ipsum dolor sit
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/hinathan-staff-370x250.jpg" width="370" title="Nathan Alexander" alt="Loem Ipsum dolor sit" /> <h3> Nathan Alexander </h3> Loem Ipsum dolor sit
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/robert-370x250.jpg" width="370" title="Robert Armstrong" alt="Loem Ipsum dolor sit" /> <h3> Robert Armstrong </h3> Loem Ipsum dolor sit
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/anthony-staff-370x250.jpg" width="370" title="Samuel Jackson" alt="Loem Ipsum dolor sit" /> <h3> Samuel Jackson </h3> Loem Ipsum dolor sit
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/melisa-chan-370x250.jpg" width="370" title="Melissa Chang" alt="Loem Ipsum dolor sit" /> <h3> Melissa Chang </h3> Loem Ipsum dolor sit<!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-05-31 02:06:44',
  'post_modified_gmt' => '2019-05-31 02:06:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?page_id=57',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"h9v6331\\",\\"cols\\":[{\\"element_id\\":\\"o0b2333\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ye2u334\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Learn More About Us<\\\\/h1>\\",\\"margin_bottom\\":\\"20\\",\\"font_style_h1_regular\\":\\"italic\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"5\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"breakpoint_tablet_landscape\\":{\\"font_style_h1_regular\\":\\"italic\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"4\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_style_h1_regular\\":\\"italic\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"3\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_mobile\\":{\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_style_h1_regular\\":\\"italic\\",\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"2.6\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_right\\":\\"6\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_right\\":\\"6\\"}}},{\\"element_id\\":\\"oozv337\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"jls3826\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Who We Are<\\\\/h3>\\\\n<p>Encountering the truth in the person of Jesus means that we can walk in freedom, courage, and boldness. It means that we walk in the light and live truthful lives, seen in both what we do and what we say. The rest of this text is a church-style lorem ipsum. Purpose-driven church family embolden. Five point relevant spiritual formation echo reach the nations tithes and offerings. Ignite postmodern talks and guard your heart. <\\\\/p>\\",\\"font_color\\":\\"#ffffff\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_tablet\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#003d63\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#003d63\\"},\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#003d63\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_right\\":\\"6\\",\\"font_color\\":\\"#003d63\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color\\":\\"#003d63\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_right\\":\\"6\\"},\\"breakpoint_mobile\\":{\\"font_color\\":\\"#003d63\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_top\\":\\"15\\",\\"background_position\\":\\"center-bottom\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/hero-banner-about-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"zfn8268\\",\\"cols\\":[{\\"element_id\\":\\"34v3270\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"r0p7671\\",\\"cols\\":[{\\"element_id\\":\\"ove1673\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a191678\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Our Mission<\\\\/h2>\\",\\"font_style_regular\\":\\"italic\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"2\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"1.7\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"1.4\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"1.3\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}}],\\"styling\\":{\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"0\\",\\"padding_right\\":\\"6\\"}}},{\\"element_id\\":\\"ey6i673\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"rxc9271\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Good steward anointed resurgent community group God. Inspiration bind intercessor youth pastor ignite guard your heart good Father catalyst in the world community group pour out oceans. Guard your heart slippery slope, community group apostolic revelation so blessed radiate. Revelation worship leader community group lock in, unpack that christian congregation.<\\\\/p>\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.2\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet_landscape\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_right\\":\\"5\\"},\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_right\\":\\"5\\"}}},{\\"element_id\\":\\"6ywa437\\",\\"cols\\":[{\\"element_id\\":\\"m57a438\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"itb2459\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Fellowship love on community the bridge reverb love offering pointing to the light. Oceans anthem community unchurched ignite revival emergent. Free hyper-spiritual reach the nations potluck testimony window the bridge atmosphere. Youth pastor lock the message dig in oceans NIV authentic missional watered down small group. <\\\\/p>\\",\\"line_height_unit\\":\\"em\\",\\"line_height\\":\\"1.4\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.2\\",\\"font_color_type\\":\\"font_color_solid\\"}}]},{\\"element_id\\":\\"f37b439\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9dfo439\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Our Vision <\\\\/h2>\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"2\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_style_regular\\":\\"italic\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"1.7\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_style_regular\\":\\"italic\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\"},\\"breakpoint_tablet\\":{\\"padding_left\\":\\"0\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"1.4\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"1.3\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_right\\":\\"5\\"}}}]}],\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"breakpoint_tablet_landscape\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_top\\":\\"9\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_top\\":\\"10\\"},\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_top\\":\\"12\\"}}},{\\"element_id\\":\\"ue5d99\\",\\"cols\\":[{\\"element_id\\":\\"1c6m100\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"3tx5899\\",\\"mod_settings\\":{\\"heading\\":\\"History\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"margin_bottom\\":\\"45\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"timeline\\",\\"element_id\\":\\"ew1t784\\",\\"mod_settings\\":{\\"template_timeline\\":\\"list\\",\\"source_timeline\\":\\"text\\",\\"post_per_page_post_timeline\\":\\"4\\",\\"text_source_timeline\\":[{\\"title_timeline\\":\\"The Start of Our Church\\",\\"icon_timeline\\":\\"fa-calendar-check-o\\",\\"date_timeline\\":\\"Sep 2004\\",\\"content_timeline\\":\\"<p>Established in 2004, our small gathering increased from a basement home to this historic building on Queen St.<\\\\/p>\\"},{\\"title_timeline\\":\\"Community Kitchen Launch\\",\\"icon_timeline\\":\\"fa-calendar-check-o\\",\\"date_timeline\\":\\"Dec 2006\\",\\"content_timeline\\":\\"<p>From the day we opened up our Queen street doors, we\\\\\\\\\\\'ve always wanted to reach out to the community around us. After saving and government funding, we opened up our food kitchen during one of the coldest months of the year.<\\\\/p>\\"},{\\"title_timeline\\":\\"Cambodian Orphanage\\",\\"icon_timeline\\":\\"fa-calendar-check-o\\",\\"date_timeline\\":\\"Mar 2009\\",\\"content_timeline\\":\\"<p>Another goal of our members and leaders was to provide a safe and secure home for the ones who need it most. Open to all children 18 and younger since 2009, our Cambodian home has been full of love and hope.<\\\\/p>\\"},{\\"title_timeline\\":\\"Inner City Social Works\\",\\"icon_timeline\\":\\"fa-calendar-check-o\\",\\"date_timeline\\":\\"Apr 2014\\",\\"content_timeline\\":\\"<p>We want to help anyone in need, not just those under the roof of our church. Our latest initiative is to reach those in Toronto, forgotten or diminished by the harshness of life in a big city.<\\\\/p>\\"}],\\"hide_feat_img_post_timeline\\":\\"no\\",\\"display_post_timeline\\":\\"excerpt\\",\\"orderby_post_timeline\\":\\"date\\",\\"order_post_timeline\\":\\"desc\\",\\"category_post_timeline\\":\\"0|single\\",\\"start_at_end\\":\\"no\\",\\"breakpoint_tablet_landscape\\":{\\"f_s_t_t_unit\\":\\"em\\",\\"f_s_t_t\\":\\"1.5\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"3\\"},\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_right\\":\\"3\\",\\"padding_top\\":\\"0\\"}}}],\\"gutter\\":\\"gutter-narrow\\",\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_top\\":\\"8\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top\\":\\"8\\"}}},{\\"element_id\\":\\"l7w6252\\",\\"cols\\":[{\\"element_id\\":\\"wuub253\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"uexg254\\",\\"mod_settings\\":{\\"heading\\":\\"Pastors\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"jx52124\\",\\"mod_settings\\":{\\"content_text\\":\\"<h6>Our team of Pastors and Youth Leaders work together to build life-giving relationships and serve everyone around us in love.<\\\\/h6>\\",\\"margin_bottom\\":\\"40\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"element_id\\":\\"lob1256\\",\\"cols\\":[{\\"element_id\\":\\"oi6b257\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"yc6u258\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pastor-john-smith-580x435.jpg\\",\\"style_image\\":\\"image-top\\",\\"width_image\\":\\"580\\",\\"auto_fullwidth\\":\\"1\\",\\"image_zoom_icon\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"yzs5258\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"gj8x259\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Michael Okuju<\\\\/h3>\\\\n<p>Serving as the lead Pastor for 8 years at our downtown Toronto location, Michael and his family are dedicated to serving with love.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"6wge259\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 1234567\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"6iu1260\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-email\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"michael-pastors@domain.com\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"4\\",\\"background_color\\":\\"#ffffff\\",\\"breakpoint_tablet_landscape\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_bottom\\":\\"0\\",\\"padding_right\\":\\"4\\",\\"padding_top\\":\\"4\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"margin_bottom\\":\\"8\\",\\"b_sh_color\\":\\"#000000_0.12\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"8\\"}}},{\\"element_id\\":\\"8kw1260\\",\\"cols\\":[{\\"element_id\\":\\"zy6q206\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"p7s0207\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Juan Gonzales<\\\\/h3>\\\\n<p>As the lead Pastor at our North York location since it\\\\\\\\\\\'s beginning in 2012, Juan is looking forward to many more years with his family in North York.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"rrb4207\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 1234567\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"gpna207\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-email\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"juan-pastors@domain.com\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"em\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"4\\",\\"background_color\\":\\"#ffffff\\",\\"padding_left\\":\\"5\\",\\"padding_bottom\\":\\"2\\",\\"padding_right\\":\\"5\\",\\"breakpoint_tablet_landscape\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_bottom\\":\\"0\\",\\"padding_right\\":\\"4\\",\\"padding_top\\":\\"4\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}}},{\\"element_id\\":\\"wqb7262\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4fb1263\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pastor-gonzales-580x432.jpg\\",\\"style_image\\":\\"image-top\\",\\"width_image\\":\\"580\\",\\"auto_fullwidth\\":\\"1\\",\\"image_zoom_icon\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"gutter\\":\\"gutter-none\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"b_sh_color\\":\\"#000000_0.14\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"3\\"},\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_right\\":\\"4\\",\\"padding_top\\":\\"0\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_right\\":\\"4\\",\\"padding_top\\":\\"0\\"}}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom\\":\\"12\\",\\"padding_top\\":\\"6\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pattern.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_width\\":\\"100\\",\\"bottom-frame_color\\":\\"#efbb58\\",\\"bottom-frame_layout\\":\\"zig-zag\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"15\\",\\"padding_top\\":\\"6\\"},\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"18\\",\\"padding_top\\":\\"7\\"}}},{\\"element_id\\":\\"gqs4958\\",\\"cols\\":[{\\"element_id\\":\\"c627962\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"2szd700\\",\\"mod_settings\\":{\\"heading\\":\\"Staff\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"d_border_top_width\\":\\"4\\",\\"d_border_top_color\\":\\"#003d63\\",\\"d_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"1v8z255\\",\\"mod_settings\\":{\\"content_text\\":\\"<h6>Incididunt ut labore et dolore magna aliqua. Quis ipsum suspendisse ultrices gravida. Risus commodo viverra maecenas.<\\\\/h6>\\",\\"margin_bottom\\":\\"30\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"element_id\\":\\"dt6y218\\",\\"cols\\":[{\\"element_id\\":\\"rehf220\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"030129\\",\\"mod_settings\\":{\\"caption_image\\":\\"Loem Ipsum dolor sit\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Sandy Lee\\",\\"width_image\\":\\"370\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/sandy-staff-370x250.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.5\\"},\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"36wl719\\",\\"mod_settings\\":{\\"caption_image\\":\\"Loem Ipsum dolor sit\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Andre Montoya\\",\\"width_image\\":\\"370\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/alexander-370x250.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_bottom\\":\\"30\\",\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}}]},{\\"element_id\\":\\"xlur221\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8beo732\\",\\"mod_settings\\":{\\"caption_image\\":\\"Loem Ipsum dolor sit\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Nathan Alexander\\",\\"width_image\\":\\"370\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/hinathan-staff-370x250.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.5\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"im626\\",\\"mod_settings\\":{\\"caption_image\\":\\"Loem Ipsum dolor sit\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Robert Armstrong\\",\\"width_image\\":\\"370\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/robert-370x250.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_bottom\\":\\"30\\",\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}}]},{\\"element_id\\":\\"n1qh221\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"57ph274\\",\\"mod_settings\\":{\\"caption_image\\":\\"Loem Ipsum dolor sit\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Samuel Jackson\\",\\"width_image\\":\\"370\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/anthony-staff-370x250.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.5\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ipoy396\\",\\"mod_settings\\":{\\"caption_image\\":\\"Loem Ipsum dolor sit\\",\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Melissa Chang\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/melisa-chan-370x250.jpg\\",\\"style_image\\":\\"image-center\\",\\"margin_bottom\\":\\"30\\",\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\",\\"width_image\\":\\"370\\"}}]}]}],\\"styling\\":{\\"breakpoint_tablet_landscape\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"3\\"},\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"4\\"}}}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"background_color\\":\\"#efbb58\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top\\":\\"3\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 92,
  'post_date' => '2019-05-23 07:44:12',
  'post_date_gmt' => '2019-05-23 07:44:12',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><img src="https://themify.me/demo/themes/ultra-church/files/2019/05/pin-map-location.png" title="Toronto" alt="56 Queen St E, Toronto, ON M5C 2Z3, Canada 001 416 777 4567" /> <h3> Toronto </h3> 56 Queen St E, Toronto, <br> ON M5C 2Z3, Canada<br> +001 416 777 4567

<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/pin-map-location.png" title="North York" alt="50 Bogert Ave, North York, ON M2N 1K4, Canada 001 416 777 4567" /> <h3> North York </h3> 50 Bogert Ave, North York, ON <br> M2N 1K4, Canada <br> +001 416 777 4567
<h2>Need Care?<br/></h2>
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon-194x195.png" width="194" title="Everyone needs a little help." alt="Lorem ipsum dolor sit amet" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon-150x150.png 150w, https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon-195x196.png 195w" sizes="(max-width: 194px) 100vw, 194px" /> <h3> Everyone needs a little help. </h3> Lorem ipsum dolor sit amet
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon-194x195.png" width="194" title="Let us pray for you." alt="Lorem ipsum dolor sit amet" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon-150x150.png 150w, https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon-195x196.png 195w" sizes="(max-width: 194px) 100vw, 194px" /> <h3> Let us pray for you. </h3> Lorem ipsum dolor sit amet
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/donation-icon-194x195.png" width="194" title="We offer free counselling." alt="Lorem ipsum dolor sit amet" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/donation-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/donation-icon-150x150.png 150w" sizes="(max-width: 194px) 100vw, 194px" /> <h3> We offer free counselling. </h3> Lorem ipsum dolor sit amet
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/volunteer-icon-194x195.png" width="194" title="Help us help the community." alt="Lorem ipsum dolor sit amet" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/volunteer-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/volunteer-icon-150x150.png 150w" sizes="(max-width: 194px) 100vw, 194px" /> <h3> Help us help the community. </h3> Lorem ipsum dolor sit amet
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/hosting-icon-194x195.png" width="194" title="Meet us at our next event." alt="Lorem ipsum dolor sit amet" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/hosting-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/hosting-icon-150x150.png 150w" sizes="(max-width: 194px) 100vw, 194px" /> <h3> Meet us at our next event. </h3> Lorem ipsum dolor sit amet
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/classes-icon-194x195.png" width="194" title="Ask us for assistance." alt="Lorem ipsum dolor sit amet" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/classes-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/classes-icon-150x150.png 150w" sizes="(max-width: 194px) 100vw, 194px" /> <h3> Ask us for assistance. </h3> Lorem ipsum dolor sit amet
<h2>Contact<br/></h2>
<h3>We\'d love to hear from you. Get in touch with us!</h3>
<form action="https://themify.me/demo/themes/ultra-church/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<h2>Follow  Us</h2>
<a href="https://themify.me"> +001 416 1234567 </a> <a href="https://themify.me"> Info.pray@yourdomain.com </a> <a href="https://twitter.com/themify"> @info_church </a> <a href="https://facebook.com/themify"> /info_church </a> <a href="https://www.youtube.com/user/themifyme/"> church_tv </a><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-19 15:39:51',
  'post_modified_gmt' => '2019-09-19 15:39:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?page_id=92',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"c3ka461\\",\\"cols\\":[{\\"element_id\\":\\"eeh2463\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"oh71186\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pin-map-location.png\\",\\"style_image\\":\\"image-center\\",\\"caption_image\\":\\"56 Queen St E, Toronto, <br>\\\\nON M5C 2Z3, Canada<br>\\\\n+001 416 777 4567\\\\n\\",\\"title_image\\":\\"Toronto\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/ornament-top-left.png\\",\\"font_color\\":\\"#ffffff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#065896_0.35\\"}},{\\"element_id\\":\\"0hrg938\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"t540479\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"style_image\\":\\"image-top\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2ohm957\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pin-map-location.png\\",\\"style_image\\":\\"image-center\\",\\"caption_image\\":\\"50 Bogert Ave, North York, ON <br> \\\\nM2N 1K4, Canada <br> \\\\n+001 416 777 4567\\",\\"title_image\\":\\"North York\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"background_position\\":\\"left-top\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/bg-map-contact.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"cover_color\\":\\"#065896_0.69\\",\\"cover_color-type\\":\\"color\\",\\"font_color\\":\\"#ffffff\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"row_width\\":\\"fullwidth-content\\",\\"bottom-frame_location\\":\\"in_front\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_height\\":\\"20\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_width\\":\\"100\\",\\"bottom-frame_color\\":\\"#ffffff\\",\\"bottom-frame_layout\\":\\"arrow2\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_front\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"background_color\\":\\"#3d80aa\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"row_height\\":\\"fullheight\\",\\"cover_color-type\\":\\"color\\"}},{\\"element_id\\":\\"tuup399\\",\\"cols\\":[{\\"element_id\\":\\"at54404\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"eh0z98\\",\\"mod_settings\\":{\\"heading\\":\\"Need Care?\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.8\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"element_id\\":\\"m31w791\\",\\"cols\\":[{\\"element_id\\":\\"sul5792\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9pku793\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Everyone needs a little help.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/sharing-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"border_bottom_width\\":\\"1\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_style\\":\\"none\\",\\"caption_image\\":\\"Lorem ipsum dolor sit\\\\namet \\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.3\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"bottom\\",\\"border_left_style\\":\\"none\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_left_style\\":\\"none\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\"}}},{\\"element_id\\":\\"32uf795\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9toi796\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Let us pray for you.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/praying-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"caption_image\\":\\"Lorem ipsum dolor sit\\\\namet \\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_title_unit\\":\\"em\\"},\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"none\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"left\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_left_style\\":\\"none\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\"}}},{\\"element_id\\":\\"dtf6796\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"n0bh797\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"We offer free counselling.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/donation-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"caption_image\\":\\"Lorem ipsum dolor sit\\\\namet \\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.3\\",\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"bottom\\",\\"border_right_style\\":\\"none\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_right\\":\\"3\\"}}},{\\"element_id\\":\\"wrcc627\\",\\"cols\\":[{\\"element_id\\":\\"3e23628\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"2ar4629\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Help us help the community.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/volunteer-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"caption_image\\":\\"Lorem ipsum dolor sit\\\\namet \\",\\"breakpoint_tablet_landscape\\":{\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.3\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"left\\",\\"border_left_style\\":\\"none\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_left_style\\":\\"none\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_left_style\\":\\"none\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\"}}},{\\"element_id\\":\\"yiiy629\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"3s15630\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Meet us at our next event.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/hosting-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"caption_image\\":\\"Lorem ipsum dolor sit\\\\namet \\",\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.3\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"left\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"breakpoint_mobile\\":{\\"border_left_style\\":\\"none\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_left_style\\":\\"none\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border_right_style\\":\\"none\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"bottom\\"}}},{\\"element_id\\":\\"dp9x630\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zx1x631\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Ask us for assistance.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/classes-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"caption_image\\":\\"Lorem ipsum dolor sit\\\\namet \\",\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.3\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"right\\",\\"border_right_style\\":\\"none\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border_right_style\\":\\"none\\",\\"border-type\\":\\"bottom\\"},\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"5\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#eeeeee\\",\\"border_right_style\\":\\"none\\",\\"border-type\\":\\"bottom\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"margin_bottom\\":\\"40\\"}}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\"}}}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\"}},{\\"element_id\\":\\"ihxh351\\",\\"cols\\":[{\\"element_id\\":\\"9ash356\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"o6ao564\\",\\"cols\\":[{\\"element_id\\":\\"9kto565\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ts7l306\\",\\"mod_settings\\":{\\"heading\\":\\"Contact\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"margin_bottom\\":\\"30\\",\\"d_border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.9\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"0\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"s9ry596\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>We\\\\\\\\\\\'d love to hear from you. Get in touch with us!<\\\\/h3>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"wyek801\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"left\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_order\\":\\"{}\\",\\"contact_sent_from\\":\\"enable\\",\\"layout_contact\\":\\"animated-label\\",\\"border_inputs_top_style\\":\\"none\\",\\"border_inputs-type\\":\\"all\\",\\"background_color_inputs\\":\\"#ffffff\\",\\"font_color_inputs\\":\\"#7a7a7a\\",\\"font_color_send\\":\\"#ffffff\\",\\"background_color_send\\":\\"#000000\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"4\\",\\"background_color\\":\\"#ffc55f\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"checkbox_padding_apply_all\\":\\"1\\"}}},{\\"element_id\\":\\"civk566\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"w5he426\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Follow  Us<\\\\/h2>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"s73n755\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 1234567\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-email\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Info.pray@yourdomain.com\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"@info_church\\",\\"link\\":\\"https:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-facebook\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"\\\\/info_church\\",\\"link\\":\\"https:\\\\/\\\\/facebook.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-control-play\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"church_tv\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/user\\\\/themifyme\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_vertical\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"xlarge\\",\\"icon_position\\":\\"icon_position_left\\",\\"border-type\\":\\"bottom\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"font_color_icon\\":\\"#003d63\\",\\"font_color\\":\\"#000000\\",\\"font_color_type\\":\\"font_color_solid\\"}}],\\"styling\\":{\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-15\\",\\"b_sh_color\\":\\"#000000_0.12\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"26\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"3\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"4\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"4\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"0\\",\\"checkbox_padding_apply_all\\":\\"1\\"}}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_color\\":\\"#ffffff\\",\\"top-frame_layout\\":\\"zig-zag\\",\\"top-frame_type\\":\\"top-presets\\",\\"background_color\\":\\"#f4bd58\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"top-frame_height\\":\\"20\\",\\"top-frame_width\\":\\"100\\",\\"breakpoint_mobile\\":{\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_height\\":\\"10\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_width\\":\\"100\\",\\"top-frame_color\\":\\"#ffffff\\",\\"top-frame_layout\\":\\"zig-zag\\",\\"top-frame_type\\":\\"top-presets\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6,
  'post_date' => '2019-05-22 02:40:13',
  'post_date_gmt' => '2019-05-22 02:40:13',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1><em>In the beginning was the Word, and the Word was with God, and the Word was God.</em></h1>
<a href="https://themify.me/" > Learn More </a>
<h2>Sunday Service</h2>
<h3>Where You\'ll Find Grace</h3> <p>You\'re welcome here. Join us to celebrate, to mourn, to give thanks, to ask questions, or to pray. Come as you are.</p>
Sunday 09:35 - 10:40
56 Queen St E, Toronto
<h2>Need Care?<br/></h2>
<a href="https://themify.me/demo/themes/ultra-church/contact/" > <img src="https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon-194x195.png" width="194" title="Everyone needs a little help." alt="Everyone needs a little help." srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon-150x150.png 150w, https://themify.me/demo/themes/ultra-church/files/2019/05/sharing-icon-195x196.png 195w" sizes="(max-width: 194px) 100vw, 194px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-church/contact/" > Everyone needs a little help. </a> </h3>
<a href="https://themify.me/demo/themes/ultra-church/contact/" > <img src="https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon-194x195.png" width="194" title="Let us pray for you." alt="Let us pray for you." srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon-150x150.png 150w, https://themify.me/demo/themes/ultra-church/files/2019/05/praying-icon-195x196.png 195w" sizes="(max-width: 194px) 100vw, 194px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-church/contact/" > Let us pray for you. </a> </h3>
<a href="https://themify.me/demo/themes/ultra-church/contact/" > <img src="https://themify.me/demo/themes/ultra-church/files/2019/05/assistance-icon-194x195.png" width="194" title="We offer free legal counsel." alt="We offer free legal counsel." srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/assistance-icon.png 194w, https://themify.me/demo/themes/ultra-church/files/2019/05/assistance-icon-150x150.png 150w, https://themify.me/demo/themes/ultra-church/files/2019/05/assistance-icon-195x196.png 195w" sizes="(max-width: 194px) 100vw, 194px" /> </a> <h3> <a href="https://themify.me/demo/themes/ultra-church/contact/" > We offer free legal counsel. </a> </h3>
<h2>Sermons<br/></h2>

<a href="https://themify.me/demo/themes/ultra-church/sermons/" > More Sermons </a>
<h2>Locations<br/></h2>
<h6>We\'ve got two locations around the GTA. Find your community at one of two locations.</h6>
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church-580x436.jpg" width="580" alt="toronto-church" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church-580x436.jpg 580w, https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church-500x376.jpg 500w, https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church.jpg 585w" sizes="(max-width: 580px) 100vw, 580px" />
<h3>Toronto</h3> <p>Established in 2004, our small gathering increased from a basement home to this historic building on Queen St.</p>
+001 416 777 4567
56 Queen St E, Toronto
<h3>North York</h3> <p>As more of our members moved north of the city to start new lives or families, we committed to a second location in 2012 for our North York community.</p>
+001 416 777 4567
50 Bogert Ave, North York
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/north-york-church-580x436.jpg" width="580" alt="north-york-church" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/north-york-church-580x436.jpg 580w, https://themify.me/demo/themes/ultra-church/files/2019/05/north-york-church.jpg 585w" sizes="(max-width: 580px) 100vw, 580px" />
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/ornaments-410x76.jpg" width="410" alt="ornaments" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/ornaments-410x76.jpg 410w, https://themify.me/demo/themes/ultra-church/files/2019/05/ornaments.jpg 409w" sizes="(max-width: 410px) 100vw, 410px" />
<h3>Donations<br/></h3>
<h3>Help us renovate our community kitchen.</h3> <p>We\'ve got high hopes and expectations to help serve people with our downtown food kitchen. We\'re hoping to expand our dining area, add six more industry grade burners, and swap the use of plastics toward more sustainable options.</p> <p>If you\'d like more information, please use the contact form to connect with us.</p>
<i>Raised</i>
<a href="https://themify.me/demo/themes/ultra-church/contact/" > Donate </a>
<h3>Message Us for Donation Details</h3> <form action="https://themify.me/demo/themes/ultra-church/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/app-400x514.png" width="400" alt="app" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/app-400x514.png 400w, https://themify.me/demo/themes/ultra-church/files/2019/05/app-467x600.png 467w, https://themify.me/demo/themes/ultra-church/files/2019/05/app.png 473w" sizes="(max-width: 400px) 100vw, 400px" />
<h3>Church App<br/></h3>
<h6>Our new app allows you to follow along on Sundays to read the bible verse, see the main sermon topics, and get updates on our latest events.</h6>
<a href="https://themify.me/" > Dowload App </a><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-09-19 15:40:13',
  'post_modified_gmt' => '2019-09-19 15:40:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?page_id=6',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"fm4x715\\",\\"cols\\":[{\\"element_id\\":\\"7oav717\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zkhe779\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1><em>In the beginning was the Word, and the Word was with God, and the Word was God.<\\\\/em><\\\\/h1>\\",\\"margin_bottom\\":\\"20\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"padding_left_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"font_color_type\\":\\"font_color_solid\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"font_color\\":\\"#003d63\\",\\"breakpoint_tablet\\":{\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"2\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"5\\"},\\"breakpoint_mobile\\":{\\"font_size_h1_unit\\":\\"em\\",\\"font_size_h1\\":\\"1.8\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"9apy8\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Learn More\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\",\\"button_color_bg\\":\\"tb_default_color\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"rounded\\",\\"buttons_size\\":\\"normal\\",\\"breakpoint_tablet\\":{\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"5\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"7ztg813\\",\\"grid_class\\":\\"col3-1\\",\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"13\\",\\"padding_top\\":\\"13\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/church-hero-banner.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"cover_gradient-gradient\\":\\"0% rgba(255, 214, 138, 0.57)|100% rgba(255, 255, 255, 0)\\",\\"cover_gradient-gradient-angle\\":\\"130\\",\\"cover_color-type\\":\\"cover_gradient\\"}},{\\"element_id\\":\\"l45927\\",\\"cols\\":[{\\"element_id\\":\\"6ulp28\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"cydu505\\",\\"mod_settings\\":{\\"content_text\\":\\"<h2>Sunday Service<\\\\/h2>\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_style_h2_regular\\":\\"italic\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"6\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"breakpoint_tablet\\":{\\"font_style_h2_regular\\":\\"italic\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"3.5\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"10\\"},\\"breakpoint_mobile\\":{\\"font_style_h2_regular\\":\\"italic\\",\\"font_size_h2_unit\\":\\"em\\",\\"font_size_h2\\":\\"3\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"0\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"pz63440\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"tlnw332\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Where You\\\\\\\\\\\'ll Find Grace<\\\\/h3>\\\\n<p>You\\\\\\\\\\\'re welcome here. Join us to celebrate, to mourn, to give thanks, to ask questions, or to pray. Come as you are.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"padding_top_unit\\":\\"%\\"}}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"6q5c912\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-time\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"Sunday 09:35 - 10:40 \\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border-type\\":\\"top\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\",\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#dddddd\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"81rs818\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"56 Queen St E, Toronto\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\",\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#dddddd\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"7\\",\\"background_position\\":\\"left-bottom\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/ornament-service-top.png\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"bottom\\",\\"row_width\\":\\"fullwidth\\",\\"border_inner-type\\":\\"bottom\\",\\"background_position_inner\\":\\"center-center\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_repeat_inner\\":\\"repeat\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\"}},{\\"element_id\\":\\"3ljx498\\",\\"cols\\":[{\\"element_id\\":\\"9tej500\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"jmx3738\\",\\"mod_settings\\":{\\"heading\\":\\"Need Care?\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.8\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"element_id\\":\\"2xda337\\",\\"cols\\":[{\\"element_id\\":\\"exfg339\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"78uh326\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Everyone needs a little help.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/sharing-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/contact\\\\/\\",\\"breakpoint_tablet\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.2\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"left\\",\\"border_left_style\\":\\"none\\"}},{\\"element_id\\":\\"zloz340\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"xmgy866\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"Let us pray for you.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/praying-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/contact\\\\/\\",\\"breakpoint_tablet\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.2\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border_left_width\\":\\"1\\",\\"border_left_color\\":\\"#eeeeee\\",\\"border_right_width\\":\\"1\\",\\"border_right_color\\":\\"#eeeeee\\",\\"border-type\\":\\"left\\"}},{\\"element_id\\":\\"4041341\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"fzie670\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"title_image\\":\\"We offer free legal counsel.\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/assistance-icon.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"194\\",\\"link_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/contact\\\\/\\",\\"breakpoint_tablet\\":{\\"font_size_title_unit\\":\\"em\\",\\"font_size_title\\":\\"1.2\\",\\"font_color_type\\":\\"font_color_solid\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border-type\\":\\"right\\",\\"border_right_style\\":\\"none\\"}}],\\"gutter\\":\\"gutter-none\\"}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\"}},{\\"element_id\\":\\"lf73385\\",\\"cols\\":[{\\"element_id\\":\\"z2q4387\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"n7yg912\\",\\"mod_settings\\":{\\"heading\\":\\"Sermons\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.8\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"m7wq112\\",\\"mod_settings\\":{\\"layout_post\\":\\"list-large-image\\",\\"post_per_page_post\\":\\"3\\",\\"display_post\\":\\"excerpt\\",\\"hide_page_nav_post\\":\\"yes\\",\\"post_type_post\\":\\"post\\",\\"hide_post_meta_post\\":\\"yes\\",\\"hide_post_date_post\\":\\"no\\",\\"unlink_post_title_post\\":\\"no\\",\\"hide_post_title_post\\":\\"no\\",\\"unlink_feat_img_post\\":\\"no\\",\\"hide_feat_img_post\\":\\"no\\",\\"orderby_post\\":\\"date\\",\\"order_post\\":\\"desc\\",\\"post_filter\\":\\"no\\",\\"category_post\\":\\"0|single\\",\\"term_type\\":\\"category\\",\\"type_query_post\\":\\"category\\",\\"general_margin_bottom\\":\\"40\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"xp6m313\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"More Sermons\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-church\\\\/sermons\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"rounded\\",\\"buttons_size\\":\\"normal\\",\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"40\\"}}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"f3k3988\\",\\"cols\\":[{\\"element_id\\":\\"poxa990\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"0y96331\\",\\"mod_settings\\":{\\"heading\\":\\"Locations\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.8\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"954r912\\",\\"mod_settings\\":{\\"content_text\\":\\"<h6>We\\\\\\\\\\\'ve got two locations around the GTA. Find your community at one of two locations.<\\\\/h6>\\",\\"margin_bottom\\":\\"40\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"element_id\\":\\"q07m408\\",\\"cols\\":[{\\"element_id\\":\\"hy5m409\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"39ih410\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/toronto-church-580x436.jpg\\",\\"style_image\\":\\"image-center\\",\\"auto_fullwidth\\":\\"1\\",\\"b_sh_color\\":\\"#ffc55f\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"0\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"20\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"-20\\",\\"breakpoint_tablet\\":{\\"margin_bottom\\":\\"40\\"},\\"width_image\\":\\"580\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"ey1k411\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"g32r411\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Toronto<\\\\/h3>\\\\n<p>Established in 2004, our small gathering increased from a basement home to this historic building on Queen St.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"6hcp412\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 777 4567\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"pz95412\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"56 Queen St E, Toronto\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"background_color\\":\\"#ffffff\\",\\"breakpoint_tablet\\":{\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"-\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom\\":\\"2\\",\\"padding_right\\":\\"3\\",\\"padding_top\\":\\"5\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"margin_bottom\\":\\"8\\",\\"border-type\\":\\"top\\",\\"margin_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"sk49726\\",\\"cols\\":[{\\"element_id\\":\\"eyqd727\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"g59a728\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>North York<\\\\/h3>\\\\n<p>As more of our members moved north of the city to start new lives or families, we committed to a second location in 2012 for our North York community.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"epf3727\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 777 4567\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2toh728\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"50 Bogert Ave, North York\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.13\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"background_color\\":\\"#ffffff\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom\\":\\"2\\",\\"padding_right\\":\\"2\\",\\"padding_top\\":\\"5\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}},{\\"element_id\\":\\"7avl728\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"xx7p729\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/north-york-church-580x436.jpg\\",\\"style_image\\":\\"image-top\\",\\"i_t_sh_color\\":\\"#ffc55f\\",\\"i_t_sh_vOffset_unit\\":\\"px\\",\\"i_t_sh_vOffset\\":\\"15\\",\\"i_t_sh_hOffset_unit\\":\\"px\\",\\"i_t_sh_hOffset\\":\\"15\\",\\"b_sh_color\\":\\"#ffc55f\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"0\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"20\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"20\\",\\"auto_fullwidth\\":\\"1\\",\\"breakpoint_tablet\\":{\\"margin_bottom\\":\\"40\\"},\\"width_image\\":\\"580\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"gutter\\":\\"gutter-none\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom\\":\\"9\\",\\"padding_top\\":\\"6\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pattern.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"right-frame_location\\":\\"in_bellow\\",\\"right-frame_height_unit\\":\\"%\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"left-frame_location\\":\\"in_bellow\\",\\"left-frame_height_unit\\":\\"%\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_top\\":\\"13\\"}}},{\\"element_id\\":\\"yyws794\\",\\"cols\\":[{\\"element_id\\":\\"fjia795\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0o53931\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/ornaments.jpg\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"410\\"}}]}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}},{\\"element_id\\":\\"65gs375\\",\\"cols\\":[{\\"element_id\\":\\"lnfq376\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"ww1g370\\",\\"cols\\":[{\\"element_id\\":\\"puz2370\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"rq6x17\\",\\"mod_settings\\":{\\"heading\\":\\"Donations\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h3\\",\\"margin_bottom\\":\\"30\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.75\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.3\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"tul8133\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Help us renovate our community kitchen.<\\\\/h3>\\\\n<p>We\\\\\\\\\\\'ve got high hopes and expectations to help serve people with our downtown food kitchen. We\\\\\\\\\\\'re hoping to expand our dining area, add six more industry grade burners, and swap the use of plastics toward more sustainable options.<\\\\/p>\\\\n<p>If you\\\\\\\\\\\'d like more information, please use the contact form to connect with us.<\\\\/p>\\",\\"margin_bottom\\":\\"10\\",\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"progressbar\\",\\"element_id\\":\\"az29797\\",\\"mod_settings\\":{\\"hide_percentage_text\\":\\"no\\",\\"progress_bars\\":[{\\"bar_label\\":\\"Raised\\",\\"bar_percentage\\":\\"45\\",\\"bar_percentage_label\\":\\"$1578 \\",\\"bar_percentage_only_label\\":\\"yes\\",\\"null\\":\\"yes\\",\\"bar_color\\":\\"#003d63\\"}],\\"margin_bottom\\":\\"-15\\",\\"f_b_b\\":\\"bold\\",\\"f_s_b_unit\\":\\"em\\",\\"f_s_b\\":\\"1.2\\",\\"f_c_b\\":\\"#003d63\\",\\"font_size_unit\\":\\"em\\",\\"font_color_type\\":\\"font_color_solid\\",\\"t_t_b\\":\\"capitalize\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"h3r9611\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Donate\\",\\"link\\":\\"https://themify.me/demo/themes/ultra-church\\\\/contact\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"rounded\\",\\"buttons_size\\":\\"xlarge\\",\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"30\\"}}}],\\"styling\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"background_color\\":\\"#ffc55f\\",\\"background_position\\":\\"right-bottom\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/ornament-donation.png\\",\\"breakpoint_tablet\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}}},{\\"element_id\\":\\"r23x371\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"g085277\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"center\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_order\\":\\"{}\\",\\"contact_sent_from\\":\\"enable\\",\\"layout_contact\\":\\"animated-label\\",\\"mod_title_contact\\":\\"Message Us for Donation Details\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"3\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"b_sh_color\\":\\"#000000_0.14\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\",\\"breakpoint_tablet\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\"}}}],\\"styling\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"background_position\\":\\"right-bottom\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"},\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_bottom\\":\\"9\\",\\"padding_right\\":\\"5\\",\\"checkbox_padding_apply_all\\":\\"1\\"}}}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"3\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"3\\"}}},{\\"element_id\\":\\"9l2j988\\",\\"cols\\":[{\\"element_id\\":\\"9ppf991\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"gaz3729\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/app-400x514.png\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"400\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\"}}]},{\\"element_id\\":\\"o6ki852\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"ujlw119\\",\\"mod_settings\\":{\\"heading\\":\\"Church App\\",\\"text_alignment\\":\\"themify-text-left\\",\\"heading_tag\\":\\"h3\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.75\\",\\"font_color_type\\":\\"font_color_solid\\",\\"main_margin_bottom_unit\\":\\"px\\",\\"main_margin_bottom\\":\\"20\\",\\"breakpoint_tablet\\":{\\"main_margin_bottom_unit\\":\\"px\\",\\"main_margin_bottom\\":\\"20\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.3\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"khs9597\\",\\"mod_settings\\":{\\"content_text\\":\\"<h6>Our new app allows you to follow along on Sundays to read the bible verse, see the main sermon topics, and get updates on our latest events.<\\\\/h6>\\",\\"breakpoint_mobile\\":{\\"font_color_type\\":\\"font_color_solid\\"},\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"20\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"3unu153\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Dowload App\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"blue\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_shape\\":\\"rounded\\",\\"buttons_size\\":\\"xlarge\\",\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"30\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_position\\":\\"left-bottom\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat-none\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/ornament-service-top.png\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"border_top_width\\":\\"1\\",\\"border_top_color\\":\\"#dddddd\\",\\"border-type\\":\\"top\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 89,
  'post_date' => '2019-05-23 07:43:43',
  'post_date_gmt' => '2019-05-23 07:43:43',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static-->Toronto Church North York Church
<h2>Locations<br/></h2>
<h6>We\'ve got two locations around the GTA. Find your community at one of two locations.</h6>
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church-580x436.jpg" width="580" alt="toronto-church" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church-580x436.jpg 580w, https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church-500x376.jpg 500w, https://themify.me/demo/themes/ultra-church/files/2019/05/toronto-church.jpg 585w" sizes="(max-width: 580px) 100vw, 580px" />
<h3>Toronto</h3> <p>Established in 2004, our small gathering increased from a basement home to this historic building on Queen St.</p>
+001 416 777 4567
56 Queen St E, Toronto
<h3>North York</h3> <p>As more of our members moved north of the city to start new lives or families, we committed to a second location in 2012 for our North York community.</p>
+001 416 777 4567
50 Bogert Ave, North York
<img src="https://themify.me/demo/themes/ultra-church/files/2019/05/north-york-church-580x436.jpg" width="580" alt="north-york-church" srcset="https://themify.me/demo/themes/ultra-church/files/2019/05/north-york-church-580x436.jpg 580w, https://themify.me/demo/themes/ultra-church/files/2019/05/north-york-church.jpg 585w" sizes="(max-width: 580px) 100vw, 580px" /><!--/themify_builder_static-->',
  'post_title' => 'Locations',
  'post_excerpt' => '',
  'post_name' => 'locations',
  'post_modified' => '2019-05-31 02:08:18',
  'post_modified_gmt' => '2019-05-31 02:08:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?page_id=89',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ugxv671\\",\\"cols\\":[{\\"element_id\\":\\"yg4i671\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"maps-pro\\",\\"element_id\\":\\"81g6435\\",\\"mod_settings\\":{\\"type_map\\":\\"ROADMAP\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"disable_map_ui\\":\\"no\\",\\"w_map_unit\\":\\"%\\",\\"w_map\\":\\"100\\",\\"h_map\\":\\"650\\",\\"zoom_map\\":\\"11\\",\\"style_map\\":\\"muted-blue\\",\\"map_polyline\\":\\"no\\",\\"map_polyline_geodesic\\":\\"yes\\",\\"map_polyline_stroke\\":\\"2\\",\\"map_polyline_color\\":\\"#ff0000_1\\",\\"map_center\\":\\"Toronto, ON, Canada\\",\\"map_display_type\\":\\"dynamic\\",\\"w_map_static\\":\\"500\\",\\"markers\\":[{\\"address\\":\\"3 Bedford Road, Toronto, ON, Canada\\",\\"latlng\\":\\"43.6682198,-79.39746250000002\\",\\"title\\":\\"Toronto Church\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pin-location.png\\"},{\\"address\\":\\"1655 Wilson Ave, North York, ON M3L 1A5, Canada\\",\\"latlng\\":\\"43.71944449999999,-79.51369749999998\\",\\"title\\":\\"North York Church\\",\\"image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pin-location.png\\"}]}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"vht8235\\",\\"cols\\":[{\\"element_id\\":\\"f374235\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"bics236\\",\\"mod_settings\\":{\\"heading\\":\\"Locations\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.8\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mbff236\\",\\"mod_settings\\":{\\"content_text\\":\\"<h6>We\\\\\\\\\\\'ve got two locations around the GTA. Find your community at one of two locations.<\\\\/h6>\\",\\"margin_bottom\\":\\"40\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"element_id\\":\\"5d5m236\\",\\"cols\\":[{\\"element_id\\":\\"otw6236\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"eoq9237\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/toronto-church.jpg\\",\\"style_image\\":\\"image-center\\",\\"auto_fullwidth\\":\\"1\\",\\"b_sh_color\\":\\"#ffc55f\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"0\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"20\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"-20\\",\\"breakpoint_tablet\\":{\\"margin_bottom\\":\\"40\\"},\\"image_zoom_icon\\":\\"\\",\\"width_image\\":\\"580\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\",\\"b_sh_inset\\":\\"\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}},{\\"element_id\\":\\"qv0q237\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"l9c2237\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Toronto<\\\\/h3>\\\\n<p>Established in 2004, our small gathering increased from a basement home to this historic building on Queen St.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"62yx237\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 777 4567\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"9x4o237\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"56 Queen St E, Toronto\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"background_color\\":\\"#ffffff\\",\\"breakpoint_tablet\\":{\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"-\\"},\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom\\":\\"2\\",\\"padding_right\\":\\"3\\",\\"padding_top\\":\\"5\\"}}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"margin_bottom\\":\\"8\\",\\"border-type\\":\\"top\\",\\"margin_bottom_unit\\":\\"%\\"}},{\\"element_id\\":\\"5hhz237\\",\\"cols\\":[{\\"element_id\\":\\"0zak238\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ejo8238\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>North York<\\\\/h3>\\\\n<p>As more of our members moved north of the city to start new lives or families, we committed to a second location in 2012 for our North York community.<\\\\/p>\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"hqvk238\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"+001 416 777 4567\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"qvec238\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"transparent\\",\\"label\\":\\"50 Bogert Ave, North York\\",\\"link_options\\":\\"regular\\"}],\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"border_bottom_width\\":\\"1\\",\\"border_bottom_color\\":\\"#dddddd\\",\\"border-type\\":\\"bottom\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"10\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.13\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"15\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"1\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"1\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"2\\",\\"background_color\\":\\"#ffffff\\",\\"breakpoint_mobile\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_bottom\\":\\"2\\",\\"padding_right\\":\\"2\\",\\"padding_top\\":\\"5\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}},{\\"element_id\\":\\"z4ox238\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ksc4238\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/north-york-church.jpg\\",\\"style_image\\":\\"image-top\\",\\"i_t_sh_color\\":\\"#ffc55f\\",\\"i_t_sh_vOffset_unit\\":\\"px\\",\\"i_t_sh_vOffset\\":\\"15\\",\\"i_t_sh_hOffset_unit\\":\\"px\\",\\"i_t_sh_hOffset\\":\\"15\\",\\"b_sh_color\\":\\"#ffc55f\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"0\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"20\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"20\\",\\"auto_fullwidth\\":\\"1\\",\\"breakpoint_tablet\\":{\\"margin_bottom\\":\\"40\\"},\\"image_zoom_icon\\":\\"\\",\\"width_image\\":\\"580\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"gutter\\":\\"gutter-none\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom\\":\\"9\\",\\"padding_top\\":\\"6\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_image\\":\\"https://themify.me/demo/themes/ultra-church\\\\/files\\\\/2019\\\\/05\\\\/pattern.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"right-frame_location\\":\\"in_bellow\\",\\"right-frame_height_unit\\":\\"%\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"left-frame_location\\":\\"in_bellow\\",\\"left-frame_height_unit\\":\\"%\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"bottom-frame_location\\":\\"in_bellow\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"top-frame_location\\":\\"in_bellow\\",\\"top-frame_height_unit\\":\\"%\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_type\\":\\"top-presets\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_top\\":\\"13\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 394,
  'post_date' => '2019-05-29 05:13:46',
  'post_date_gmt' => '2019-05-29 05:13:46',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h2>Sermons<br/></h2><!--/themify_builder_static-->',
  'post_title' => 'Sermons',
  'post_excerpt' => '',
  'post_name' => 'sermons',
  'post_modified' => '2019-05-30 17:24:30',
  'post_modified_gmt' => '2019-05-30 17:24:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?page_id=394',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'hide_page_title' => 'yes',
    'section_scrolling_mobile' => 'on',
    'mobile_menu_styles' => 'default',
    'query_category' => 'sermon',
    'layout' => 'list-large-image',
    'posts_per_page' => '6',
    'post_filter' => 'no',
    'hide_meta_all' => 'yes',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2ms8235\\",\\"cols\\":[{\\"element_id\\":\\"b9x7236\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"tjgq464\\",\\"mod_settings\\":{\\"heading\\":\\"Sermons\\",\\"text_alignment\\":\\"themify-text-center\\",\\"heading_tag\\":\\"h2\\",\\"margin_bottom\\":\\"30\\",\\"breakpoint_tablet_landscape\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_mobile\\":{\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"0.8\\",\\"font_color_type\\":\\"font_color_solid\\"}}}]}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"4\\"}}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 61,
  'post_date' => '2019-05-23 02:48:28',
  'post_date_gmt' => '2019-05-23 02:48:28',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '61',
  'post_modified' => '2019-05-29 05:14:20',
  'post_modified_gmt' => '2019-05-29 05:14:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=61',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '6',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 60,
  'post_date' => '2019-05-23 02:48:28',
  'post_date_gmt' => '2019-05-23 02:48:28',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '60',
  'post_modified' => '2019-05-29 05:14:20',
  'post_modified_gmt' => '2019-05-29 05:14:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=60',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '57',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 95,
  'post_date' => '2019-05-23 07:44:45',
  'post_date_gmt' => '2019-05-23 07:44:45',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '95',
  'post_modified' => '2019-05-29 05:14:20',
  'post_modified_gmt' => '2019-05-29 05:14:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=95',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '89',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 397,
  'post_date' => '2019-05-29 05:14:20',
  'post_date_gmt' => '2019-05-29 05:14:20',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '397',
  'post_modified' => '2019-05-29 05:14:20',
  'post_modified_gmt' => '2019-05-29 05:14:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=397',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '394',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 382,
  'post_date' => '2019-05-28 22:48:19',
  'post_date_gmt' => '2019-05-28 22:48:19',
  'post_content' => '',
  'post_title' => 'Events',
  'post_excerpt' => '',
  'post_name' => 'events',
  'post_modified' => '2019-05-29 05:14:20',
  'post_modified_gmt' => '2019-05-29 05:14:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=382',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '382',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/ultra-church/events',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 94,
  'post_date' => '2019-05-23 07:44:45',
  'post_date_gmt' => '2019-05-23 07:44:45',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '94',
  'post_modified' => '2019-05-29 05:14:20',
  'post_modified_gmt' => '2019-05-29 05:14:20',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/ultra-church/?p=94',
  'menu_order' => 6,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '92',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_recent-posts" );
$widgets[1002] = array (
  'title' => 'Sermons',
  'number' => 5,
  'show_date' => false,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_media_image" );
$widgets[1003] = array (
  'size' => 'full',
  'width' => 300,
  'height' => 300,
  'caption' => '',
  'alt' => '',
  'link_type' => 'custom',
  'link_url' => 'https://themify.me/',
  'image_classes' => '',
  'link_classes' => '',
  'link_rel' => '',
  'link_target_blank' => false,
  'image_title' => '',
  'attachment_id' => 464,
  'url' => 'https://themify.me/demo/themes/ultra-church/files/2019/05/sermon-banner.jpg',
  'title' => '',
);
update_option( "widget_media_image", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1004] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'type' => '0',
  'timeline_height' => '400',
  'timeline_width' => '300',
  'show_count' => '3',
  'hide_timestamp' => NULL,
  'grid_embed_code' => '',
  'hide_footer' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_themify-feature-posts" );
$widgets[1005] = array (
  'title' => 'Sermons',
  'category' => '0',
  'show_count' => '3',
  'display' => 'none',
  'thumb_width' => '50',
  'thumb_height' => '50',
  'excerpt_length' => '55',
  'orderby' => 'date',
  'order' => 'DESC',
  'show_thumb' => 'on',
);
update_option( "widget_themify-feature-posts", $widgets );

$widgets = get_option( "widget_pages" );
$widgets[1006] = array (
  'title' => 'Links',
  'sortby' => 'post_title',
  'exclude' => '',
);
update_option( "widget_pages", $widgets );

$widgets = get_option( "widget_tribe-events-list-widget" );
$widgets[1007] = array (
  'title' => 'Upcoming Events',
  'limit' => '3',
  'no_upcoming_events' => false,
  'featured_events_only' => false,
  'jsonld_enable' => 1,
);
update_option( "widget_tribe-events-list-widget", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'recent-posts-1002',
    1 => 'media_image-1003',
    2 => 'themify-twitter-1004',
  ),
  'footer-widget-1' => 
  array (
    0 => 'themify-feature-posts-1005',
  ),
  'footer-widget-2' => 
  array (
    0 => 'pages-1006',
  ),
  'footer-widget-3' => 
  array (
    0 => 'tribe-events-list-widget-1007',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:102:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:19:"setting-post_filter";s:2:"no";s:23:"setting-disable_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:35:"setting-default_display_date_inline";s:1:"1";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:37:"setting-default_page_post_layout_type";s:7:"classic";s:40:"setting-default_page_display_date_inline";s:1:"1";s:42:"setting-default_page_single_media_position";s:5:"above";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:40:"setting-custom_post_tglobal_style_single";s:8:"sidebar1";s:40:"setting-custom_post_tribe_events_archive";s:12:"sidebar-none";s:39:"setting-custom_post_tribe_events_single";s:8:"sidebar1";s:38:"setting-default_portfolio_index_layout";s:12:"sidebar-none";s:43:"setting-default_portfolio_index_post_layout";s:5:"grid3";s:29:"setting-portfolio_post_filter";s:3:"yes";s:33:"setting-portfolio_disable_masonry";s:3:"yes";s:24:"setting-portfolio_gutter";s:6:"gutter";s:39:"setting-default_portfolio_index_display";s:4:"none";s:50:"setting-default_portfolio_index_post_meta_category";s:3:"yes";s:49:"setting-default_portfolio_index_unlink_post_image";s:3:"yes";s:39:"setting-default_portfolio_single_layout";s:12:"sidebar-none";s:54:"setting-default_portfolio_single_portfolio_layout_type";s:9:"fullwidth";s:50:"setting-default_portfolio_single_unlink_post_image";s:3:"yes";s:22:"themify_portfolio_slug";s:7:"project";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:17:"header-horizontal";s:28:"setting-exclude_site_tagline";s:2:"on";s:27:"setting-exclude_search_form";s:2:"on";s:19:"setting_search_form";s:11:"live_search";s:19:"setting-exclude_rss";s:2:"on";s:22:"setting-header_widgets";s:17:"headerwidget-3col";s:21:"setting-footer_design";s:15:"footer-left-col";s:27:"setting-exclude_footer_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-3col";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:29:"setting-color_animation_speed";s:1:"5";s:29:"setting-relationship_taxonomy";s:8:"category";s:37:"setting-relationship_taxonomy_entries";s:1:"3";s:45:"setting-relationship_taxonomy_display_content";s:4:"none";s:30:"setting-single_slider_autoplay";s:3:"off";s:27:"setting-single_slider_speed";s:6:"normal";s:28:"setting-single_slider_effect";s:5:"slide";s:28:"setting-single_slider_height";s:4:"auto";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:24:"setting-footer_text_left";s:204:"Encountering the truth in the person of Jesus means that we can walk in freedom, courage, and boldness. It means that we walk in the light and live truthful lives, seen in both what we do and what we say.";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:106:"https://themify.me/demo/themes/ultra-church/wp-content/themes/themify-ultra/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:107:"https://themify.me/demo/themes/ultra-church/wp-content/themes/themify-ultra/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"YouTube";s:31:"setting-link_img_themify-link-2";s:106:"https://themify.me/demo/themes/ultra-church/wp-content/themes/themify-ultra/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:9:"Pinterest";s:31:"setting-link_img_themify-link-3";s:108:"https://themify.me/demo/themes/ultra-church/wp-content/themes/themify-ultra/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-4";s:9:"font-icon";s:33:"setting-link_title_themify-link-4";s:7:"Twitter";s:33:"setting-link_ficon_themify-link-4";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:8:"Facebook";s:33:"setting-link_ficon_themify-link-5";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:7:"YouTube";s:33:"setting-link_ficon_themify-link-6";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-7";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:273:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7"}";s:23:"setting-link_field_hash";s:1:"8";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:6:"church";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();