/*
 ThemifyGradient
 Enhanced version of ClassyGradient, with RGBA support

 Original script written by Marius Stanciu - Sergiu <marius@vox.space>
 Licensed under the MIT license https://vox.SPACE/LICENSE-MIT
 Version 1.1.1

*/
'use strict';(function(e,g,y){e.ThemifyGradient=function(n,A){var z={gradient:e.ThemifyGradient.default,width:173,height:15,point:8,angle:180,circle:!1,type:"linear",onChange:function(){},onInit:function(){}},r=e(n),l,t,p,u,q,w,v,d=[];this.initSwatchesFlag=this.isInit=!1;this.settings={};this.__constructor=function(){this.settings=e.extend({},z,A);this.update();this.settings.onInit();this.isInit=!0;return this};this.updateSettings=function(a){this.settings=e.extend({},z,a);this.update();return this};
this.update=function(){this._setupPoints();this._setup();this._render()};this.getCSSvalue=function(){var a=this.settings.angle+"deg,";"radial"===this.settings.type&&(a=this.settings.circle?"circle,":"");for(var b=[],c=0,k=d.length;c<k;++c)b.push(d[c][1]+" "+d[c][0]);return this.settings.type+"-gradient("+a+b.join(", ")+")"};this.getString=function(){for(var a="",b=0,c=d.length;b<c;++b)a+=d[b][0]+" "+d[b][1]+"|";return a=a.substr(0,a.length-1)};this.setType=function(a){this.settings.type=a;this.settings.onChange(this.getString(),
this.getCSSvalue())};this.setAngle=function(a){this.settings.angle=a;this.settings.onChange(this.getString(),this.getCSSvalue())};this.setRadialCircle=function(a){this.settings.circle=a;this.settings.onChange(this.getString(),this.getCSSvalue())};this._setupPoints=function(){d=[];d=e.isArray(this.settings.gradient)?this.settings.gradient:this._getGradientFromString(this.settings.gradient)};this._setup=function(){var a=this,b=g.createDocumentFragment(),c=g.createDocumentFragment(),k=g.createElement("div"),
f=g.createElement("div"),m=g.createElement("span"),h=g.createElement("canvas"),x=g.createElement("span");q=g.createElement("a");p=g.createElement("div");u=g.createElement("input");l=g.createElement("div");t=g.createElement("div");k.className="themifyGradient";h.width=this.settings.width;h.height=this.settings.height;l.style.width=this.settings.width+Math.round(this.settings.point/2+1)+"px";l.className="points";p.className="point-color";m.className="gradient_delimiter";x.className="gradient_percent";
x.innerHTML="%";u.type="text";u.className="point-position";q.className="gradient-point-delete";q.href="#";f.className="gradient-pointer-info";t.className="content";p.insertAdjacentHTML("afterbegin",'<div style="background-color: #00ff00"></div>');q.insertAdjacentHTML("afterbegin",'<i class="ti-close"></i>');f.insertAdjacentHTML("afterbegin",'<div class="gradient-pointer-arrow"></div>');c.appendChild(p);c.appendChild(m);c.appendChild(u);c.appendChild(x);c.appendChild(q);t.appendChild(c);b.appendChild(l);
b.appendChild(h);f.appendChild(t);b.appendChild(f);k.appendChild(b);for(c=m=x=b=null;n.firstChild;)n.removeChild(n.firstChild);n.appendChild(k);this.initSwatchesFlag||(n.parentNode.appendChild(this.swatchesHTML()),this.initSwatches(),this.initSwatchesFlag=!0);k=f=null;t=e(t);p=e(p);u=e(u);q=e(q);l=e(l);w=h.getContext("2d");h=e(h);h.off("click").on("click",function(b){var c=h.offset(),f="rgba(0,0,0, 1)",k=999999999999;b=b.pageX-c.left;b=Math.round(100*b/a.settings.width);c=0;for(var m=d.length;c<m;++c)d[c][0]=
parseInt(d[c][0]),d[c][0]<b&&b-d[c][0]<k?(k=b-d[c][0],f=d[c][1]):d[c][0]>b&&d[c][0]-b<k&&(k=d[c][0]-b,f=d[c][1]);d.push([b+"%",f]);d.sort(a._sortByPosition);a._render();c=0;for(m=d.length;c<m;++c)d[c][0]===b+"%"&&a._selectPoint(l.find(".point:eq("+c+")"));"visual"===y.mode&&setTimeout(a._colorPickerPosition,315)});this.pointEvents();r[0].addEventListener("keyup",function(a){var b=a.keyCode||a.which||0;8!==b&&46!==b||"INPUT"===window.top.document.activeElement.tagName||(p.siblings(".point-position").focus(),
this.removePoint(a))}.bind(this),{passive:!1})};this.pointEvents=function(){for(var a=this,b=n.getElementsByClassName("point-position"),c=function(b){var c=parseInt(e.trim(this.value));isNaN(c)?c=0:0>c?c=Math.abs(c):98<=c&&(c=98);"focusout"!==b.type?(c=Math.round(c*a.settings.width/100),e(this).closest(".themifyGradient").find(".themify_current_point").css("left",c),a._renderCanvas()):this.value=c},d=0,f=b.length;d<f;++d)b[d].addEventListener("focusout",c,{passive:!0}),b[d].addEventListener("keyup",
c,{passive:!0})};this._render=function(){this._initGradientPoints();this._renderCanvas()};this._colorPickerPosition=function(){var a=ThemifyBuilderCommon.Lightbox.$lightbox,b=t.find(".minicolors"),c=b.find(".minicolors-panel");a.offset().left+a.width()<=c.offset().left+c.width()?b.addClass("tb_minicolors_right"):b.removeClass("tb_minicolors_right")};this._initGradientPoints=function(){for(var a=this,b=g.createDocumentFragment(),c=[],k=function(){a._selectPoint(this);"visual"===y.mode&&(a._colorPickerPosition(),
e(g).trigger("mouseup"))};l[0].firstChild;)l[0].removeChild(l[0].firstChild);for(var f=0,m=d.length;f<m;++f){var h=g.createElement("div");h.className="point";h.style.backgroundColor=d[f][1];h.style.left=parseInt(d[f][0])*a.settings.width/100+"px";h.removeEventListener("click",k,{passive:!0});h.addEventListener("click",k,{passive:!0});b.appendChild(h);c[f]=h}l[0].appendChild(b);f=0;for(m=c.length;f<m;++f)e(c).draggable({axis:"x",containment:"parent",start:function(a,b){r.addClass("tb_gradient_drag").focus()},
stop:function(a,b){r.removeClass("tb_gradient_drag").focus();"visual"===y.mode&&e(g).trigger("mouseup")},drag:function(b,c){a._selectPoint(this,!0);a._renderCanvas()}});c=null};this.hexToRgb=function(a){a=a.replace(/^#?([a-f\d])([a-f\d])([a-f\d])$/i,function(a,c,d,f){return c+c+d+d+f+f});return(a=/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(a))?{r:parseInt(a[1],16),g:parseInt(a[2],16),b:parseInt(a[3],16)}:null};this._selectPoint=function(a,b){var c=this;v=e(a);a=parseInt(v.css("left"));u.val(Math.round(a/
this.settings.width*100));a-=30;0>a&&window.top.document.body.classList.contains("tb_module_panel_docked")&&(a=3);r.find(".gradient-pointer-info").css("marginLeft",a+"px");if(b)return!1;r.focus();v.addClass("themify_current_point").siblings().removeClass("themify_current_point");a=v.css("backgroundColor");b=a.substr(4,a.length);b=b.substr(0,b.length-1);r.find(".point-color div").remove();b=p.find(".themify-color-picker");0===b.length&&(b=e('<input type="text" class="themify-color-picker" />'),b.appendTo(p).minicolors({opacity:!0,
changeDelay:10,change:function(a,b){a=c.hexToRgb(a);a||(a={r:255,g:255,b:255},b=1);v.css("backgroundColor","rgba("+a.r+","+a.g+","+a.b+","+b+")");c._renderCanvas()}}),r.find(".minicolors").first().addClass("minicolors-focus"),q.off("click").on("click",this.removePoint.bind(this)));a=a.replace(/^rgba?\(|\s+|\)$/g,"").split(",");var d=4===a.length?a.pop():1;a=this._rgbToHex(a);b.val(a).attr("data-opacity",d).data("opacity",d).minicolors("settings",{value:a})};this._renderCanvas=function(){var a=n.getElementsByClassName("point");
d=[];for(var b=0,c=a.length;b<c;++b){var e=Math.round(parseInt(a[b].style.left)/this.settings.width*100);d.push([e+"%",a[b].style.backgroundColor])}d.sort(this._sortByPosition);this._renderToCanvas();if(this.isInit)this.settings.onChange(this.getString(),this.getCSSvalue())};this._renderToCanvas=function(){for(var a=w.createLinearGradient(0,0,this.settings.width,0),b=0,c=d.length;b<c;++b)a.addColorStop(parseInt(d[b][0])/100,d[b][1]);w.clearRect(0,0,this.settings.width,this.settings.height);w.fillStyle=
a;w.fillRect(0,0,this.settings.width,this.settings.height)};this._getGradientFromString=function(a){var b=[];a=a.split("|");for(var c=0,d=a.length;c<d;++c){var f=a[c];var e=f.indexOf("%");var g=f.substr(e-3,e);"100"===g||"100%"===g?e="100%":(e=1<e?parseInt(f.substr(e-2,e)):parseInt(f.substr(e-1,e)),e+="%");b.push([e,f.replace(e,"")])}return b};this._rgbToHex=function(a){function b(a){a=parseInt(a,10);if(isNaN(a))return"00";a=Math.max(0,Math.min(a,255));return"0123456789ABCDEF".charAt((a-a%16)/16)+
"0123456789ABCDEF".charAt(a%16)}var c=a[1],d=a[2];return"#"+b(a[0])+b(c)+b(d)};this._sortByPosition=function(a,b){a=parseInt(a[0]);b=parseInt(b[0]);return a<b?-1:a>b?1:0};this.removePoint=function(a){a.preventDefault();1<d.length&&(d.splice(v.index(),1),this._render())};this.swatchesHTML=function(){var a=g.createDocumentFragment(),b=g.createElement("a");b.className="tb_gradient_add_swatch ti-plus";b.href="#";b.addEventListener("click",this.saveSwatch.bind(this));a.appendChild(b);b=g.createElement("div");
b.className="tb_cm_dropdown_icon ti-import";b.tabIndex=1;var c=themifyColorManager.makeImportExportDropdown();c.addEventListener("click",this.swatchesDropdownClicked.bind(this));b.appendChild(c);a.appendChild(b);b=g.createElement("ul");b.className="tb_gradient_swatches";b.addEventListener("click",this.swatchClicked.bind(this));a.appendChild(b);return a};this.swatchesDropdownClicked=function(a){a.preventDefault();a.stopPropagation();a=a.target;var b=a.classList;b.contains("tb_cm_export")?(a.parentNode.parentNode.parentNode.blur(),
g.location.assign(themifyCM.exportGradientsURL)):b.contains("tb_cm_import")&&(a.parentNode.parentNode.parentNode.blur(),themifyColorManager.importColors("gradients"))};this.saveSwatch=function(){if(""===this.getString()||""===this.getCSSvalue())return!1;for(var a=Object.keys(themifyCM.gradients),b=this.getCSSvalue(),c=0;c<a.length;c++)if(themifyCM.gradients[a[c]].css===b)return null;a=themifyColorManager.UID();b={id:a,setting:JSON.parse(JSON.stringify(this.settings)),gradient:this.getString(),css:b,
points:d};themifyCM.gradients[a]=b;this.addSwatch(b);themifyColorManager.updateColorSwatches("gradients")};this.addSwatch=function(a,b){var c=g.createElement("li");c.className="tb_gradient_swatch";c.style.background=a.css;c.dataset.id=a.id;a=g.createElement("span");a.className="tb_delete_swatch ti-close";c.appendChild(a);if(b)b=n.parentElement.getElementsByClassName("tb_gradient_swatches")[0],b.insertBefore(c,b.firstChild);else for(b=ThemifyBuilderCommon.Lightbox.$lightbox[0].getElementsByClassName("tb_gradient_swatches"),
a=0;a<b.length;a++)b[a].insertBefore(c.cloneNode(!0),b[a].firstChild)};this.swatchClicked=function(a){a.preventDefault();a=a.target;var b=a.classList;b.contains("tb_gradient_swatch")?this.selectSwatch(a.dataset.id):b.contains("tb_delete_swatch")&&(this.removeSwatch(a.parentNode.dataset.id),themifyColorManager.updateColorSwatches("gradients"))};this.removeSwatch=function(a){for(var b=ThemifyBuilderCommon.Lightbox.$lightbox[0].querySelectorAll('.tb_gradient_swatch[data-id="'+a+'"]'),c=0;c<b.length;c++)b[c].parentNode.removeChild(b[c]);
delete themifyCM.gradients[a]};this.selectSwatch=function(a){a=themifyCM.gradients[a];this.setAngle(a.setting.angle);this.setRadialCircle(a.setting.circle);this.setType(a.setting.type);this.settings.gradient=a.gradient;this.update();var b=n.parentElement,c=b.getElementsByClassName("themify-gradient-type")[0],d=b.querySelector('input[type="checkbox"]');b=b.getElementsByClassName("themify-gradient-angle")[0];c.value=a.setting.type;Themify.triggerEvent(c,"change");d.checked=a.setting.circle;Themify.triggerEvent(d,
"change");b.value=a.setting.angle;Themify.triggerEvent(b,"change")};this.initSwatches=function(){var a=Object.keys(themifyCM.gradients);themifyCM.gradients=a.length?themifyCM.gradients:{};for(var b=0;b<a.length;b++)this.addSwatch(themifyCM.gradients[a[b]],!0)};return this.__constructor()};e.ThemifyGradient.default="0% rgba(0,0,0, 1)|100% rgba(255,255,255,1)";e.fn.ThemifyGradient=function(g){return this.each(function(){void 0===e(this).data("themifyGradient")&&e(this).data("themifyGradient",new e.ThemifyGradient(this,
g))})}})(jQuery,document,tb_app);
