<?php

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class QualificationTypeTest extends TestCase
{
    use DatabaseMigrations;

    public function setUp()
    {
        parent::setUp();
        $this->withoutMiddleware();
    }
    
    public function testQualificationTypesList()
    {
        factory(\ToStartWork\QualificationType::class, 5)->create();

        $response = $this->json('GET', '/api/qualification/list/types');

        $response->assertResponseOk();
        $this->assertEquals(5, count(json_decode($this->response->content())));
    }
}
