<?php $__env->startSection('javascript'); ?>
    <!-- Redactor -->
    <script src="/vendor/select2/select2.js"></script>
    <script src="/vendor/redactor/redactor.js"></script>
    <script>
        $(document).ready(function() {
            $('.redactor').redactor({
                plugins: ['source'],
                imagePosition: true,
                imageResizable: true
            });
        });
    </script>

    <!-- /.switchery -->
    <script>
        /* Switchery Toggles */
        var js_switch_primary = document.querySelectorAll('.js-switch-primary');
        js_switch_primary.forEach(function(html) {
            var switchery = new Switchery(html, {
                color: '#3498db',
                size: 'small'
            });
        });
    </script>

    <!-- Sweet Alert -->
    <script src="/vendor/sweetalert/lib/sweet-alert.min.js"></script>
    <script>
        $('.delete-course').click(function (e) {
            e.preventDefault();
            swal({
                title: 'Confirm',
                text: "Please confirm you want to delete this course",
                type: 'warning',
                showCancelButton: true,
                confirmButtonColor: 'rgb(168, 67, 23)',
                confirmButtonText: 'Yes, delete it!',
                showLoaderOnConfirm: true

            }, function () {
                setTimeout(function () {
                    $.ajax({
                        url: e.target.href,
                        type: 'delete',
                        data: {_token: '<?php echo e(csrf_token()); ?>'},
                        success: function () {
                            swal({
                                title: 'Deleted!',
                                text: "Course successfully deleted",
                                type: 'success',
                                confirmButtonColor: 'rgb(120, 182, 211)',
                                confirmButtonText: 'OK'
                            }, function () {
                                window.location = "<?php echo e(route('courses.index')); ?>"
                            });
                        }
                    })
                }, 2000);

            });
        });


    </script>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <h2 class="font-light m-b-xs">
                    Edit Course
                </h2>
            </div>
        </div>
    </div>

    <div class="content">

        <?php echo Former::vertical_open()->id('edit-notification')->rules(['name' => 'required'])->method('PUT')->action(route('courses.update', [$course->id])); ?>

        <?php echo Former::populate($course); ?>


        <div class="hpanel">
            <div class="panel-body">
                <div class="form-horizontal">
                    <div class="row">
                        <div class="col-lg-6">
                            <div style="padding-left: 15px; padding-right: 15px">
                                <?php echo Former::text('name')->label('Name'); ?>

                                <?php echo Former::select('provider_id')->label('Provider')->addClass('select2')->fromQuery($providerOptions); ?>

                                <?php echo Former::select('category_id')->label('Category')->addClass('select2')->fromQuery($categoryOptions); ?>

                                <?php echo Former::text('location')->label('Location'); ?>

                                <?php echo Former::date('enroll_date')->label('Enrolment Date'); ?>

                                <?php echo Former::number('price')->label('Price')->prepend('<i class="fa fa-usd"></i>'); ?>

                                <?php echo Former::number('citb_price')->label('CITB Price')->prepend('<i class="fa fa-usd"></i>'); ?>

                                <?php echo Former::checkbox('active')->label('Course Active')->addClass('js-switch-primary'); ?>


                            </div>
                            <div class="row">
                                
                                    
                                
                                <div class="col-sm-6">
                                    <p><strong>Requests:</strong> <?php echo e(count($course->users)); ?></p>
                                </div>
                            </div><!-- /.form-group -->
                        </div>

                        <div class="col-lg-6">
                            <div style="padding-left: 15px; padding-right: 15px">
                                <div class="form-group<?php echo e($errors->has('description') ? ' has-error' : ''); ?>">
                                    <label class="control-label">Description:</label>
                                    <textarea class="redactor" name="description">
                                        <?php echo e($course->description); ?>

                                    </textarea>
                                </div><!-- /.form-group -->
                            </div>
                        </div>
                    </div><!-- /.row -->
                </div><!-- /.form-horizontal -->
            </div>
        </div><!-- /.hpanel -->

        <div class="hpanel">
            <div class="panel-body">
                <a href="<?php echo e(route('courses.destroy', $course->id)); ?>" class="btn btn-danger delete-course pull-right">Delete</a> <button class="btn btn-success">Save Changes</button>
            </div>
        </div><!-- /.hpanel -->

        <?php echo Former::close(); ?>


    </div><!-- /.content -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>