<?php $__env->startSection('javascript'); ?>

        <!-- Redactor -->
<script src="/vendor/redactor/redactor.js"></script>
<script>
    $(document).ready(function() {
        $('.redactor').redactor({
            plugins: ['source'],
            imagePosition: true,
            imageResizable: true
        });
    });
</script>

<!-- Sweet Alert -->
<script src="/vendor/sweetalert/lib/sweet-alert.min.js"></script>
<script>
    $('.alert-send-push').click(function () {
        swal({
            title: 'Confirm',
            text: "Please confirm you want to send this notification",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3498db',
            confirmButtonText: 'Yes, send it!'
        }, function () {
            $("input[name='send']").val(1);
            $("form#edit-notification").submit();
        });
    });


</script>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <h2 class="font-light m-b-xs">
                    Push Notification <?php echo e($notification->title); ?>

                </h2>
            </div>
        </div>
    </div>

    <div class="content">
        <form id="edit-notification" action="<?php echo e(route('notifications.update', [$notification->id])); ?>" method="POST">
            <input name="_method" type="hidden" value="PUT">
            <?php echo e(csrf_field()); ?>

            <input type="hidden" name="send" value="0">

            <div class="hpanel">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="control-label">Status:</label>
                                <p class="form-control-static">
                                    <?php if($notification->status == 'draft'): ?>
                                        Draft
                                    <?php else: ?>
                                        Sent <?php echo e($notification->sent->format('D M Y h:m:s a')); ?>

                                    <?php endif; ?>
                                </p>
                            </div><!-- /.form-group -->
                            <div class="form-group<?php echo e($errors->has('title') ? ' has-error' : ''); ?>">
                                <label class="control-label">Title:</label>
                                <input type="text" class="form-control" name="title" value="<?php echo e($notification->title); ?>" />
                            </div><!-- /.form-group -->
                            <div class="form-group<?php echo e($errors->has('subtitle') ? ' has-error' : ''); ?>">
                                <label class="control-label">Sub Title:</label>
                                <input type="text" class="form-control" name="subtitle" value="<?php echo e($notification->subtitle); ?>" />
                            </div><!-- /.form-group -->
                        </div>
                        <div class="col-lg-6">
                            <div class="form-group">
                                <label class="control-label">Content:</label>
                                <textarea class="redactor" name="content">
                                    <?php echo e($notification->content); ?>

                                </textarea>
                            </div><!-- /.form-group -->
                        </div>
                    </div><!-- /.row -->
                </div>
            </div><!-- /.hpanel -->


            <div class="hpanel">
                <div class="panel-body">
                    <button class="btn btn-default">Save Draft</button> <a href="#" class="btn btn-primary alert-send-push">Send Notification</a>
                </div>
            </div><!-- /.hpanel -->
        </form>

    </div><!-- /.content -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>