<?php $__env->startSection('javascript'); ?>

        <!-- Redactor -->
<script src="vendor/redactor/redactor.js"></script>
<script>
    $(document).ready(function() {
        $('.redactor').redactor({
            plugins: ['source'],
            imagePosition: true,
            imageResizable: true
        });
    });
</script>

<!-- /.switchery -->
<script>
    /* Switchery Toggles */
    var js_switch_primary = document.querySelectorAll('.js-switch-primary');
    js_switch_primary.forEach(function(html) {
        var switchery = new Switchery(html, {
            color: '#3498db',
            size: 'small'
        });
    });
</script>

<!-- Datatables -->
<script>

    $(document).ready(function(){
        $('#table-notifications').DataTable({
            //dom: '<"html5buttons"B>lTfgitp',
            dom: '<"html5buttons"B>fgitp',
            bPaginate: true,
            "columnDefs": [
                { "orderable": false, "targets": [2,3] }
            ],
            "aaSorting": [],
            buttons: [
                {extend: 'copy'},
                {extend: 'csv'},
                {extend: 'excel', title: 'ExampleFile'},
                {extend: 'pdf', title: 'ExampleFile'},

                {extend: 'print',
                    customize: function (win){
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                    }
                }
            ]
        });
    });

</script>


<!-- Sweet Alert -->
<script src="vendor/sweetalert/lib/sweet-alert.min.js"></script>
<script>
    $('.alert-send-push').click(function () {
        swal({
            title: 'Confirm',
            text: "Please confirm you want to send this notification",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3498db',
            confirmButtonText: 'Yes, send it!'
        })
    });
    $('.alert-course-delete').click(function () {
        swal({
            title: 'Are you sure?!',
            text: "Do you want to delete this course?",
            type: 'error',
            showCancelButton: true,
            confirmButtonColor: '#A84317',
            confirmButtonText: 'Yes, delete it!'
        })
    });
    $('.alert-course-delete').click(function () {
        swal({
            title: 'Are you sure?!',
            text: "Do you want to delete this course?",
            type: 'error',
            showCancelButton: true,
            confirmButtonColor: '#A84317',
            confirmButtonText: 'Yes, delete it!'
        })
    });
    $('.alert-category-delete').click(function () {
        swal({
            title: 'Are you sure?!',
            text: "Do you want to delete CATEGORY NAME?",
            type: 'error',
            showCancelButton: true,
            confirmButtonColor: '#A84317',
            confirmButtonText: 'Yes, delete it!'
        })
    });
    $('.alert-category-add').click(function () {
        swal({
                    title: "Add A Category",
                    type: "input",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    animation: "slide-from-top",
                    inputPlaceholder: "Category Name"
                },
                function(inputValue){
                    if (inputValue === false) return false;

                    if (inputValue === "") {
                        swal.showInputError("Please enter a category name!");
                        return false
                    }
                });
    });
    $('.alert-category-edit').click(function () {
        swal({
                    title: "Edit Category Name",
                    type: "input",
                    showCancelButton: true,
                    closeOnConfirm: false,
                    animation: "slide-from-top",
                    inputValue: "CATEGORY NAME",
                    inputPlaceholder: "Category Name"
                },
                function(inputValue){
                    if (inputValue === false) return false;

                    if (inputValue === "") {
                        swal.showInputError("Please enter a category name!");
                        return false
                    }
                });
    });
</script>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-12 col-md-8 col-lg-9">
                        <h2 class="font-light m-b-xs">
                            Push Notifications
                        </h2>
                    </div>
                    <div class="col-sm-12 col-md-4 col-lg-3">
                        <a href="<?php echo e(route('notifications.create')); ?>" class="btn btn-success btn-block form-btn-no-label"><i class="fa fa-plus"></i> New Notification</a>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>
    </div>

    <div class="content">

        <div class="hpanel">
            <div class="panel-body">

                <div class="table-responsive">
                    <table id="table-notifications" class="table table-striped table-bordered table-hover" >
                        <thead>
                        <tr>
                            <th>Title</th>
                            <th>Sub Heading</th>
                            <th>Sent</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                                <tr>
                                    <td><?php echo e($notification->title); ?></td>
                                    <td><?php echo e($notification->subtitle); ?></td>
                                    <td>
                                        <?php echo e($notification->sent ? $notification->sent->format('D M Y h:m:i a') : 'Draft'); ?>

                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('notifications.edit', [$notification->id])); ?>" class="btn btn-info btn-block btn-sm">Edit</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

                        </tbody>
                    </table>

                </div><!-- /.table-responsive -->

            </div>
        </div><!-- /.hpanel -->

    </div><!-- /.content -->


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>