<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title>toStartWork Induction Pack</title>

    <link href="http://fonts.googleapis.com/css?family=Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i"
          rel="stylesheet"/>

    <?php echo $__env->make('pdf.css', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
</head>
<body style="padding-left: 10mm; padding-right: 10mm;" class="fixed-navbar fixed-sidebar">

<?php if($includes['include_personal_details']): ?>
    <h2>Personal Details</h2>

    <?php if($userData['user_image_url']): ?>
        <div class="internal-profile-img" style="background-image: url('<?php echo e($userData['user_image_url']); ?>');"></div>
    <?php endif; ?>

    <div class="<?php echo e($userData['user_image_url'] ? 'has-profile' : ''); ?>">
        <table class="avoid-break">
            <tr>
                <th>First Name:</th>
                <td><?php echo e($userData['first_name']); ?></td>
                <th>Middle Name:</th>
                <td><?php echo e($userData['middle_name']); ?></td>
            </tr>
            <tr>
                <th>Last Name:</th>
                <td><?php echo e($userData['last_name']); ?></td>
                <th>Nickname:</th>
                <td><?php echo e($userData['nickname']); ?></td>
            </tr>
            <tr>
                <th>Gender:</th>
                <td><?php echo e($userData['gender']); ?></td>
                <th>Date of Birth:</th>
                <td><?php echo e($userData['dob']); ?></td>
            </tr>
        </table>
    </div>

    <div class="clear"></div>

    <h3>Contact</h3>

    <table class="avoid-break">
        <tr>
            <th>Phone:</th>
            <td><?php echo e($userData['contact_phone_no']); ?></td>
        </tr>
        <tr>
            <th>Email:</th>
            <td><?php echo e($userData['contact_email']); ?></td>
        </tr>
    </table>

    <?php if($userData['address']): ?>
        <h3>Address</h3>
        <p><?php echo e($userData['address']); ?></p>
    <?php endif; ?>

    <div class="clear"></div>
<?php endif; ?>

<?php if($includes['include_licenses']): ?>
    <h2>Licenses</h2>

    <h3>Training Card</h3>

    <table class="avoid-break">
        <tr>
            <th>ID No.:</th>
            <td><?php echo e($userData['citb_no']); ?></td>
        </tr>
        <tr>
            <th>Expiry Date:</th>
            <td><?php echo e($userData['citb_expiry_date']); ?></td>
        </tr>
    </table>

    <h3>Driver's License</h3>

    <table class="avoid-break">
        <tr>
            <th>License No.:</th>
            <td><?php echo e($userData['drivers_license_no']); ?></td>
        </tr>
        <tr>
            <th>Driver's License Class:</th>
            <td><?php echo e($userData['drivers_license_class']); ?></td>
        </tr>
        <tr>
            <th>Name on License</th>
            <td><?php echo e($userData['drivers_license_name']); ?></td>
        </tr>
        <tr>
            <th>Expiry Date:</th>
            <td><?php echo e($userData['drivers_license_expiry_date']); ?></td>
        </tr>
    </table>

    <div class="clear"></div>
<?php endif; ?>

<?php if($includes['include_medical_information']): ?>
    <h2>Medical Information</h2>
    <table>
        <tr>
            <th>Tetanus injection:</th>
            <td>
                <?php echo e($userData['has_tetanus_injection'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_tetanus_injection'] ? ' - ' . $userData['tetanus_injection_details'] : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Suffers from epilepsy:</th>
            <td>
                <?php echo e($userData['has_epilepsy'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_epilepsy'] ? ' - ' . $userData['epilepsy_details'] : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Suffers from diabetes:</th>
            <td>
                <?php echo e($userData['has_diabetes'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_diabetes'] ? ' - ' . $userData['diabetes_details'] : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Has a heart condition:</th>
            <td>
                <?php echo e($userData['has_heart_condition'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_heart_condition'] ? ' - ' . $userData['heart_condition_details'] : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Other medical conditions:</th>
            <td>
                <?php echo e($userData['has_medical_condition'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_medical_condition'] ? ' - ' . $userData['medical_condition_details'] : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Current medication:</th>
            <td>
                <?php echo e($userData['has_taken_medication'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_taken_medication'] ? ' - ' . $userData['taken_medication_details'] : ''); ?>

            </td>
        </tr>
        <tr>
            <th>Allergies:</th>
            <td>
                <?php echo e($userData['has_allergies'] ? 'Yes' : 'No'); ?>

                <?php echo e($userData['has_allergies'] ? ' - ' . $userData['allergies_details'] : ''); ?>

            </td>
        </tr>
    </table>

    <div class="clear"></div>
<?php endif; ?>

<?php if($includes['include_emergency_contacts']): ?>
    <?php if($userData['emergency_contacts']->count()): ?>
        <h2>Emergency Contacts</h2>

        <?php $__currentLoopData = $userData['emergency_contacts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $contact): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
            <?php if($userData['emergency_contacts']->count() > 1): ?>
                <h3>Person <?php echo e($key + 1); ?></h3>
            <?php endif; ?>

            <table class="avoid-break">
                <tr>
                    <th>Name:</th>
                    <td><?php echo e($contact->name); ?></td>
                </tr>
                <tr>
                    <th>Relationship:</th>
                    <td><?php echo e($contact->relationship); ?></td>
                </tr>
                <tr>
                    <th>Address:</th>
                    <td><?php echo e($contact->address); ?></td>
                </tr>
                <tr>
                    <th>Primary Contact No.:</th>
                    <td><?php echo e($contact->primary_contact); ?></td>
                </tr>
                <tr>
                    <th>Secondary Contact No.:</th>
                    <td><?php echo e($contact->secondary_contact); ?></td>
                </tr>
            </table>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

        <div class="clear"></div>
    <?php endif; ?>
<?php endif; ?>

<?php if($includes['include_employment_details']): ?>
    <?php if($userData['trades']->count() || $userData['employment_details']->count()): ?>
        <h2>Employment Details</h2>

        <?php if($userData['trades']->count()): ?>
            <table class="avoid-break">
                <tr>
                    <th>Trade(s):</th>
                    <td><?php echo e($userData['trades']->implode('name', ', ')); ?></td>
                </tr>
            </table>
        <?php endif; ?>

        <?php if($userData['employment_details']->count()): ?>
            <?php $__currentLoopData = $userData['employment_details']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $detail): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>

                <?php if($userData['employment_details']->count() > 1): ?>
                    <h3>Company <?php echo e($key + 1); ?></h3>
                <?php endif; ?>

                <table class="avoid-break">
                    <tr>
                        <th>Your Company</th>
                        <td><?php echo e($detail->company_name); ?></td>
                    </tr>
                    <tr>
                        <th>Employee</th>
                        <td><?php echo e($detail->employment_status); ?></td>
                    </tr>
                    <tr>
                        <th>Year Started</th>
                        <td><?php echo e($detail->start_year); ?></td>
                    </tr>
                </table>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
        <?php endif; ?>

        <div class="clear"></div>
    <?php endif; ?>
<?php endif; ?>

<?php if(count($qualifications)): ?>
    <div class="page-break"></div>

    <?php $__currentLoopData = $qualifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $qualification): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
        <h2 class="qualification-name"><?php echo e($qualification['name']); ?></h2>

        <table>
            <tr>
                <th>Issue Date:</th>
                <td><?php echo e(array_get($qualification, 'pivot.issue_date')); ?></td>
                <th>Expiry Date:</th>
                <td><?php echo e(array_get($qualification, 'pivot.expiry_date') ? array_get($qualification, 'pivot.expiry_date') : 'n/a'); ?></td>
                <th>Reference No.:</th>
                <td><?php echo e(array_get($qualification, 'pivot.ref_no')); ?></td>
            </tr>
        </table>

        <?php $__currentLoopData = ['front', 'back']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
            
            <?php if(array_get($qualification, "pivot.{$name}_image")): ?>
                <div class="qualification-img">
                    <div class="cell">
                        <img src="<?php echo e($qualification['pivot']["{$name}_image"]); ?>"/>
                    </div>
                </div>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>

        <div class="clear"></div>

        
        <?php if(($key + 1) % 2 === 0): ?>
            <div class="page-break"></div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
<?php endif; ?>

<div class="page-break"></div>

<h1>Terms & Conditions</h1>

<small>
    <p>
        Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aspernatur atque beatae deleniti deserunt earum eos
        explicabo illo, ipsam, iste nam nesciunt nobis obcaecati perspiciatis recusandae voluptate. Aut doloribus,
        voluptatem! A ad alias aliquam ea eum eveniet ex impedit ipsa iusto minima nemo, odit porro quam quia,
        reiciendis repudiandae tempora voluptas voluptate voluptates voluptatum. Adipisci, beatae consectetur cupiditate
        dolorum eveniet, fugiat laboriosam maxime necessitatibus nulla placeat quo sapiente, veritatis voluptate! Hic
        impedit inventore itaque labore neque nesciunt obcaecati! Accusamus animi deserunt error exercitationem magni
        omnis praesentium qui quibusdam quo vitae. Ducimus error illo maiores necessitatibus praesentium rem. A ad
        aliquam animi architecto consequatur cumque deserunt dolor doloremque dolorum earum, impedit inventore ipsam
        labore laboriosam maiores mollitia natus nemo obcaecati odit officia officiis perferendis quam, qui quibusdam
        quis recusandae rem repellat reprehenderit, repudiandae saepe suscipit tempora tenetur unde vel voluptate
        voluptatem voluptatum. Aut consectetur, delectus libero minus natus possimus quis quisquam soluta!
    </p>

    <p>
        Lorem ipsum dolor sit amet, consectetur adipisicing elit. Accusantium adipisci aliquid amet, architecto
        aspernatur atque consequuntur est eveniet exercitationem expedita explicabo facilis hic, id incidunt iste iure
        laudantium maiores nam nisi, nulla officiis optio perspiciatis rem rerum sapiente sint vero voluptates. Aliquid
        aspernatur cumque dicta hic officiis perspiciatis sunt. Adipisci.q
    </p>

    <p>
        Lorem ipsum dolor sit amet, consectetur adipisicing elit. Accusantium assumenda iusto omnis optio placeat
        suscipit. Aperiam assumenda commodi debitis explicabo in incidunt maiores molestiae nemo sit voluptatibus? At
        porro sit soluta? Ab, adipisci amet animi aspernatur, consequatur distinctio eligendi facere fuga illo illum in
        laboriosam modi, officiis quis quisquam quos ratione recusandae reiciendis sint veniam. Delectus distinctio
        expedita hic in ipsum iste libero necessitatibus nobis perspiciatis, quaerat recusandae vitae. Consequuntur
        culpa doloribus et facilis impedit obcaecati, quae quo quod ratione, sed unde veniam. Deleniti deserunt dolorem
        ea enim est iste itaque, laborum magnam molestias nobis perspiciatis porro praesentium rem repudiandae!
    </p>
</small>

</body>
</html>
