<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| This file is where you may define all of the routes that are handled
| by your application. Just tell Laravel the URIs it should respond
| to using a Closure or controller method. Build something great!
|
*/

Route::get('/password/success', 'Auth\ResetPasswordController@getResetPasswordSuccessPage');

Auth::routes();

Route::group(['middleware' => ['auth', 'admin']], function () {

    Route::get('/', 'HomeController@index');

    Route::model('notification', \ToStartWork\Notification::class);
    Route::model('user', \ToStartWork\User::class);
    Route::model('course', \ToStartWork\Course::class);
    Route::model('provider', \ToStartWork\CourseProvider::class);
    Route::model('category', \ToStartWork\CourseCategory::class);
    Route::model('qualification', \ToStartWork\Qualification::class);

    Route::resource('/notifications', 'NotificationController');
    Route::resource('/users', 'UserController');
    Route::resource('/courses', 'CourseController');
    Route::get('/course-template', 'CourseController@getTemplate');
    Route::get('/course-ids', 'CourseController@getCategoryAndProviderIds');
    Route::post('/course-csv', 'CourseController@uploadCsv');
    Route::resource('/providers', 'ProviderController');
    Route::resource('/categories', 'CategoryController');
    Route::resource('/qualifications', 'QualificationController');
    Route::get('num-of-unapproved-qualifications', 'QualificationController@numOfUnapproved');
    Route::get('/qualifications/{qualification}/archive', ['uses' => 'QualificationController@archive', 'as' => 'qualifications.archive']);

});





