@extends('layouts.app')

@section('javascript')


<!-- Datatables -->
<script>

    $(document).ready(function(){
        $('#table-users').DataTable({
            //dom: '<"html5buttons"B>lTfgitp',
            dom: '<"html5buttons"B>fgitp',
            bPaginate: true,
            "columnDefs": [
                { "orderable": false, "targets": [2,3] }
            ],
            "aaSorting": [],
            buttons: [
                {extend: 'copy'},
                {extend: 'csv'},
                {extend: 'excel', title: 'ExampleFile'},
                {extend: 'pdf', title: 'ExampleFile'},

                {extend: 'print',
                    customize: function (win){
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                    }
                }
            ]
        });
    });

</script>

@endsection

@section('content')
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-12 col-md-8 col-lg-9">
                        <h2 class="font-light m-b-xs">
                            User Management
                        </h2>
                    </div>
                    <div class="col-sm-12 col-md-4 col-lg-3">
                        <a href="{{route('users.create')}}" class="btn btn-success btn-block form-btn-no-label"><i class="fa fa-plus"></i> New User</a>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>
    </div>

    <div class="content">

        <div class="hpanel">
            <div class="panel-body">

                <div class="table-responsive">
                    <table id="table-users" class="table table-striped table-bordered table-hover" >
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Activated</th>
                            <th>Is Admin</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                            @foreach ($users as $user)
                                <tr>
                                    <td>{{$user->name}}</td>
                                    <td>{{$user->email}}</td>
                                    <td>
                                        @if ($user->active)
                                            <span class="label label-info">Active</span>
                                        @else
                                            <span class="label label-warning">Deactivated</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if ($user->is_admin)
                                            <span class="label label-info">Admin</span>
                                        @else
                                            <span class="label label-success">Mobile</span>
                                        @endif
                                    </td>
                                    <td>
                                        <a href="{{route('users.edit', [$user->id])}}" class="btn btn-info btn-block btn-sm">Edit</a>
                                    </td>
                                </tr>
                            @endforeach

                        </tbody>
                    </table>

                </div><!-- /.table-responsive -->

            </div>
        </div><!-- /.hpanel -->

    </div><!-- /.content -->


@endsection
