@extends('layouts.app')

@section('content')
    <div class="normalheader transition animated fadeIn">
        <div class="hpanel">
            <div class="panel-body">
                <div class="row">
                    <div class="col-sm-12 col-md-8 col-lg-9">
                        <h2 class="font-light m-b-xs">
                            Qualification Management
                        </h2>
                    </div>
                </div><!-- /.row -->
            </div>
        </div>
    </div>

    <div class="content">
        <div class="hpanel">
            <div class="panel-body">
                <div class="table-responsive">
                    <table id="table-qualifications" class="table table-striped table-bordered table-hover">
                        <thead>
                        <tr>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Trade Type</th>
                            <th>Is Approved</th>
                            <th>Created By</th>
                            <th>Actions</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach ($qualifications as $qualification)
                            <tr>
                                <td>{{$qualification->name}}</td>
                                <td>{{$qualification->type ? $qualification->type->name : 'General'}}</td>
                                <td>{{$qualification->tradeType ? $qualification->tradeType->name : ''}}</td>
                                <td>
                                    @if ($qualification->is_public)
                                        <span class="label label-success">Yes</span>
                                    @else
                                        <span class="label label-danger">No</span>
                                    @endif
                                </td>
                                <td>{{$qualification->user ? $qualification->user->name : 'System'}}</td>
                                <td>
                                    <a href="{{route('qualifications.edit', [$qualification->id])}}"
                                       class="btn btn-info btn-block btn-sm">Edit</a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div><!-- /.table-responsive -->
            </div>
        </div><!-- /.hpanel -->
    </div><!-- /.content -->
@stop

@section('javascript')
    <script>
        $(document).ready(function () {
            $('#table-qualifications').DataTable({
                //dom: '<"html5buttons"B>lTfgitp',
                dom: '<"html5buttons"B>fgitp',
                bPaginate: true,
                "aaSorting": [],
                buttons: [
                    {extend: 'copy'},
                    {extend: 'csv'},
                    {extend: 'excel', title: 'ExampleFile'},
                    {extend: 'pdf', title: 'ExampleFile'},
                    {
                        extend: 'print',
                        customize: function (win) {
                            $(win.document.body).addClass('white-bg');
                            $(win.document.body).css('font-size', '10px');
                            $(win.document.body).find('table').addClass('compact').css('font-size', 'inherit');
                        }
                    }
                ]
            });
        });
    </script>
@stop

