<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">

    <title>toStartWork Induction Pack</title>

    <link href="http://fonts.googleapis.com/css?family=Roboto:100,100i,300,300i,400,400i,500,500i,700,700i,900,900i"
          rel="stylesheet"/>

    @include('pdf.css')
</head>
<body style="padding-left: 10mm; padding-right: 10mm;" class="fixed-navbar fixed-sidebar">

@if($includes['include_personal_details'])
    <h2>Personal Details</h2>

    @if($userData['user_image_url'])
        <div class="internal-profile-img" style="background-image: url('{{$userData['user_image_url']}}');"></div>
    @endif

    <div class="{{$userData['user_image_url'] ? 'has-profile' : ''}}">
        <table class="avoid-break">
            <tr>
                <th>First Name:</th>
                <td>{{$userData['first_name']}}</td>
                <th>Middle Name:</th>
                <td>{{$userData['middle_name']}}</td>
            </tr>
            <tr>
                <th>Last Name:</th>
                <td>{{$userData['last_name']}}</td>
                <th>Nickname:</th>
                <td>{{$userData['nickname']}}</td>
            </tr>
            <tr>
                <th>Gender:</th>
                <td>{{$userData['gender']}}</td>
                <th>Date of Birth:</th>
                <td>{{$userData['dob']}}</td>
            </tr>
        </table>
    </div>

    <div class="clear"></div>

    <h3>Contact</h3>

    <table class="avoid-break">
        <tr>
            <th>Phone:</th>
            <td>{{$userData['contact_phone_no']}}</td>
        </tr>
        <tr>
            <th>Email:</th>
            <td>{{$userData['contact_email']}}</td>
        </tr>
    </table>

    @if($userData['address'])
        <h3>Address</h3>
        <p>{{$userData['address']}}</p>
    @endif

    <div class="clear"></div>
@endif

@if($includes['include_licenses'])
    <h2>Licenses</h2>

    <h3>Training Card</h3>

    <table class="avoid-break">
        <tr>
            <th>ID No.:</th>
            <td>{{$userData['citb_no']}}</td>
        </tr>
        <tr>
            <th>Expiry Date:</th>
            <td>{{$userData['citb_expiry_date']}}</td>
        </tr>
    </table>

    <h3>Driver's License</h3>

    <table class="avoid-break">
        <tr>
            <th>License No.:</th>
            <td>{{$userData['drivers_license_no']}}</td>
        </tr>
        <tr>
            <th>Driver's License Class:</th>
            <td>{{$userData['drivers_license_class']}}</td>
        </tr>
        <tr>
            <th>Name on License</th>
            <td>{{$userData['drivers_license_name']}}</td>
        </tr>
        <tr>
            <th>Expiry Date:</th>
            <td>{{$userData['drivers_license_expiry_date']}}</td>
        </tr>
    </table>

    <div class="clear"></div>
@endif

@if($includes['include_medical_information'])
    <h2>Medical Information</h2>
    <table>
        <tr>
            <th>Tetanus injection:</th>
            <td>
                {{$userData['has_tetanus_injection'] ? 'Yes' : 'No'}}
                {{$userData['has_tetanus_injection'] ? ' - ' . $userData['tetanus_injection_details'] : ''}}
            </td>
        </tr>
        <tr>
            <th>Suffers from epilepsy:</th>
            <td>
                {{$userData['has_epilepsy'] ? 'Yes' : 'No'}}
                {{$userData['has_epilepsy'] ? ' - ' . $userData['epilepsy_details'] : ''}}
            </td>
        </tr>
        <tr>
            <th>Suffers from diabetes:</th>
            <td>
                {{$userData['has_diabetes'] ? 'Yes' : 'No'}}
                {{$userData['has_diabetes'] ? ' - ' . $userData['diabetes_details'] : ''}}
            </td>
        </tr>
        <tr>
            <th>Has a heart condition:</th>
            <td>
                {{$userData['has_heart_condition'] ? 'Yes' : 'No'}}
                {{$userData['has_heart_condition'] ? ' - ' . $userData['heart_condition_details'] : ''}}
            </td>
        </tr>
        <tr>
            <th>Other medical conditions:</th>
            <td>
                {{$userData['has_medical_condition'] ? 'Yes' : 'No'}}
                {{$userData['has_medical_condition'] ? ' - ' . $userData['medical_condition_details'] : ''}}
            </td>
        </tr>
        <tr>
            <th>Current medication:</th>
            <td>
                {{$userData['has_taken_medication'] ? 'Yes' : 'No'}}
                {{$userData['has_taken_medication'] ? ' - ' . $userData['taken_medication_details'] : ''}}
            </td>
        </tr>
        <tr>
            <th>Allergies:</th>
            <td>
                {{$userData['has_allergies'] ? 'Yes' : 'No'}}
                {{$userData['has_allergies'] ? ' - ' . $userData['allergies_details'] : ''}}
            </td>
        </tr>
    </table>

    <div class="clear"></div>
@endif

@if($includes['include_emergency_contacts'])
    @if($userData['emergency_contacts']->count())
        <h2>Emergency Contacts</h2>

        @foreach($userData['emergency_contacts'] as $key => $contact)
            @if($userData['emergency_contacts']->count() > 1)
                <h3>Person {{$key + 1}}</h3>
            @endif

            <table class="avoid-break">
                <tr>
                    <th>Name:</th>
                    <td>{{$contact->name}}</td>
                </tr>
                <tr>
                    <th>Relationship:</th>
                    <td>{{$contact->relationship}}</td>
                </tr>
                <tr>
                    <th>Address:</th>
                    <td>{{$contact->address}}</td>
                </tr>
                <tr>
                    <th>Primary Contact No.:</th>
                    <td>{{$contact->primary_contact}}</td>
                </tr>
                <tr>
                    <th>Secondary Contact No.:</th>
                    <td>{{$contact->secondary_contact}}</td>
                </tr>
            </table>
        @endforeach

        <div class="clear"></div>
    @endif
@endif

@if($includes['include_employment_details'])
    @if($userData['trades']->count() || $userData['employment_details']->count())
        <h2>Employment Details</h2>

        @if($userData['trades']->count())
            <table class="avoid-break">
                <tr>
                    <th>Trade(s):</th>
                    <td>{{$userData['trades']->implode('name', ', ')}}</td>
                </tr>
            </table>
        @endif

        @if($userData['employment_details']->count())
            @foreach($userData['employment_details'] as $key => $detail)

                @if($userData['employment_details']->count() > 1)
                    <h3>Company {{$key + 1}}</h3>
                @endif

                <table class="avoid-break">
                    <tr>
                        <th>Your Company</th>
                        <td>{{$detail->company_name}}</td>
                    </tr>
                    <tr>
                        <th>Employee</th>
                        <td>{{$detail->employment_status}}</td>
                    </tr>
                    <tr>
                        <th>Year Started</th>
                        <td>{{$detail->start_year}}</td>
                    </tr>
                </table>
            @endforeach
        @endif

        <div class="clear"></div>
    @endif
@endif

@if(count($qualifications))
    <div class="page-break"></div>

    @foreach($qualifications as $key => $qualification)
        <h2 class="qualification-name">{{$qualification['name']}}</h2>

        <table>
            <tr>
                <th>Issue Date:</th>
                <td>{{array_get($qualification, 'pivot.issue_date')}}</td>
                <th>Expiry Date:</th>
                <td>{{array_get($qualification, 'pivot.expiry_date') ? array_get($qualification, 'pivot.expiry_date') : 'n/a'}}</td>
                <th>Reference No.:</th>
                <td>{{array_get($qualification, 'pivot.ref_no')}}</td>
            </tr>
        </table>

        @foreach(['front', 'back'] as $name)
            {{-- if qualification has front or back image, add a new page --}}
            @if(array_get($qualification, "pivot.{$name}_image"))
                <div class="qualification-img">
                    <div class="cell">
                        <img src="{{$qualification['pivot']["{$name}_image"]}}"/>
                    </div>
                </div>
            @endif
        @endforeach

        <div class="clear"></div>

        {{-- maximum 2 qualifications per page --}}
        @if(($key + 1) % 2 === 0)
            <div class="page-break"></div>
        @endif
    @endforeach
@endif

<div class="page-break"></div>

<h1>Terms & Conditions</h1>

<small>
    <p>
        Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aspernatur atque beatae deleniti deserunt earum eos
        explicabo illo, ipsam, iste nam nesciunt nobis obcaecati perspiciatis recusandae voluptate. Aut doloribus,
        voluptatem! A ad alias aliquam ea eum eveniet ex impedit ipsa iusto minima nemo, odit porro quam quia,
        reiciendis repudiandae tempora voluptas voluptate voluptates voluptatum. Adipisci, beatae consectetur cupiditate
        dolorum eveniet, fugiat laboriosam maxime necessitatibus nulla placeat quo sapiente, veritatis voluptate! Hic
        impedit inventore itaque labore neque nesciunt obcaecati! Accusamus animi deserunt error exercitationem magni
        omnis praesentium qui quibusdam quo vitae. Ducimus error illo maiores necessitatibus praesentium rem. A ad
        aliquam animi architecto consequatur cumque deserunt dolor doloremque dolorum earum, impedit inventore ipsam
        labore laboriosam maiores mollitia natus nemo obcaecati odit officia officiis perferendis quam, qui quibusdam
        quis recusandae rem repellat reprehenderit, repudiandae saepe suscipit tempora tenetur unde vel voluptate
        voluptatem voluptatum. Aut consectetur, delectus libero minus natus possimus quis quisquam soluta!
    </p>

    <p>
        Lorem ipsum dolor sit amet, consectetur adipisicing elit. Accusantium adipisci aliquid amet, architecto
        aspernatur atque consequuntur est eveniet exercitationem expedita explicabo facilis hic, id incidunt iste iure
        laudantium maiores nam nisi, nulla officiis optio perspiciatis rem rerum sapiente sint vero voluptates. Aliquid
        aspernatur cumque dicta hic officiis perspiciatis sunt. Adipisci.q
    </p>

    <p>
        Lorem ipsum dolor sit amet, consectetur adipisicing elit. Accusantium assumenda iusto omnis optio placeat
        suscipit. Aperiam assumenda commodi debitis explicabo in incidunt maiores molestiae nemo sit voluptatibus? At
        porro sit soluta? Ab, adipisci amet animi aspernatur, consequatur distinctio eligendi facere fuga illo illum in
        laboriosam modi, officiis quis quisquam quos ratione recusandae reiciendis sint veniam. Delectus distinctio
        expedita hic in ipsum iste libero necessitatibus nobis perspiciatis, quaerat recusandae vitae. Consequuntur
        culpa doloribus et facilis impedit obcaecati, quae quo quod ratione, sed unde veniam. Deleniti deserunt dolorem
        ea enim est iste itaque, laborum magnam molestias nobis perspiciatis porro praesentium rem repudiandae!
    </p>
</small>

</body>
</html>
